package com.bxm.adsmanager.web.controller.precharge;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeCorrectSearchDTO;
import com.bxm.adsmanager.model.dao.precharge.PrechargeCorrectRecord;
import com.bxm.adsmanager.model.dto.PrechargeCorrectDTO;
import com.bxm.adsmanager.model.vo.PrechargeCorrectVo;
import com.bxm.adsmanager.service.precharge.PrechargeCorrectService;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * 预付修正数据
 * @author tangx
 * @date 2020/5/12 14:46
 */
@RestController
@RequestMapping("/precharge/correct")
@Slf4j
public class PrechargeCorrectController extends BaseController {

    @Autowired
    private PrechargeCorrectService prechargeCorrectService;


    /**
     * 修正数据
     * @param dto
     * @return
     */
    @PostMapping("/add")
    public ResultModel add(@Validated PrechargeCorrectDTO dto) {
        if (dto.getCorrectAmount().compareTo(BigDecimal.ZERO) <= 0) {
            return ResultModelFactory.FAILED400("请输入大于0的整数");
        }
        if (!dto.getCorrectType().equals(PrechargeCorrectRecord.CORRECT_TYPE_PLUS) && !dto.getCorrectType().equals(PrechargeCorrectRecord.CORRECT_TYPE_SUBTRACT)) {
            return ResultModelFactory.FAILED400("修正类型有误");
        }
        dto.setCreateUser(RequestUtils.getCurrentRealName());
        try {
            prechargeCorrectService.add(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED400(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 操作日志
     * @param searchDTO
     * @return
     */
    @GetMapping("/logs")
    public ResultModel getRecordList(PrechargeCorrectSearchDTO searchDTO) {
        if (null == searchDTO.getAccountId()) {
            return ResultModelFactory.FAILED400("accountId为空");
        }
        List<PrechargeCorrectVo> list = prechargeCorrectService.getRecordList(searchDTO).getList();
        return ResultModelFactory.SUCCESS(list);
    }

}
