package com.bxm.adsmanager.web.controller.precharge;

import com.bxm.adsmanager.model.dao.precharge.PrechargeRecord;
import com.bxm.adsmanager.model.vo.PrechargePositionConsumeVo;
import com.bxm.adsmanager.model.vo.PrechargeRecordVo;
import com.bxm.adsmanager.model.vo.adprofit.AdProfitMediaVo;
import com.bxm.adsmanager.service.precharge.PrechargeDetailService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 预充 明细列表
 * @author tangx
 * @date 2020/5/13 14:46
 */
@RestController
@RequestMapping("/precharge/detail")
public class PrechargeDetailController {

    @Autowired
    private PrechargeDetailService prechargeDetailService;


    @GetMapping("/consume/list")
    public ResultModel listConsumeDetail(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                         @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                         @RequestParam("startTime") String startTime,
                                         @RequestParam("endTime") String endTime,
                                         @RequestParam(value = "accountId") Long accountId,
                                         @RequestParam(value = "position", required = false) String position) {
        PageInfo pageInfo = prechargeDetailService.listConsumeDetail(pageNum, pageSize, startTime, endTime, accountId, position);
        return ResultModelFactory.SUCCESS(pageInfo);
    }

    @GetMapping("/recharge/list")
    public ResultModel listRechargeDetail(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                          @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                          @RequestParam("startTime") String startTime,
                                          @RequestParam("endTime") String endTime,
                                          @RequestParam("accountId") Long accountId) {
        PageInfo<PrechargeRecordVo> pageInfo = prechargeDetailService.listRechargeDetail(pageNum, pageSize, startTime, endTime, accountId);
        return ResultModelFactory.SUCCESS(pageInfo);
    }

    @GetMapping("/consume/export")
    public void exportConsumeDetail(@RequestParam("startTime") String startTime,
                                           @RequestParam("endTime") String endTime,
                                           @RequestParam(value = "accountId") Long accountId,
                                           @RequestParam(value = "position", required = false) String position,
                                           HttpServletResponse response) {
        PageInfo<PrechargePositionConsumeVo> pageInfo = prechargeDetailService.listConsumeDetail(1, 10000, startTime, endTime, accountId, position);
        List list = pageInfo.getList();
        ExcelUtil.exportExcel(list, null, "消耗明细", PrechargePositionConsumeVo.class, "预充管理消耗明细导出"+".xls", response);
    }

    @GetMapping("/recharge/export")
    public void  exportRechargeDetail( @RequestParam("startTime") String startTime,
                                       @RequestParam("endTime") String endTime,
                                       @RequestParam(value = "accountId") Long accountId,
                                       HttpServletResponse response) {
        PageInfo<PrechargeRecordVo> pageInfo = prechargeDetailService.listRechargeDetail(1, 10000, startTime, endTime, accountId);
        List<PrechargeRecordVo> list = pageInfo.getList();

        ExcelUtil.exportExcel(list, null, "充值明细", PrechargeRecordVo.class, "预充管理充值明细导出"+".xls", response);
    }

}
