package com.bxm.adsmanager.web.controller.precharge;

import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.facade.model.precharge.PrechargeDTO;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.PrechargeConfigVo;
import com.bxm.adsmanager.service.precharge.PrechargeService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.utils.response.ResultModel;
import com.bxm.warcar.utils.response.ResultModelFactory;
import com.bxm.warcar.validate.ValidateException;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author tangx
 * @date 2020/5/12 14:46
 */
@RestController
@RequestMapping("/precharge")
@Slf4j
public class PrechargeNewController {

    @Autowired
    private PrechargeService prechargeService;


    /**
     * 账户列表
     * @param pageNum
     * @param pageSize
     * @param account
     * @param providerKeyword
     * @param correctStatus
     * @return
     */
    @GetMapping("/config/list")
    public ResultModel listPrechargeConfig(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                           @RequestParam(value = "pageSize", required = false, defaultValue = "20") Integer pageSize,
                                           @RequestParam(value = "account", required = false) String account,
                                           @RequestParam(value = "providerKeyword", required = false) String providerKeyword,
                                           @RequestParam(value = "correctStatus", required = false) Byte correctStatus,
                                           @RequestParam(value ="dateTime",required = false) String dateTime) {
        // 控制权限
        // 媒介经理可以查看所有记录
        // 媒介运营仅查看包含自己的记录
        UserVo currentUser = RequestUtils.getCurrentUser();
        List<String> roleCodes = currentUser.getRoleCodes();
        String mjCode = "";
        if (!roleCodes.contains(RoleEnum.MJLEADER.getCode()) && roleCodes.contains(RoleEnum.MJ.getCode())) {
            mjCode = currentUser.getUsername();
        }

        PageInfo pageInfo = prechargeService.listPrechargeConfig(pageNum, pageSize, account, providerKeyword, correctStatus,dateTime, mjCode, null);
        return ResultModelFactory.SUCCESS(pageInfo);
    }

    /**
     * 账户添加
     * @param dto
     * @return
     */
    @PostMapping("/config/add")
    @LogBefore(operType = "/precharge/config/add", keyName = "新增预付配置")
    public ResultModel addPrechargeConfig(@Validated PrechargeDTO dto) {

        try {
            prechargeService.addPrechargeConfig(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (Exception e) {
            log.info(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }

    /**
     * 账户编辑
     * @param dto
     * @return
     */
    @PostMapping("/config/update")
    @LogBefore(operType = "/precharge/config/update", keyName = "编辑预付配置")
    public ResultModel updatePrechargeConfig(@Validated PrechargeDTO dto) {

        try {
            prechargeService.updatePrechargeConfig(dto);
        } catch (BusinessException e) {
            return ResultModelFactory.FAILED500(e.getMessage());
        } catch (ValidateException e) {
            return ResultModelFactory.FAILED400(e.getMessage());
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return ResultModelFactory.FAILED500("服务器错误");
        }
        return ResultModelFactory.SUCCESS();
    }


    /**
     * 账户列表导出
     * @param account
     * @param positionName
     * @param correctStatus
     * @param response
     */
    @GetMapping("/config/export")
    public void exportPrechargeConfig(@RequestParam(value = "account", required = false) String account,
                                      @RequestParam(value = "positionName", required = false) String positionName,
                                      @RequestParam(value = "correctStatus", required = false) Byte correctStatus,
                                      @RequestParam(value ="dateTime",required = false) String dateTime,
                                      HttpServletResponse response) {
        PageInfo<PrechargeConfigVo> pageInfo = prechargeService.listPrechargeConfig(1, 10000, account, positionName, correctStatus,dateTime, null, null);
        List<PrechargeConfigVo> list = pageInfo.getList();

        list.forEach(l -> {
                    if (l.getCorrectStatus() != null) {
                        switch (l.getCorrectStatus()) {
                            case 0:
                                l.setCorrectStatusForExcel("待审核");
                                break;
                            case 1:
                                l.setCorrectStatusForExcel("审核成功");
                                break;
                            case 2:
                                l.setCorrectStatusForExcel("审核失败");
                                break;
                        }
                    }
                }
        );
        ExcelUtil.exportExcel(list, null, "预付管理列表", PrechargeConfigVo.class, "预付管理列表导出"+".xls", response);
    }

}
