/*
 * Copyright ${YEAR} bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.controller.report;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketOcpcConf;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.ocpc.OcpcStatisticsConditionDto;
import com.bxm.adsmanager.model.vo.report.OcpcOffersVo;
import com.bxm.adsmanager.model.vo.report.OcpcStatisticsVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketOcpcService;
import com.bxm.adsmanager.service.datapark.DataparkOcpcService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmanager.web.convert.report.OcpcOffersConvert;
import com.bxm.adsmanager.web.convert.report.OcpcStatisticsConvert;
import com.bxm.adsmedia.facade.enumdata.MediaTypeEnum;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ocpc.OcpcOffers;
import com.bxm.datapark.facade.ocpc.OcpcOffersCondition;
import com.bxm.datapark.facade.ocpc.OcpcStatistics;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
@RestController
@RequestMapping("/ocpc")
public class OcpcReportController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(OcpcReportController.class);

    @Autowired
    private DataparkOcpcService dataparkOcpcService;
    @Autowired
    private AdTicketOcpcService adTicketOcpcService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;

    @RequestMapping(value = "/find", method = RequestMethod.POST)
    public ResultModel<Page<OcpcStatisticsVo>> find(OcpcStatisticsConditionDto condition, HttpServletRequest request, HttpServletResponse response) {
        User user = getUser(request,response);
        //根据当前登录的用户角色添加查询权限
        List<Long> ticektIds = Lists.newArrayList();
        ResultModel<Page<OcpcStatisticsVo>> resultModel = new ResultModel<>();
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isAe(user))){
            //根据ae查找他名下的所有ocpc的券
            ticektIds =  adTicketOcpcService.findByAeOrSale(user.getUsername(),null);
            if (CollectionUtils.isEmpty(ticektIds)){
                resultModel.setReturnValue(new Page<>());
                return resultModel;
            }
        }
        if (StringUtils.isNotBlank(UserRoleCodeUtil.isSale(user))){
            //根据sale找到他名下关联的广告主从而关联到券
            AdvertiserDto advertiserDto = new AdvertiserDto();
            advertiserDto.setSale(user.getUsername());
            try {
                List<AdvertiserDto> advertiserDtos = adShopIntegration.getAdShopList(advertiserDto);
                List<Integer> advertiserIds = Lists.newArrayList();
                if (CollectionUtils.isEmpty(advertiserDtos)){
                    resultModel.setReturnValue(new Page<>());
                    return resultModel;
                }
                for (AdvertiserDto advertiserDtoTemp:advertiserDtos){
                    advertiserIds.add(advertiserDtoTemp.getId());
                }
                ticektIds =  adTicketOcpcService.findByAeOrSale(null,advertiserIds);
                if (CollectionUtils.isEmpty(ticektIds)){
                    resultModel.setReturnValue(new Page<>());
                    return resultModel;
                }
            }catch (Exception e){
                LOGGER.error(e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty(ticektIds)){
            String tickets = JSON.toJSONString(ticektIds);
            condition.setTicketIds(tickets);
        }

        if(condition != null && (StringUtils.isNotBlank(condition.getMediaType()) || StringUtils.isNotBlank(condition.getMediaClassId()) ||
                StringUtils.isNotBlank(condition.getMediaChildClassId()))){
            //查询广告位ID
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setMediaSysType(condition.getMediaType());
            if (StringUtils.isNotBlank(condition.getMediaClassId()) && StringUtils.isNumeric(condition.getMediaClassId())) {
                paramDTO.setMediaClassId(Long.valueOf(condition.getMediaClassId()));
            }
            if (StringUtils.isNotBlank(condition.getMediaChildClassId()) && StringUtils.isNumeric(condition.getMediaChildClassId())) {
                paramDTO.setMediaChildClassId(Long.valueOf(condition.getMediaChildClassId()));
            }
            List<String> positionIds = newAppEntranceFacadeIntegration.getAllPositionIds(paramDTO);
            if(CollectionUtils.isNotEmpty(positionIds)){
                condition.setPositionIdList(positionIds);
            }else {
                resultModel.setReturnValue(new Page<>());
                return resultModel;
            }
        }
        Page<OcpcStatistics> result = dataparkOcpcService.find(condition);

        List<OcpcStatisticsVo> voList = Lists.newArrayList();
        List<OcpcStatistics> list = result.getList();
        for (OcpcStatistics orig : list) {
            OcpcStatisticsVo vo = OcpcStatisticsConvert.convert(orig);
            Integer ticketid = orig.getTicketid();
            if (null != ticketid) {
                if (StringUtils.isNotBlank(orig.getPosition())) {
                    boolean closed = dataparkOcpcService.isClosed(String.valueOf(ticketid), orig.getPosition());
                    vo.setStatus(closed ? OcpcStatisticsVo.STATUS_CLOSED : OcpcStatisticsVo.STATUS_OPEN);
                }
                AdTicketOcpcConf conf = adTicketOcpcService.selectByTicketId(TypeHelper.castToLong(ticketid));
                if (null != conf) {
                    vo.setExpectCpa(conf.getCpaExpectPrice());
                }
            }
            voList.add(vo);
        }
        voList = generateResultData(voList);
        return ResultModelFactory.SUCCESS(new Page<OcpcStatisticsVo>(voList, result.getPageNum(), result.getPageSize(), result.getTotal()));
    }

    @RequestMapping(value = "/offers")
    public ResultModel<Page<OcpcOffersVo>> find(OcpcOffersConditionDto condition) {
        OcpcOffersCondition e = OcpcOffersConvert.convert(condition);
        List<OcpcOffersVo> voList = Lists.newArrayList();
        Page<OcpcOffers> result = dataparkOcpcService.find(e);
        List<OcpcOffers> offersList = result.getList();
        if (CollectionUtils.isEmpty(offersList)) {
            return ResultModelFactory.SUCCESS();
        }
        for (OcpcOffers ocpcOffers : offersList) {
            voList.add(OcpcOffersConvert.convert(ocpcOffers));
        }
        return ResultModelFactory.SUCCESS(new Page<OcpcOffersVo>(voList, result.getPageNum(), result.getPageSize(), result.getTotal()));
    }

    @RequestMapping("/reset")
    public ResultModel reset(String position, String ticketid) {
        return ResultModelFactory.FAIL400("方法已被遗弃");
    }

    public static class OcpcOffersConditionDto {

        private Integer ticketid;
        private String position;
        private String start;
        private String end;

        private Integer pageNum = 1;
        private Integer pageSize = 20;

        public Integer getTicketid() {
            return ticketid;
        }

        public void setTicketid(Integer ticketid) {
            this.ticketid = ticketid;
        }

        public String getPosition() {
            return position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public String getStart() {
            return start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public Integer getPageNum() {
            return pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    /**
     * @Description 结果数据封装
     * @param resultList
     * @return List<OcpcStatisticsVo>
     */
    private List<OcpcStatisticsVo> generateResultData(List<OcpcStatisticsVo> resultList){
        if(CollectionUtils.isNotEmpty(resultList)){
            //获取广告位ID
            List<String> positionIds = new ArrayList<>();
            resultList.forEach(ocpcStatisticsVo -> {
                positionIds.add(ocpcStatisticsVo.getPosition());
            });
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            paramDTO.setPositionIds(positionIds);
            List<AppEntranceAdRO> positionDataList = newAppEntranceFacadeIntegration.getAllList(paramDTO);
            //广告位ID-媒体类型
            HashMap<String, String> mediaTypeMap = new HashMap<String, String>();
            //广告位ID-媒体分类
            HashMap<String, String> mediaClassMap = new HashMap<String, String>();
            //广告位ID-媒体子分类
            HashMap<String, String> mediaChildClassMap = new HashMap<String, String>();
            if (!CollectionUtils.isEmpty(positionDataList)) {
                positionDataList.forEach(appEntranceAdRo -> {
                    String positionId = appEntranceAdRo.getPositionId();
                    if (null != appEntranceAdRo.getMediaClassId()) {
                        mediaClassMap.put(positionId,  appEntranceAdRo.getMediaClassName());
                    }
                    if (null != appEntranceAdRo.getMediaChildClassId()) {
                        mediaChildClassMap.put(positionId, appEntranceAdRo.getMediaChildClassName());
                    }
                    mediaTypeMap.put(positionId,appEntranceAdRo.getMediaSysType());
                });
            }
            //字段翻译
            resultList.forEach(ocpcStatisticsVo -> {
                String positionId = ocpcStatisticsVo.getPosition();
                ocpcStatisticsVo.setMediaClass(mediaClassMap.get(positionId));
                ocpcStatisticsVo.setMediaChildClass(mediaChildClassMap.get(positionId));
                ocpcStatisticsVo.setMediaTypeName(MediaTypeEnum.getMediaTypeNameByCode(mediaTypeMap.get(positionId)));
            });
            return resultList;
        }
        return Collections.emptyList();
    }

}
