package com.bxm.adsmanager.web.controller.rta;

import com.bxm.adsmanager.model.dto.rta.RtaDto;
import com.bxm.adsmanager.model.dto.rta.RtaSearchDto;
import com.bxm.adsmanager.model.vo.rta.RtaVo;
import com.bxm.adsmanager.service.rta.RtaService;
import com.bxm.adsmanager.service.rta.impl.RtaServiceImpl;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.utils.response.ResponseModel;
import com.github.pagehelper.PageInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author tangx
 * @date 2022/8/15 14:02
 */
@RestController
@RequestMapping("/rtaConfig")
public class RtaController {

    @Autowired
    private RtaService rtaService;

    @GetMapping("/page")
    public ResultModel page(RtaSearchDto rtaSearchDto) {
        PageInfo<RtaVo> page = rtaService.page(rtaSearchDto);
        return ResultModelFactory.SUCCESS(page);
    }

    @PostMapping("/create")
    public ResultModel create(@RequestBody @Validated RtaDto rtaDto) {
        rtaService.create(rtaDto);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/update")
    public ResultModel update(@RequestBody @Validated() RtaDto rtaDto) {
        rtaService.update(rtaDto);
        return ResultModelFactory.SUCCESS();
    }

    @GetMapping("/updateStatus")
    public ResultModel updateStatus(@RequestParam("id") Integer id, @RequestParam("status") Byte status) {
        rtaService.updateStatus(id, status);
        return ResultModelFactory.SUCCESS();
    }

}
