package com.bxm.adsmanager.web.controller.sys;

import com.bxm.adsmanager.service.sys.SysService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import lombok.Data;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

/**
 * 系统配置。
 *
 * @author allen
 * @date 2022-09-14
 * @since 1.0
 */
@RestController
@RequestMapping("/sys")
public class SysController {

    private final SysService sysService;

    public SysController(SysService sysService) {
        this.sysService = sysService;
    }

    @GetMapping("/list")
    public ResultModel list() {
        SysVo vo = new SysVo();
        vo.setData(new TreeMap<>(sysService.getAll()));
        return ResultModelFactory.SUCCESS(vo);
    }

    @GetMapping("/get")
    public ResultModel get(@RequestParam("key") String key) {
        return ResultModelFactory.SUCCESS(sysService.get(key));
    }

    @PostMapping("/update")
    public ResultModel update(@RequestParam("key") String key,
                              @RequestParam("value") String value) {
        sysService.put(key, value);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping("/delete")
    public ResultModel delete(@RequestParam("key") String key) {
        sysService.delete(key);
        return ResultModelFactory.SUCCESS();
    }

    @Data
    public static class SysVo implements Serializable {

        private Map<String, String> data;
    }
}
