package com.bxm.adsmanager.web.controller.tbladtag;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.dao.tbltag.TblAdPostionTag;
import com.bxm.adsmanager.model.dto.tbltag.TblAdTagDto;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagDropdownBoxVo;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.CollectionDataCopyUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;

/**
 * @author gaoshihao
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.tbladtag.TblAdTagController.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-25 20:04:00
 * @modifier ganquan
 * @updated 2018-04-25 20:04:00
 */
@RestController
@RequestMapping("tbladtag/")
public class TblAdTagController extends BaseController {

    private Logger          log = LoggerFactory.getLogger(TblAdTagController.class);

    @Autowired
    private TblAdTagService tblAdTagService;

    /**
     * 根据类型标签列表（带子集合）
     * 
     * @param parentId
     * @param type
     * @return
     */
    @RequestMapping(value = "find/tblAdTagByType", method = RequestMethod.GET)
    public ResultModel<List<TblAdTagVo>> findTblAdTagListByType(@RequestParam(value = "parentId") Integer parentId,
                                                                @RequestParam(value = "type") Integer type) {

        ResultModel<List<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.findTblAdTagListByType(parentId, type));
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }

    /**
     * 根据 父 id 查询列表
     * 
     * @return
     */
    @RequestMapping(value = "find/tblAdTagByParentId")
    public ResultModel<List<TblAdTagVo>> findTblAdTagByParentId(@RequestParam(value = "id") Integer id) {
        ResultModel<List<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.findTblAdTagById(id));
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 修改查询
     * 
     * @param id 需要修改的 id
     * @param type 类型 1 多选标签 2 层级标签
     * @return
     */
    @RequestMapping(value = "update/findEntityById")
    public ResultModel<TblAdTagVo> updateFindById(@RequestParam(value = "id") Integer id,
                                                  @RequestParam(value = "type") Integer type) {
        ResultModel<TblAdTagVo> resultModel = new ResultModel<TblAdTagVo>();
        try {
            resultModel.setReturnValue(tblAdTagService.updateFindTblAdTag(id, type));
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }

    /**
     * 保存标签
     * 
     * @param parentId
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "save/tblAdTag", method = RequestMethod.POST)
    public ResultModel<String> saveTag(@RequestParam(value = "parentId") Integer parentId,
                                       @RequestParam(value = "name") String name,
                                       @RequestParam(value = "typeTag") String typeTag,

                                       HttpServletRequest request, HttpServletResponse response) {
        ResultModel<String> resultModel = new ResultModel<String>();
        try {
            TblAdPostionTag tblAdTag = new TblAdPostionTag();
            tblAdTag.setTypeTag(Integer.valueOf(typeTag));
            tblAdTag.setName(name);
            tblAdTag.setCreateUser(getUser(request, response).getUsername());
            tblAdTag.setParentId(parentId);
            tblAdTag=tblAdTagService.addTag(tblAdTag);
            if (tblAdTag!=null) {
                resultModel.setReturnValue("录入成功！");
                resultModel.setSuccessed(true);
            } else {
                resultModel.setReturnValue("录入失败！");
                resultModel.setSuccessed(false);
            }
            //下面是判断是否插入广告位黑名单标签
            //只有分类标签才判断，并且不是第一级标签，因为第一级标签肯定不会有黑名单存在，只有选了1级的，下面的2级或者3级才会有黑名单标签存在
            if(Integer.valueOf(typeTag) == 2 && parentId !=0 ){
                tblAdTagService.insertMediaTag(parentId, tblAdTag.getCode().toString());
            }

        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("保存失败：" + e.getMessage());
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }

    /**
     * 修改标签
     * 
     * @param tblAdTagDto
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "update/tblAdTag", method = RequestMethod.POST)
    public ResultModel<String> updateTag(TblAdTagDto tblAdTagDto, HttpServletRequest request,
                                         HttpServletResponse response) {
        ResultModel<String> resultModel = new ResultModel<String>();
        if (BeanValidator.validateGroup(tblAdTagDto, TblAdTagDto.Update.class) != null) {

            return ResultModelFactory.FAIL400(BeanValidator.validateGroup(tblAdTagDto,
                                                                          TblAdTagDto.Update.class).getMessage());
        }
        try {
            if (tblAdTagService.updateTag(tblAdTagDto, getUser(request, response).getUsername())) {
                resultModel.setSuccessed(true);
                resultModel.setReturnValue("修改成功！");
            } else {
                resultModel.setSuccessed(false);
                resultModel.setReturnValue("修改失败！");
            }
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("修改失败:" + e.getMessage());
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据 id/name 返回 子标签
     * 
     * @param param
     * @param type
     * @return
     */
    @RequestMapping(value = "find/TblAdTagListByParam", method = RequestMethod.GET)
    public ResultModel<PageInfo<TblAdTagVo>> findTblAdTagListByParam(@RequestParam(value = "param", defaultValue = "") String param,
                                                                     @RequestParam(value = "type", defaultValue = "") String type,
                                                                     @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        PageHelper.startPage(pageNum, pageSize);
        try {
            resultModel.setReturnValue(tblAdTagService.findfindTblAdTagByNameAndID(param, type));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }

    /**
     * 查询所有 标签
     * 
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "find/TblTagAll")
    public ResultModel<PageInfo<TblAdTagVo>> findAllTblTag(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "name", defaultValue = "") String name) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> list = tblAdTagService.findAll(pageNum, pageSize, name);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据 code 查询标签列表
     * 
     * @return
     */
    @RequestMapping(value = "find/TblTagByCodeStr", method = RequestMethod.GET)
    public ResultModel<JSONObject> findTblTagByCodeStr(@RequestParam("codeStr") String codeStr) {
        ResultModel<JSONObject> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.findTblAdTagByCodeStr(codeStr));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据 code 查询标签列表
     * 
     * @return
     */
    @RequestMapping(value = "find/tblTagByFirstCode", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<TblAdTagVo>> tblTagByFirstCode() {
        ResultModel<List<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.tblTagByFirstCode());
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据类型标签列表（分页）
     * 
     * @param parentId
     * @param type（1属性 2 分类 3广告主 4盘古素材标签）
     * @return
     */
    @RequestMapping(value = "find/findNewTreeAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<TblAdTagVo>> findNewTreeAll(@RequestParam(value = "parentId", defaultValue = "0") Integer parentId,
                                                        @RequestParam(value = "type",defaultValue = "1") Integer type,
                                                        @RequestParam(value = "name", defaultValue = "") String name,
                                                        @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                        @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> pag = tblAdTagService.findNewTreeAll(pageNum, pageSize, type, name, parentId);
            resultModel.setReturnValue(pag);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }
    
    /**
     * 查询所有 标签
     * 
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "find/findNewAll")
    public ResultModel<PageInfo<TblAdTagVo>> findNewAll(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "name", defaultValue = "") String name,
                                                           @RequestParam(value = "type",defaultValue = "1") Integer type) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> list = tblAdTagService.findNewAll(pageNum, pageSize, name,type);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }



    /**
     * Description: 查询所以一级标签
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/26 16:41
     */
    @RequestMapping(value = "findOneLevelTag")
    public ResultModel<List<TblAdTagDropdownBoxVo>> findOneLevelTag(Integer tagType){
        if (null == tagType) {
            tagType = CommonConstant.TicketTag.TAG_TYPE_CLASSIFY;
        }
        ResultModel<List<TblAdTagDropdownBoxVo>> resultModel = new ResultModel<>();
        List<TblAdPostionTag> tblAdPostionTags = tblAdTagService.findOneLevelTag(tagType);
        if (CollectionUtils.isEmpty(tblAdPostionTags)) {
            resultModel.setReturnValue(Collections.emptyList());
            return resultModel;
        }
        resultModel.setReturnValue(CollectionDataCopyUtil.copyList(tblAdPostionTags, TblAdTagDropdownBoxVo.class));
        return resultModel;
    }

    /**
     *
     * 功能描述:
     * @fileName:根据一级查二级，根据二级查三级标签
     * @param: [tagCode]
     * @return: com.bxm.util.dto.ResultModel
     * @auther: sunzs
     * @date: 2018/9/26 16:21
     */
    @RequestMapping(value = "/getTagCode",method = RequestMethod.GET)
    public ResultModel<List<TblAdTagDropdownBoxVo>> getTagCode(@RequestParam(value = "tagCode") String tagCode){
        ResultModel<List<TblAdTagDropdownBoxVo>> resultModel = new ResultModel<>();
        List<TblAdPostionTag> list = tblAdTagService.getTagCode(tagCode);
        if (CollectionUtils.isEmpty(list)) {
            resultModel.setReturnValue(Collections.emptyList());
            return resultModel;
        }
        resultModel.setReturnValue(CollectionDataCopyUtil.copyList(list, TblAdTagDropdownBoxVo.class));
        return resultModel;
    }

}
