package com.bxm.adsmanager.web.controller.test;

import com.bxm.adsmanager.service.adposition.AdPositionAuditService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.service.adprofit.UpdateReportCashService;
import com.bxm.adsmanager.service.datapark.DataparkIncomeService;

import javax.annotation.Resource;

/**
 * @FileName package com.bxm.adsmanager.web.controller.test.TestController.java
 * @CopyRright (c) 2017-bxm：杭州微财科技有限公司:
 * @Creator hcmony
 * @Created 2017-11-30 14:14:00
 * @Modifier hcmony
 * @Updated 2017-11-30 14:14:00
 * @Description  做一些测试的使用
 * @Version BUILD1001
 */
@RestController
@RequestMapping("/test")
public class TestController {

	@Autowired
	private UpdateReportCashService updateReportCashService;
	@Autowired
	private DataparkIncomeService dataparkIncomeService;
	@Autowired
	private AdIncomeTicketService adIncomeTicketService;

	@Resource
    private AdPositionAuditService adPositionAuditService;

	@RequestMapping(value = "/updateTicketCash", method = RequestMethod.GET)
	public void updateTicketCash(String datetime)throws Exception{
		updateReportCashService.updateReportCash(datetime);
	}

	@RequestMapping(value = "/updateAppCash", method = RequestMethod.GET)
	public void updateAppCash(String datetime)throws Exception{
		dataparkIncomeService.dealAppCash(datetime);
	}

	@RequestMapping(value = "/updatePositionTicketWeight", method = RequestMethod.GET)
	public void updatePositionTicketWeight(String ticketId,String updateId)throws Exception{
		Long update = NumberUtils.isNumber(updateId) ? Long.valueOf(updateId) : null;
		adIncomeTicketService.updatePositionTicketWeight(NumberUtils.toLong(ticketId),
				update);
	}

	@RequestMapping(value = "/initConfigCache", method = RequestMethod.GET)
	public void initConfigCache()throws Exception{
        adPositionAuditService.initConfigCache();
	}


}
