package com.bxm.adsmanager.web.controller.third;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.vo.weibo.WBToken;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.Date;
import java.util.Map;


@Slf4j
@RestController
public class KSController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(KSController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    private static final String tokenUrl = "https://developers.e.kuaishou.com/tools/authorize";

    /**
     * 快手code 回传接口
     *
     * @return
     */
    @RequestMapping(value = "/ks/code", produces = "application/json")
    public ResultModel<Boolean> save(@RequestParam(value = "auth_code") String auth_code) {
         //https://developers.e.kuaishou.com/tools/authorize?
        // app_id=应用ID&scope=权限范围
        // &redirect_uri=回调地址xxx
        // &state=abcd&oauth_type=授权类型&state=xxx
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            log.error("----auth_code-------"+auth_code);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }


}