package com.bxm.adsmanager.web.controller.third;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouAuthResponse;
import com.bxm.adsmanager.model.vo.kuaishou.KuaishouTokenVo;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.*;


@Slf4j
@RestController
public class KuaishouController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(KuaishouController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    @Qualifier("rtbJedisUpdater")
    private JedisUpdater rtbJedisUpdater;


    private static final String tokenUrl = "https://ad.e.kuaishou.com/rest/openapi/oauth2/authorize/access_token";

    /**
     * 微博code 回传接口
     *
     * @return
     */
    @RequestMapping(value = "/kuaishou/callback", produces = "application/json")
    public String save(@RequestParam(value = "auth_code") String auth_code,
                                     @RequestParam(value = "appKey") String appKey) {

        log.info("kuaishou auth callback auth_code= {}, appKey= {}", auth_code, appKey);

        try {
            String appIdAndSecret = fetcher.hfetch(RedisKeys.hashKuaishouAppIdConfig(), appKey, String.class);

            String appId = null;
            String secret = null;
            if (StringUtils.isNotBlank(appIdAndSecret)) {
                String[] split = appIdAndSecret.split(",");
                appId = split[0];
                secret = split[1];
            }

            if (StringUtils.isBlank(appId)) {
                return "授权失败：请检查是否配置appId";
            }

            //根据code获取token
            Map<String, Object> params = Maps.newHashMap();
            params.put("app_id", appId);
            params.put("secret", secret);
            params.put("auth_code", auth_code);
            String result = OkHttpUtils.postRequestBody(tokenUrl, params, new HashMap<>());
            log.info("kuaishou request token response: {} | appKey :{}", result, appKey);
            KuaishouAuthResponse kuaishouAuthResponse = JsonHelper.convert(result, KuaishouAuthResponse.class);
            if (Objects.nonNull(kuaishouAuthResponse)) {
                if (!Objects.equals(kuaishouAuthResponse.getCode(), 0)) {
                    return null;
                }

                KuaishouAuthResponse.Data data = kuaishouAuthResponse.getData();

                Long exDate = System.currentTimeMillis() + Long.valueOf(data.getAccess_token_expires_in()) * 1000;
                Long refreshExDate = System.currentTimeMillis() + Long.valueOf(data.getRefresh_token_expires_in()) * 1000;

                List<Long> advertiser_ids = data.getAdvertiser_ids();
                String access_token = data.getAccess_token();
                String refresh_token = data.getRefresh_token();
                String exDateFormat = DateUtil.dateTo14String(new Date(exDate));


                KuaishouTokenVo kuaishouTokenVo = new KuaishouTokenVo();
                kuaishouTokenVo.setToken(access_token);
                kuaishouTokenVo.setRefreshToken(refresh_token);
                kuaishouTokenVo.setTokenExpireTime(exDateFormat);
                kuaishouTokenVo.setRefreshExpireTime(DateUtil.dateTo14String(new Date(refreshExDate)));
                kuaishouTokenVo.setAdvertiserIds(advertiser_ids);
                kuaishouTokenVo.setSecret(secret);
                kuaishouTokenVo.setAppKey(appKey);

                updater.hupdate(RedisKeys.hashKuaishouToken(), appId, JsonHelper.convert(kuaishouTokenVo));

                Map<String, String> multiUpdateMap = new HashMap();
                for (Long advertiser_id : advertiser_ids) {
                    // 更新rtb控制redis
                    Map<String, String> valueMap = new HashMap<>();
                    valueMap.put("accessToken", access_token);
                    valueMap.put("expire", exDateFormat);

                    multiUpdateMap.put(Objects.toString(advertiser_id), JSONObject.toJSONString(valueMap));
                }
                rtbJedisUpdater.hmupdate(RedisKeys.hashRtbKuaishouAccessToken(appKey), multiUpdateMap);

            }
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            return "授权失败：系统异常";
        }
        return "授权成功";
    }


}