package com.bxm.adsmanager.web.controller.third;

import com.bxm.adsmanager.model.ro.QttRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.*;


/**
 * 趣头条与变现猫券的关系绑定
 */
@RestController
public class QTTController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(QTTController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    /**
     * 简单获取媒体信息
     * type 1 修改  0删除
     */
    @RequestMapping(value = "/qtt/updateQtt", produces = "application/json")
    public ResultModel<Boolean> updateQtt(@RequestParam(value = "ticketId") String ticketId,
                                          @RequestParam(value = "cid") String cid,
                                          @RequestParam(value = "type") String type) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            if (StringUtils.equalsIgnoreCase("1", type)) {
                updater.hupdateWithSelector(qttAndbxm(), ticketId, cid, 11);
            }
            if (StringUtils.equalsIgnoreCase("0", type)) {
                updater.hremoveWithSelector(qttAndbxm(), 11, ticketId);
            }
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value = "/qtt/getListQtt", produces = "application/json")
    public ResultModel<List<QttRo>> getList() {
        // 声明结果
        ResultModel<List<QttRo>> rs = new ResultModel<>();
        try {
            List<QttRo> list = new ArrayList<>();
            Map<String, String> mapConfigAll = fetcher.hfetchallWithSelector(qttAndbxm(), String.class, 11);
            if (mapConfigAll != null) {
                for (String ticketId : mapConfigAll.keySet()) {
                    QttRo qttRo = new QttRo();
                    qttRo.setTicketId(ticketId);
                    qttRo.setCid(mapConfigAll.get(ticketId));
                    list.add(qttRo);
                }

            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator qttAndbxm() {
        return () -> KeyBuilder.build("qtt", "and", "bxm");
    }
}