package com.bxm.adsmanager.web.controller.third;

import com.bxm.adsmanager.model.ro.TxRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 腾讯与变现猫券的关系绑定
 */
@RestController
public class TicketAndTxController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketAndTxController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    /**
     * 绑定腾讯ID
     * type 1 修改  0删除
     */
    @RequestMapping(value = "/tx/saveOrUpdate", produces = "application/json")
    public ResultModel<Boolean> saveOrUpdate(@RequestParam(value = "ticketId") String ticketId,
                                          @RequestParam(value = "txUserId") String txUserId,
                                          @RequestParam(value = "type") String type) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            if (StringUtils.equalsIgnoreCase("1", type)) {
                updater.hupdateWithSelector(txAndbxm(), txUserId, ticketId,0);
            }
            if (StringUtils.equalsIgnoreCase("0", type)) {
                updater.hremoveWithSelector(txAndbxm(), 0, txUserId);
            }
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value = "/tx/getList", produces = "application/json")
    public ResultModel<List<TxRo>> getList() {
        // 声明结果
        ResultModel<List<TxRo>> rs = new ResultModel<>();
        try {
            List<TxRo> list = new ArrayList<>();
            Map<String, String> mapConfigAll = fetcher.hfetchallWithSelector(txAndbxm(), String.class, 0);
            if (mapConfigAll != null) {
                for (String txUserId : mapConfigAll.keySet()) {
                    TxRo txRo = new TxRo();
                    txRo.setTxUserId(txUserId);
                    txRo.setTicketId(mapConfigAll.get(txUserId));
                    list.add(txRo);
                }
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator txAndbxm() {
        return () -> KeyBuilder.build("tengxun", "and", "bxm");
    }
}