package com.bxm.adsmanager.web.controller.third;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.ro.QttRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 趣头条与变现猫券的关系绑定
 */
@RestController
public class TicketClickController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketClickController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    /**
     * 新增修改绑定关系
     * type 1 修改  0删除
     */
    @RequestMapping(value = "/bxm/updateOrSaveUrl", produces = "application/json")
    public ResultModel<Boolean> updateQtt(@RequestParam(value = "ticketId") String ticketId,
                                          @RequestParam(value = "ticketClickUrl" , required = false) String ticketClickUrl,
                                          @RequestParam(value = "advertiserClickUrl" , required = false) String advertiserClickUrl,
                                          @RequestParam(value = "type") String type) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            if (StringUtils.equalsIgnoreCase("1", type)) {
                QttRo qttRo =new QttRo();
                qttRo.setTicketId(ticketId);
                qttRo.setTicketClickUrl(ticketClickUrl);
                qttRo.setAdvertiserClickUrl(advertiserClickUrl);
                updater.hupdateWithSelector(qttAndbxmPlanAndTicketId(),  ticketId, JSON.toJSONString(qttRo), 11);
            }
            if (StringUtils.equalsIgnoreCase("0", type)) {
                updater.hremoveWithSelector(qttAndbxmPlanAndTicketId(), 11, ticketId);
            }
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    /**
     *
     * @param
     * @return
     */
    @GetMapping(value = "/bxm/getListURL", produces = "application/json")
    public ResultModel<List<QttRo>> getList() {
        // 声明结果
        ResultModel<List<QttRo>> rs = new ResultModel<>();
        try {
            List<QttRo> list = new ArrayList<>();
            Map<String, String> mapConfigAll = fetcher.hfetchallWithSelector(qttAndbxmPlanAndTicketId(), String.class, 11);
            if (mapConfigAll != null) {
                for (String qttRoJson : mapConfigAll.values()) {
                    QttRo qttRo = JSON.parseObject(qttRoJson, QttRo.class);
                    list.add(qttRo);
                }
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    /**
     *  趣头条计划ID，对应变现猫券
     * @return
     */
    public static KeyGenerator qttAndbxmPlanAndTicketId() {
        return () -> KeyBuilder.build("qtt", "and", "bxm","click","url");
    }

}