package com.bxm.adsmanager.web.controller.third;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.getui.utils.HttpUtils;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.ro.QttRo;
import com.bxm.adsmanager.model.vo.weibo.WBToken;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.http.OkHttpUtils;
import com.google.common.collect.Maps;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


@Slf4j
@RestController
public class WeiboController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeiboController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    private static final String tokenUrl = "https://api.biz.weibo.com/oauth/token";

    /**
     * 微博code 回传接口
     *
     * @param code
     * @param state (appid)
     * @return
     */
    @RequestMapping(value = "/wb/code", produces = "application/json")
    public ResultModel<Boolean> save(@RequestParam(value = "code") String code,
                                     @RequestParam(value = "state") String state) {
        //https://api.biz.weibo.com/oauth/authorize?client_id=APP_ID&
        // redirect_uri={您的回调地址}&response_type=code&state=APP_ID&scope=ads_read
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            //根据code获取token
            Map<String, Object> params = Maps.newHashMap();
            params.put("client_id", state);
            params.put("grant_type", "authorization_code");
            params.put("redirect_uri", "https%3A%2F%2Fmgr.bianxianmao.com%3A18501%2Fwb%2Fcode");
            params.put("code", code);
            String getTokenurl = OkHttpUtils.appendParams(tokenUrl, params);
            String value = OkHttpUtils.get(getTokenurl);
            WBToken token = JsonHelper.convert(value, WBToken.class);
            Map<String, Object> refreshParams = Maps.newHashMap();
            refreshParams.put("client_id", state);
            refreshParams.put("grant_type", "refresh_token");
            refreshParams.put("refresh_token", token.getRefresh_token());
            String refreshTokenurl = OkHttpUtils.appendParams(tokenUrl, refreshParams);
            String refreshValue = OkHttpUtils.get(refreshTokenurl);
            WBToken refreshToken = JsonHelper.convert(refreshValue, WBToken.class);
            Long exDate = System.currentTimeMillis() + Long.valueOf(token.getExpires_in()) * 1000;
            Long refreshExDate = System.currentTimeMillis() + Long.valueOf(token.getRefresh_expires_in()) * 1000;
            refreshToken.setExDate(DateUtil.dateTo14String(new Date(exDate)));
            refreshToken.setRefresh_token(token.getRefresh_token());
            refreshToken.setRefresh_expires_in(token.getRefresh_expires_in());
            refreshToken.setRefreshExDate(DateUtil.dateTo14String(new Date(refreshExDate)));
            updater.hupdate(CommonConstant.wbToken(), state, JsonHelper.convert(refreshToken));
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static void main(String[] args) throws IOException {

        String value = "{\"access_token\":\"acb82da41ed33f172ae9ef22539c456f\"," +
                "\"expires_in\":3600,\"refresh_token\":\"r25674b1112d75bb1441774863e0e2a3\"," +
                "\"refresh_expires_in\":7776000,\"token_type\":\"Bearer\"}";
        WBToken token = JsonHelper.convert(value, WBToken.class);
        Map<String, Object> refreshParams = Maps.newHashMap();
        refreshParams.put("client_id", "202206273641659100");
        refreshParams.put("grant_type", "refresh_token");
        refreshParams.put("refresh_token", token.getRefresh_token());
        String refreshTokenurl = OkHttpUtils.appendParams(tokenUrl, refreshParams);
        for (int i = 0; i < 10; i++) {
            String refreshValue = OkHttpUtils.get(refreshTokenurl);
            WBToken refreshToken = JsonHelper.convert(refreshValue, WBToken.class);
            System.out.println(JSON.toJSONString(refreshToken));
        }
    }

}