package com.bxm.adsmanager.web.controller.third;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdTicketMapperExt;
import com.bxm.adsmanager.model.dao.adkeeper.AdPosition;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.ro.YDPostionidAndBxmRo;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 有道与变现猫券的关系绑定
 */
@RestController
public class YDAndBXMController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(YDAndBXMController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired
    private AdTicketMapper adTicketMapper;

    /**
     * 新增
     */
    @RequestMapping(value = "/ydAndBxm/save", produces = "application/json")
    public ResultModel<Boolean> save(@RequestParam(value = "ticketId") String ticketId,
                                     @RequestParam(value = "assetsId") String assetsId,
                                     @RequestParam(value = "ydPositionId") String ydPositionId) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            YDPostionidAndBxmRo ydPostionidAndBxmRo = new YDPostionidAndBxmRo();
            ydPostionidAndBxmRo.setAssetsId(assetsId);
            ydPostionidAndBxmRo.setYdPositionId(ydPositionId);
            ydPostionidAndBxmRo.setTicketId(ticketId);
            // 查询券类型
            AdTicket adTicket = adTicketMapper.selectByPrimaryKey(Long.parseLong(ticketId));
            ydPostionidAndBxmRo.setTicketType(adTicket.getType());

            //判断是否存在这条数据（因为绑定数据不会太多，所以不用查找数据库，直接从redis里面查找）
            Map<String, YDPostionidAndBxmRo> mapConfigAll = fetcher.hfetchallWithSelector(ydPositionIdAndBxmTickassetsIdetId(), YDPostionidAndBxmRo.class, 0);
            if (mapConfigAll != null) {
                for (YDPostionidAndBxmRo ydPostionidAndBxmRo1 : mapConfigAll.values()) {
                    if (ydPostionidAndBxmRo1.getAssetsId().equalsIgnoreCase(assetsId)
                            || ydPostionidAndBxmRo1.getTicketId().equalsIgnoreCase(ticketId)
                            || ydPostionidAndBxmRo1.getYdPositionId().equalsIgnoreCase(ydPositionId)) {
                        rs.setSuccessed(false);
                        rs.setErrorDesc("已经存在相同的广告信息，请检查后重新输入");
                        return rs;
                    }
                }
            }
            updater.hupdateWithSelector(ydPositionIdAndBxmTickassetsIdetId(), ticketId, ydPostionidAndBxmRo, 0);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    /**
     * 修改
     */
    @RequestMapping(value = "/ydAndBxm/update", produces = "application/json")
    public ResultModel<Boolean> update(@RequestParam(value = "ticketId") String ticketId,
                                       @RequestParam(value = "assetsId") String assetsId,
                                       @RequestParam(value = "ydPositionId") String ydPositionId,
                                       @RequestParam(value = "oldTicketId") String oldTicketId) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            YDPostionidAndBxmRo ydPostionidAndBxmRo = new YDPostionidAndBxmRo();
            ydPostionidAndBxmRo.setAssetsId(assetsId);
            ydPostionidAndBxmRo.setYdPositionId(ydPositionId);
            ydPostionidAndBxmRo.setTicketId(ticketId);
            // 查询券类型
            AdTicket adTicket = adTicketMapper.selectByPrimaryKey(Long.parseLong(ticketId));
            ydPostionidAndBxmRo.setTicketType(adTicket.getType());
            //判断是否存在这条数据（因为绑定数据不会太多，所以不用查找数据库，直接从redis里面查找）
            Map<String, YDPostionidAndBxmRo> mapConfigAll = fetcher.hfetchallWithSelector(ydPositionIdAndBxmTickassetsIdetId(), YDPostionidAndBxmRo.class, 0);
            if (mapConfigAll != null) {
                for (YDPostionidAndBxmRo ydPostionidAndBxmRo1 : mapConfigAll.values()) {
                    if (ydPostionidAndBxmRo1.getTicketId().equalsIgnoreCase(oldTicketId)) {
                        //跳出原本的
                        continue;
                    }
                    if (ydPostionidAndBxmRo1.getAssetsId().equalsIgnoreCase(assetsId)
                            || ydPostionidAndBxmRo1.getTicketId().equalsIgnoreCase(ticketId)
                            || ydPostionidAndBxmRo1.getYdPositionId().equalsIgnoreCase(ydPositionId)) {
                        rs.setSuccessed(false);
                        rs.setErrorDesc("已经存在相同的广告信息，请检查后重新输入");
                        return rs;
                    }
                }
            }
            updater.hremoveWithSelector(ydPositionIdAndBxmTickassetsIdetId(), 0, oldTicketId);
            updater.hupdateWithSelector(ydPositionIdAndBxmTickassetsIdetId(), ticketId, ydPostionidAndBxmRo, 0);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    /**
     * 删除
     *
     * @param ticketId
     * @return
     */
    @RequestMapping(value = "/ydAndBxm/delete", produces = "application/json")
    public ResultModel<Boolean> delete(@RequestParam(value = "ticketId") String ticketId) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            updater.hremoveWithSelector(ydPositionIdAndBxmTickassetsIdetId(), 0, ticketId);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }


    /**
     * @return
     */
    @GetMapping(value = "/ydAndBxm/getList", produces = "application/json")
    public ResultModel<List<YDPostionidAndBxmRo>> getList(YdPositionQuery queryParam) {
        // 声明结果
        ResultModel<List<YDPostionidAndBxmRo>> rs = new ResultModel<>();
        try {
            List<YDPostionidAndBxmRo> list = new ArrayList<>();
            Map<String, YDPostionidAndBxmRo> mapConfigAll = fetcher.hfetchallWithSelector(ydPositionIdAndBxmTickassetsIdetId(), YDPostionidAndBxmRo.class, 0);

            if (mapConfigAll != null) {
                for (YDPostionidAndBxmRo ro : mapConfigAll.values()) {
                    boolean allMatch = true;
                    if (StringUtils.isNotBlank(queryParam.getTicketId())) {
                        allMatch = allMatch && StringUtils.equals(queryParam.getTicketId(), ro.getTicketId());
                    }
                    if (StringUtils.isNotBlank(queryParam.getAssetsId())) {
                        allMatch = allMatch && StringUtils.equals(queryParam.getAssetsId(), ro.getAssetsId());
                    }
                    if (StringUtils.isNotBlank(queryParam.getYdPositionId())) {
                        allMatch = allMatch && StringUtils.equals(queryParam.getYdPositionId(), ro.getYdPositionId());
                    }
                    // 查询券类型
                    AdTicket adTicket = adTicketMapper.selectByPrimaryKey(Long.parseLong(ro.getTicketId()));
                    ro.setTicketType(adTicket.getType());

                    if (null != queryParam.getTicketType()) {
                        allMatch = allMatch && queryParam.getTicketType().equals(ro.getTicketType());
                    }

                    if (allMatch) {
                        list.add(ro);
                    }
                }
            }
            rs.setReturnValue(list);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    /**
     * 变现猫全ID，
     *
     * @return
     */
    public static KeyGenerator ydPositionIdAndBxmTickassetsIdetId() {
        return () -> KeyBuilder.build("YD", "AND", "BXM", "TICKETID");
    }

    @Data
    public class YdPositionQuery{

        //券ID
        private String ticketId;
        // 素材ID
        private String assetsId;
        //有道广告位ID
        private String ydPositionId;
        // 券类型
        private Short ticketType;

    }


}