package com.bxm.adsmanager.web.controller.weight;

import com.bxm.adsmanager.model.dto.TicketArpuDTO;
import com.bxm.adsmanager.model.vo.AdTicketArpuVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketArpuService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/adTicketArpu")
public class AdTicketArpuController extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketArpuController.class);

    @Autowired
    AdTicketArpuService adTicketArpuService;


    /**
     * 根据参数查找arpu券列表
     *
     * @return
     */
    @RequestMapping(value = "/findAll", method = RequestMethod.GET)
    public ResultModel<PageInfo<AdTicketArpuVo>> findTicketByParams(TicketArpuDTO ticketArpuDTO) {

        try {
            ResultModel<PageInfo<AdTicketArpuVo>> rs = new ResultModel<>();
            PageInfo<AdTicketArpuVo> pageInfo = adTicketArpuService.findAll(ticketArpuDTO);
            rs.setReturnValue(pageInfo);
            return rs;
        } catch (ValidateException v) {
            LOGGER.error(v.getMessage(), v);
            return ResultModelFactory.FAIL400(v.getMessage());
        } catch (Exception e) {
            LOGGER.error("查找广告券appu出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500("查找广告券arpu出错");
        }
    }

    @LogBefore(operType = "/adTicketArpu/add", keyName = "添加arpu")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultModel add(TicketArpuDTO ticketArpuDTO) {

        try {
            adTicketArpuService.add(ticketArpuDTO);
            return ResultModelFactory.SUCCESS(null);
        } catch (ValidateException v) {
            LOGGER.error(v.getMessage(), v);
            return ResultModelFactory.FAIL400(v.getMessage());
        } catch (Exception e) {
            LOGGER.error("新增广告券appu出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @LogBefore(operType = "/adTicketArpu/update", keyName = "修改arpu")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultModel update(TicketArpuDTO ticketArpuDTO) {

        try {
            adTicketArpuService.update(ticketArpuDTO);
            return ResultModelFactory.SUCCESS(null);
        } catch (ValidateException v) {
            LOGGER.error(v.getMessage(), v);
            return ResultModelFactory.FAIL400(v.getMessage());
        } catch (Exception e) {
            LOGGER.error("修改广告券appu出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }

    @LogBefore(operType = "/adTicketArpu/delete", keyName = "删除arpu")
    @RequestMapping(value = "/delete", method = RequestMethod.GET)
    public ResultModel delete(Integer id) {

        try {
            adTicketArpuService.delete(id);
            return ResultModelFactory.SUCCESS(null);
        } catch (ValidateException v) {
            LOGGER.error(v.getMessage(), v);
            return ResultModelFactory.FAIL400(v.getMessage());
        } catch (Exception e) {
            LOGGER.error("删除广告券appu出错" + e.getMessage(), e);
            return ResultModelFactory.FAIL500(e.getMessage());
        }
    }
}
