package com.bxm.adsmanager.web.controller.weight;


import java.util.Date;

import com.bxm.adsmanager.model.dao.mediamanager.AdTicketPositionWeightNew;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketPositionWeightNewDTO;
import com.bxm.adsmanager.model.dto.common.CommonSearchDto;
import com.bxm.adsmanager.model.dto.mediamanager.PositionWeightDto;
import com.bxm.adsmanager.service.mediamanager.PositionTicketWeightService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmanager.web.controller.common.MediaPositionController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**  
* @Title: PositionTicketWeight 
* @Description:  媒体管理 更新广告位权重
* @author xavier  
* @date 2018年3月14日  
*/  
@RequestMapping("/positionTicketWeight")
@RestController
public class PositionTicketWeightController extends BaseController {

	private static final Logger LOGGER = LoggerFactory.getLogger(MediaPositionController.class);
	
	@Autowired
	private PositionTicketWeightService positionTicketWeightService;
	
	/**  
	 * @Title: findAll  
	 * @Description:  通过广告位ID查询权重
	 * @author xavier  
	 * @date 2018年3月14日
	 */  
	@RequestMapping(value = "/findAll", method = RequestMethod.GET)
	public ResultModel<PageInfo> findAll(AdTicketPositionWeightNewDTO search) {
		try {
			return ResultModelFactory.SUCCESS(positionTicketWeightService.findAllNew(search));
		} catch (Exception e) {
			LOGGER.error("广告位广告券列表查询错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**  
	 * @Title: updatePostionWeight  
	 * @Description:  修改广告位权重值
	 * @author xavier  
	 * @date 2018年3月14日
	 */
	@LogBefore(operType="/positionTicketWeight/updatePositionWeight",keyName="广告")
	@PostMapping(value = "/updatePositionWeight")
	public ResultModel<?> updatePositionWeight(HttpServletRequest request ,
											   HttpServletResponse response,
											   AdTicketPositionWeightNew model) {
		//参数校验
		if (BeanValidator.validateGroup(model, AdTicketPositionWeightNew.Add.class) != null) {
			return ResultModelFactory.FAIL400(BeanValidator.validateGroup(model,
					AdTicketPositionWeightNew.Add.class).getMessage());
		}
		try {
			final User user = getUser(request, response);
			model.setCreateUser(user.getUsername());
			model.setUpdateUser(user.getUsername());
			positionTicketWeightService.updateOrInsert(model);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			LOGGER.error(e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}

	/**
	 * @Title: updatePositionWeight
	 * @Description:  删除广告位权重值
	 * @author xavier
	 * @date 2018年3月14日
	 */
	@LogBefore(operType="/positionTicketWeight/deletePositionWeight",keyName="广告")
	@PostMapping(value = "/deletePositionWeight")
	public ResultModel<?> deletePositionWeight(HttpServletRequest request ,
											   HttpServletResponse response,
											   AdTicketPositionWeightNew model) {
		//参数校验
		if (BeanValidator.validateGroup(model, AdTicketPositionWeightNew.Delete.class) != null) {
			return ResultModelFactory.FAIL400(BeanValidator.validateGroup(model,
					AdTicketPositionWeightNew.Delete.class).getMessage());
		}
		try {
			final User user = getUser(request, response);
			model.setUpdateUser(user.getUsername());
			positionTicketWeightService.delete(model);
			return ResultModelFactory.SUCCESS();
		} catch (Exception e) {
			LOGGER.error("删除广告位权重值错误"+e.getMessage(), e);
			return ResultModelFactory.FAIL500(e.getMessage());
		}
	}
	
}
