package com.bxm.adsmanager.web.controller.ydticket;

import com.bxm.adsmanager.model.ro.QttRo;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 有道券存Redis
 */
@RestController
public class YDTicketController extends BaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(YDTicketController.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    /**
     * 修改有道券信息
     */
    @RequestMapping(value = "/yd/addOrUpdate", produces = "application/json")
    public ResultModel<Boolean> updateQtt(@RequestParam(value = "ticketIds", required = false) String ticketIds) {
        // 声明结果
        ResultModel<Boolean> rs = new ResultModel<>();
        try {
            updater.update(getAllYDTicketIds(),ticketIds);
            rs.setReturnValue(true);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    @GetMapping(value = "/yd/getAll", produces = "application/json")
    public ResultModel<String> getList() {
        // 声明结果
        ResultModel<String> rs = new ResultModel<>();
        try {
            String value = fetcher.fetch(getAllYDTicketIds(), String.class);

            rs.setReturnValue(value);
            rs.setSuccessed(true);
        } catch (Exception e) {
            // 异常处理
            LOGGER.error(e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("system error");
        }
        return rs;
    }

    public static KeyGenerator getAllYDTicketIds(){
        return () -> KeyBuilder.build("API","YD","TICKETIDS");
    }
}