/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.adsmanager.web.convert.report;

import java.io.IOException;

import com.bxm.datapark.facade.positiontest.PositionTestByTicket;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adsmanager.integration.datapark.model.DataParkContens;
import com.bxm.adsmanager.integration.datapark.service.DataparkMediaPositionTestPullerIntegration;
import com.bxm.adsmanager.model.constant.ReportConstant;
import com.bxm.util.dto.ResultModel;

@RestController
@RequestMapping("/positionTestReport")
public class MediaPositionTestReportController {

	@Autowired
	private DataparkMediaPositionTestPullerIntegration dataparkMediaPositionTestPullerIntegration;


	/**
	 * 分页查询媒体测试报表
	 *
	 * @author 拉拉
	 * @date 2018/2/27 20:04
	 * @param
	 * @return
	 * @throws IOException
	 */
	@RequestMapping(value = "/getPositionTestReport", method = RequestMethod.GET, produces = "application/json")
	public ResultModel<com.bxm.datapark.facade.Page<PositionTestByTicket>> getPositionTestReport(@RequestParam(name = DataParkContens.KEYWORDS, required = false) String keywords,
																								 @RequestParam(name = DataParkContens.SHOP_TYPE, required = false) String shoptype,
																								 @RequestParam(name = DataParkContens.AREA_TYPE, required = false) String areatype,
																								 @RequestParam(name = DataParkContens.SEARCH_TYPE, required = true) String searchtype,
																								 @RequestParam(name = DataParkContens.POSITIONID, required = true) String positionid,
																								 @RequestParam(name = ReportConstant.PAGE_SIZE, required = false, defaultValue = ReportConstant.TEN_S) Integer pageSize,
																								 @RequestParam(name = ReportConstant.PAGE_NUM, required = false, defaultValue = ReportConstant.ONE_S) Integer pageNum,
																								 @RequestParam(name = ReportConstant.SORT_NAME, required = false, defaultValue = ReportConstant.OPEN_PV_VO) String sortName,
																								 @RequestParam(name = ReportConstant.SORT_TYPE, required = false, defaultValue = ReportConstant.SORT_TYPE_DESC) String sortType) throws IOException {

		ResultModel<com.bxm.datapark.facade.Page<PositionTestByTicket>> resultModel = new ResultModel<com.bxm.datapark.facade.Page<PositionTestByTicket>>();

		com.bxm.datapark.facade.Page<PositionTestByTicket> page = dataparkMediaPositionTestPullerIntegration.getPositionTestReport(keywords, positionid,
				sortName, pageNum,
				pageSize, sortType,
				areatype, searchtype,
				shoptype);
		resultModel.setReturnValue(page);
		return resultModel;
	}



}
