package com.bxm.adsmanager.web.interceptor;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.utils.IPUtils;
import com.bxm.warcar.logging.OperatorExtractor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

import javax.servlet.http.HttpServletRequest;

/**
 * 记录请求时的用户身份 为了保存日志
 * @author tangx
 * @date 2021/4/14 18:35
 */
@Slf4j
@Configuration
public class DefaultOperatorExtractor implements OperatorExtractor {

    @Override
    public String extract(HttpServletRequest request) {
        UserVo userVo = null;
        try {
            userVo = (UserVo) request.getAttribute(AclAuthInterceptor.USER_KEY);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return "";
        }
        return userVo.getRealname();
    }
}
