/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adsmanager.web.interceptor;

import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.adsmanager.service.sys.SysService;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.Set;

/**
 * <h3>权限拦截</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/15 18:13
 */
@Configuration
public class InterceptorConfigurer extends WebMvcConfigurerAdapter {

    private static final Set<String> excludePaths = Sets.newHashSet(
            "/adsmanager/**",
            "/advertiser/**",
            "/notLogin",
            "/noAuth",
            "/error",
            "/common/**",
            "/adtag/**",
            "/adFinance/**",
            "/copydata/**",
            "/adPositionAudit/updateAdPositionRewardConfig",
            "/adPositionAudit/updateAdPositionRewardConfigForExist",
            "/stationUserWeight/complete",
            "/stationUserWeight/test",
            "/stationUserWeight/check",
            "/alipay/**",
            "/adTicket/updateStatusBySentinel",
            "/admin/position/controller/rebuild",
            "/adTicket/getAeCodeByTicketId",
            "/advertiserDataOptimized/findAll",
            "/qtt/*",
            "/adTicket/findTicketByParams",
            "/video/asset/download",
            "/adTicket/cost/syns",
            "/facade/**",
            "/adAssetsInspireVideo/upload",
            "/adx/meituan/callback",
            "/position/getPositionrtb",
            "/adAssetsTemplateAssets/updateOldData",
            "/logs/addLogs",
            "/dpprofit/*",
            "/wb/code",
            "/adPositionAudit/updateOldKf",
            "/explore/test",
            "/ks/code",
            "/kuaishou/callback"
    );

    @Autowired
    private SysService sysService;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // 多个拦截器组成一个拦截器链
        // addPathPatterns 用于添加拦截规则   adsmanager是prod访问，没有拦截
        registry.addInterceptor(aclAuthInterceptor())
                .addPathPatterns("/*/**")
                .excludePathPatterns(excludePaths.toArray(new String[0]));

        registry.addInterceptor(versionInterceptor())
                .addPathPatterns("/*/**")
                .excludePathPatterns(excludePaths.toArray(new String[0]))
                .excludePathPatterns("/sys/**");

        super.addInterceptors(registry);
    }

    @Bean
    public AclAuthInterceptor aclAuthInterceptor() {
        return new AclAuthInterceptor(7);
    }

    @Bean
    public VersionInterceptor versionInterceptor() {
        return new VersionInterceptor(sysService);
    }
}
