package com.bxm.adsmanager.web.interceptor;

import com.bxm.adsmanager.service.sys.SysService;
import com.bxm.adsmanager.web.controller.exception.VersionRequiredException;
import com.bxm.warcar.utils.StringHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 版本校验拦截器
 *
 * @author allen
 * @date 2022-09-15
 * @since 1.0
 */
public class VersionInterceptor implements HandlerInterceptor {

    private static final String VERSION = "version";

    private final SysService sysService;

    public VersionInterceptor(SysService sysService) {
        this.sysService = sysService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String need = sysService.get("adsmanager.required.version");
        if (StringUtils.isBlank(need)) {
            throw new RuntimeException("系统初始化失败，请联系管理员。");
        }
        String client = request.getHeader(VERSION);
        if (StringUtils.isBlank(client)) {
            client = request.getParameter(VERSION);
        }
        if (StringUtils.isBlank(client)) {
            return true;
        }
        if (!StringHelper.isNewVersion(need, client)) {
            throw new VersionRequiredException(String.format("当前使用的系统版本号 %s 低于 %s，请刷新页面。如果仍然无法解决，建议清空浏览器缓存再试。", client, need));
        }
        return true;
    }
}
