/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web;

import com.bxm.openlog.sdk.listener.EnableLogSubscriberFactory;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import com.bxm.warcar.integration.autoconfigure.distributed.EnableDistributedScheduling;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import redis.clients.jedis.JedisPool;

@SpringBootApplication
@EnableFeignClients(value={"com.bxm.adapi.facade", "com.bxm.profit.facade", "com.bxm.log.facade", "com.bxm.adsmanager.integration.advertiser.service", "com.bxm.datapark.facade", "com.bxm.datapark.web", "com.bxm.acl.facade", "com.bxm.adsmedia.facade", "com.bxm.adsmanager.integration.adsmedia", "com.bxm.activites.facade", "com.bxm.mccms.facade.service", "com.bxm.activities.service"})
@EnableDiscoveryClient
@MapperScan(basePackages={"com.bxm.adsmanager.dal.mapper"})
@ImportResource(value={"classpath:application-domain.xml"})
@EnableLogSubscriberFactory
@EnableDistributedScheduling
public class AdsManagerApplication {
    @Autowired
    private JedisConfiguration configuration;

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Class[]{AdsManagerApplication.class});
        application.addListeners(new ApplicationListener[]{new SpringBootEnvironmentListener()});
        application.run(args);
    }

    @Bean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(Boolean.valueOf(true));
        config.addAllowedOrigin("*");
        config.addAllowedHeader("*");
        config.setMaxAge(Long.valueOf(18000L));
        config.addAllowedMethod("OPTIONS");
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @LoadBalanced
    public RestTemplate restTemplate() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(5000);
        simpleClientHttpRequestFactory.setReadTimeout(120000);
        return new RestTemplate((ClientHttpRequestFactory)simpleClientHttpRequestFactory);
    }

    @Bean
    public JedisPool jedisPool() {
        return new JedisPool((GenericObjectPoolConfig)this.configuration, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getTimeout(), this.configuration.getPassword(), this.configuration.getDatabase());
    }
}

