/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.abtest;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.abtest.AbTestSceneVo;
import com.bxm.adsmanager.service.abtest.AbTestSceneService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/abtest"})
public class AbTestSceneController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbTestSceneController.class);
    @Autowired
    AbTestSceneService abTestSceneService;

    @RequestMapping(value={"/scene/add"}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="sceneName") String sceneName, @RequestParam(value="defaultAlgorithmCode") String defaultAlgorithmCode) {
        try {
            User user = this.getUser(request, response);
            this.abTestSceneService.add(sceneName, defaultAlgorithmCode, user.getUsername());
            this.addLogs(user, "\u65b0\u589e \u4e1a\u52a1\u573a\u666f\u7684\u540d\u5b57\u4e3a\uff1a" + sceneName + ",\u9ed8\u8ba4\u9ed8\u8ba4\u7b97\u6cd5code\u662f\uff1a" + defaultAlgorithmCode, "\u4e1a\u52a1\u573a\u666f");
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u4e1a\u52a1\u573a\u666f\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/scene/update"}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="sceneName") String sceneName, @RequestParam(value="sceneCode") String sceneCode, @RequestParam(value="defaultAlgorithmCode") String defaultAlgorithmCode) {
        try {
            User user = this.getUser(request, response);
            this.abTestSceneService.update(sceneName, sceneCode, defaultAlgorithmCode, user.getUsername());
            this.addLogs(user, "\u4fee\u6539\u4e1a\u52a1\u573a\u666f\u7684\u540d\u5b57\u4e3a\uff1a" + sceneName + "\uff0c\u9ed8\u8ba4\u7b97\u6cd5code\u662f\uff1a" + defaultAlgorithmCode, "\u4e1a\u52a1\u573a\u666f");
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u4e1a\u52a1\u573a\u666f\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/scene/getPageList"}, produces={"application/json"})
    public ResultModel<PageInfo<AbTestSceneVo>> getPageList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="sceneKeywords", required=false) String sceneKeywords) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.abTestSceneService.getPageList(sceneKeywords, pageNum, pageSize));
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u4e1a\u52a1\u573a\u666f\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u4e1a\u52a1\u573a\u666f\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/scene/getList"}, produces={"application/json"})
    public ResultModel<List<AbTestSceneVo>> getList(@RequestParam(value="sceneKeywords", required=false) String sceneKeywords) {
        ResultModel resultModel = new ResultModel();
        try {
            List list = this.abTestSceneService.getList(sceneKeywords);
            resultModel.setReturnValue((Object)list);
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u4e1a\u52a1\u573a\u666f\u5217\u8868\u51fa\u9519", (Throwable)e);
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("\u67e5\u627e\u4e1a\u52a1\u573a\u666f\u5217\u8868\u51fa\u9519");
        }
        return resultModel;
    }
}

