/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adarpu;

import com.bxm.adsmanager.model.dto.adarpu.AdDoMainArpuDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adarpu.AdDomainArpuVo;
import com.bxm.adsmanager.service.adarpu.AdArpuService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adArpu"})
public class AdDomainArpuController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdDomainArpuController.class);
    @Autowired
    AdArpuService adArpuService;

    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdDoMainArpuDto adArpuDto) {
        try {
            if (BeanValidator.validateGroup((Object)adArpuDto, (Class[])new Class[]{AdDoMainArpuDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adArpuDto, (Class[])new Class[]{AdDoMainArpuDto.Add.class}).getMessage());
            }
            adArpuDto.setCreateUser(this.getUser(request, response).getUsername());
            adArpuDto.setModifyUser(this.getUser(request, response).getUsername());
            this.adArpuService.insert(adArpuDto);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u793c\u5238ARPU\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u65b0\u589e\u793c\u5238ARPU\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdDoMainArpuDto adArpuDto) {
        try {
            if (BeanValidator.validateGroup((Object)adArpuDto, (Class[])new Class[]{AdDoMainArpuDto.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adArpuDto, (Class[])new Class[]{AdDoMainArpuDto.Update.class}).getMessage());
            }
            adArpuDto.setModifyUser(this.getUser(request, response).getUsername());
            this.adArpuService.updateByPrimaryKey(adArpuDto);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u793c\u5238ARPU\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u793c\u5238ARPU\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, long id) {
        try {
            this.adArpuService.deleteByPrimaryKey(Long.valueOf(id));
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u793c\u5238ARPU\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u793c\u5238ARPU\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response, AdDoMainArpuDto adArpuDto) {
        try {
            ResultModel resultModel = new ResultModel();
            Pagination pagination = this.adArpuService.findArpuPage(adArpuDto);
            resultModel.setReturnValue((Object)pagination);
            return resultModel;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u793c\u5238ARPU\u51fa\u9519", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u793c\u5238ARPU\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findById"}, method={RequestMethod.GET})
    public ResultModel<AdDomainArpuVo> findById(HttpServletRequest request, HttpServletResponse response, long id) {
        ResultModel rs = new ResultModel();
        try {
            AdDomainArpuVo result = this.adArpuService.selectByPrimaryKey(id);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636eID\u67e5\u8be2\u793c\u5238ARPU\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u6839\u636eID\u67e5\u8be2\u793c\u5238ARPU\u51fa\u9519");
            return rs;
        }
    }
}

