/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adflowpackage;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdFlowPackageDto;
import com.bxm.adsmanager.model.dto.AdFlowPackageSearchDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageVo;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adflowpackage.AdFlowPackageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.validate.ValidateException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adFlowPackage"})
public class AdFlowPackageController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdFlowPackageController.class);
    @Autowired
    private AdFlowPackageService adFlowPackageService;

    @LogBefore(operType="/adFlowPackage/add", keyName="\u6dfb\u52a0\u6d41\u91cf\u5305")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdFlowPackageDto adFlowPackageDto) {
        try {
            if (BeanValidator.validateGroup((Object)adFlowPackageDto, (Class[])new Class[]{AdFlowPackageDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adFlowPackageDto, (Class[])new Class[]{AdFlowPackageDto.Add.class}).getMessage());
            }
            String userName = this.getUser(request, response).getUsername();
            this.adFlowPackageService.add(adFlowPackageDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (PushProdException p) {
            LOGGER.error("\u6dfb\u52a0\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u6d41\u91cf\u5305\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u6d41\u91cf\u5305\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u6d41\u91cf\u5305\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAll(HttpServletRequest request, HttpServletResponse response, AdFlowPackageSearchDto adFlowPackageSearchDto) {
        try {
            ResultModel rs = new ResultModel();
            User user = this.getUser(request, response);
            Pagination result = this.adFlowPackageService.findAll(adFlowPackageSearchDto, user);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findById"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<AdFlowPackageVo> findById(HttpServletRequest request, HttpServletResponse response, String flowPackageId, String ticketId, String type) {
        ResultModel rs = new ResultModel();
        try {
            AdFlowPackageVo result = this.adFlowPackageService.findById(flowPackageId, ticketId, type);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519");
            return rs;
        }
    }

    @RequestMapping(value={"/findAdPositionByFlowPackageId"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAdPositionByFlowPackageId(HttpServletRequest request, HttpServletResponse response, AdFlowPackageSearchDto adFlowPackageSearchDto) {
        ResultModel rs = new ResultModel();
        try {
            Pagination result = this.adFlowPackageService.findAdPositionByFlowPackageId(adFlowPackageSearchDto);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            LOGGER.info("\u6839\u636eid\u67e5\u627e\u6d41\u91cf\u5305\u8fd4\u56de\u7ed3\u679c:" + JSON.toJSONString((Object)result));
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u6839\u636e\u6d41\u91cf\u5305id\u67e5\u627e\u5165\u53e3\u540d\u79f0\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u6839\u636e\u6d41\u91cf\u5305id\u67e5\u627e\u5165\u53e3\u540d\u79f0\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6d41\u91cf\u5305id\u67e5\u627e\u5165\u53e3\u540d\u79f0\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519");
            return rs;
        }
    }

    @LogBefore(operType="/adFlowPackage/update", keyName="\u4fee\u6539\u6d41\u91cf\u5305")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdFlowPackageDto adFlowPackageDto) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.adFlowPackageService.update(adFlowPackageDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL500((String)v.getMessage());
        }
        catch (PushProdException p) {
            LOGGER.error("\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adFlowPackage/updateStatus", keyName="\u4fee\u6539\u6d41\u91cf\u5305")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel updateStatus(HttpServletRequest request, HttpServletResponse response, AdFlowPackageDto adFlowPackageDto) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.adFlowPackageService.updateStatus(adFlowPackageDto, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (PushProdException p) {
            LOGGER.error("\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4fee\u6539\u6d41\u91cf\u5305\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAllPackageName"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<List<String>> findAllPackageName(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adFlowPackageService.findAllPackageName();
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u67e5\u627e\u6d41\u91cf\u5305\u521b\u5efa\u4eba\u59d3\u540d\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u67e5\u627e\u6d41\u91cf\u5305\u521b\u5efa\u4eba\u59d3\u540d\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6d41\u91cf\u5305\u521b\u5efa\u4eba\u59d3\u540d\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc("\u67e5\u627e\u6d41\u91cf\u5305\u521b\u5efa\u4eba\u59d3\u540d\u51fa\u9519");
            return rs;
        }
    }

    @LogBefore(operType="/adFlowPackage/delete", keyName="\u5220\u9664\u6d41\u91cf\u5305")
    @RequestMapping(value={"/delete"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, String id) {
        try {
            String userName = this.getUser(request, response).getUsername();
            this.adFlowPackageService.delete(id, userName);
            return ResultModelFactory.SUCCESS(null);
        }
        catch (PushProdException p) {
            LOGGER.error("\u5220\u9664\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u6d41\u91cf\u5305\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u6d41\u91cf\u5305\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findPositionIdsById"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<String> findPositionIdsById(HttpServletRequest request, HttpServletResponse response, String ids) {
        ResultModel rs = new ResultModel();
        try {
            String result = this.adFlowPackageService.findPositionIdsById(ids);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u6d41\u91cf\u5305\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
    }
}

