/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adflowpackage;

import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageDto;
import com.bxm.adsmanager.model.vo.AdFlowPackageVo;
import com.bxm.adsmanager.service.adflowpackage.AdTicketFlowPackageService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicketFlowPackageConf"})
public class AdTicketFlowPackageConfController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketFlowPackageConfController.class);
    @Autowired
    private AdTicketFlowPackageService adTicketFlowPackageService;

    @LogBefore(operType="/adTicketFlowPackageConf/add", keyName="\u6dfb\u52a0\u6d41\u91cf\u5305")
    @RequestMapping(value={"/add"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketFlowPackageDto adTicketFlowPackageDto) {
        try {
            if (BeanValidator.validateGroup((Object)adTicketFlowPackageDto, (Class[])new Class[]{AdTicketFlowPackageDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adTicketFlowPackageDto, (Class[])new Class[]{AdTicketFlowPackageDto.Add.class}).getMessage());
            }
            String userName = this.getUser(request, response).getUsername();
            this.adTicketFlowPackageService.add(adTicketFlowPackageDto, userName, null);
            return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
        }
        catch (PushProdException p) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519");
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u5f39\u7a97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<List<AdFlowPackageVo>> findAll(HttpServletRequest request, HttpServletResponse response, String ticketId, String type) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adTicketFlowPackageService.findAll(ticketId, type);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
            return rs;
        }
        catch (PushProdException p) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u6d41\u91cf\u5305\u5173\u8054\u5217\u8868\u51fa\u9519" + p.getMessage(), (Throwable)p);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u5e7f\u544a\u5238\u6d41\u91cf\u5305\u5173\u8054\u5217\u8868\u51fa\u9519");
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u6d41\u91cf\u5305\u5173\u8054\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
    }
}

