/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAppIdPackageDTO;
import com.bxm.adsmanager.model.dto.AdAppIdPackageSearchDTO;
import com.bxm.adsmanager.service.adkeeper.AdAppIdPackageService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAppIdPackage"})
public class AdAppIdPackageController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAppIdPackageController.class);
    @Autowired
    private AdAppIdPackageService adAppIdPackageService;

    @LogBefore(operType="/adAppIdPackage/add", keyName="AppIdPackage\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@Validated @RequestBody AdAppIdPackageDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        this.adAppIdPackageService.add(dto);
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/adAppIdPackage/update", keyName="AppIdPackage\u4fee\u6539")
    @RequestMapping(value={"/update"}, method={RequestMethod.PUT})
    public ResultModel updateStatus(@Validated @RequestBody AdAppIdPackageDTO dto, HttpServletRequest request, HttpServletResponse response) {
        if (dto.getId() == null) {
            return ResultModelFactory.FAIL500((String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = this.getUser(request, response);
        try {
            this.adAppIdPackageService.update(dto);
            return ResultModelFactory.SUCCESS();
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findPage(HttpServletRequest request, HttpServletResponse response, AdAppIdPackageSearchDTO searchDTO) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo page = this.adAppIdPackageService.findPage(searchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)page);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627eAppIdPackage\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627eAppIdPackage\u51fa\u9519");
        }
        return rs;
    }
}

