/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dto.AdAssetsAdxDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsAdxService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAssetsAdx"})
public class AdAssetsAdxController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsAdxController.class);
    @Autowired
    private AdTicketAssetsAdxService adTicketAssetsAdxService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adTicketAssetsAdxService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsById"}, method={RequestMethod.GET})
    public ResultModel findAllAssetsById(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List list = this.adTicketAssetsAdxService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsListByParams"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response, AdAssetsAdxDto adAssetsAdxDto) {
        ResultModel rs = new ResultModel();
        if (adAssetsAdxDto.getTicketId() == null) {
            return ResultModelFactory.FAIL400((String)"\u793c\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Pagination list = this.adTicketAssetsAdxService.findAllAssetsListByParams(adAssetsAdxDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }
}

