/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdAssetsMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssets;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UploadImg;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAssets"})
public class AdAssetsController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsController.class);
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private UploadImg uploadImg;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private AdAssetsMapper adAssetsMapper;

    @LogBefore(operType="/adAssets/add", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel addAssets(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets) {
        ResultModel rs = new ResultModel();
        try {
            if (adAssets == null) {
                return ResultModelFactory.FAIL400((String)"\u53c2\u6570\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            }
            if (!(rs = this.checkParam(rs, adAssets)).isSuccessed()) {
                return rs;
            }
            adAssets.setCreateUser(this.getUser(request, response).getUsername());
            Long id = this.adTicketAssetsService.add(adAssets);
            rs.setReturnValue((Object)id);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adAssets/addNew", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/addNew"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addNew(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets, Long ticketId) {
        ResultModel rs = new ResultModel();
        try {
            if (adAssets == null) {
                return ResultModelFactory.FAIL400((String)"\u53c2\u6570\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
            }
            if (!(rs = this.checkParam(rs, adAssets)).isSuccessed()) {
                return rs;
            }
            adAssets.setCreateUser(this.getUser(request, response).getUsername());
            this.adTicketAssetsService.addNew(adAssets, ticketId);
            rs.setReturnValue((Object)true);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adAssets/uploadImg", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/uploadImg"}, method={RequestMethod.POST})
    @Deprecated
    public ResultModel uploadImg(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            JSONArray urlString = (JSONArray)this.uploadImg.uploadImg(response, request, "certificate", LOGGER);
            if (urlString != null) {
                JSONObject urlJson = urlString.getJSONObject(0);
                String url = (String)urlJson.get((Object)"url");
                rs.setReturnValue((Object)url);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u56fe\u7247\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u6dfb\u52a0\u5e7f\u544a\u7d20\u6750\u56fe\u7247\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adTicketAssetsService.findAll(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsById"}, method={RequestMethod.GET})
    public ResultModel findAllAssetsById(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List list = this.adTicketAssetsService.findAllAssetsById(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adAssets/update", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel updateAllAssets(HttpServletRequest request, HttpServletResponse response, AdAssets adAssets, Long ticketId) {
        ResultModel rs = new ResultModel();
        Integer result = null;
        try {
            if (adAssets == null || adAssets.getId() == null) {
                return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!(rs = this.checkParam(rs, adAssets)).isSuccessed()) {
                return rs;
            }
            adAssets.setModifyUser(this.getUser(request, response).getUsername());
            result = this.adTicketAssetsService.update(adAssets);
            if (result != null) {
                rs.setSuccessed(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        rs.setReturnValue((Object)result);
        return rs;
    }

    @LogBefore(operType="/adAssets/updateStatus", keyName="\u5e7f\u544a\u7d20\u6750\u72b6\u6001\u4fee\u6539")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateStatus(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="id") Long id, @RequestParam(name="status") Integer status) {
        ResultModel rs = new ResultModel();
        try {
            this.adTicketAssetsService.updateStatus(id, status);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u7d20\u6750\u72b6\u6001" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        rs.setReturnValue((Object)true);
        return rs;
    }

    @Deprecated
    @LogBefore(operType="/adAssets/delete", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel deleteAssets(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="ids") String ids) {
        ResultModel rs = new ResultModel();
        Integer result = null;
        if (ids == null) {
            return ResultModelFactory.FAIL400((String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Integer ticketId = this.adTicketAssetsService.findTicketByAssetIds(ids);
            result = this.adTicketAssetsService.delete(ids);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e7f\u544a\u5238\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u5e7f\u544a\u5238\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    public <T> ResultModel checkParam(ResultModel<T> rs, AdAssets adAssets) {
        if (0 == adAssets.getVars() && StringUtil.isBlank((CharSequence)adAssets.getName())) {
            return ResultModelFactory.FAIL400((String)"\u4e0d\u663e\u793a\u7701\u5e02\u7684\u65f6\u5019name\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0 != adAssets.getVars() && StringUtil.isBlank((CharSequence)adAssets.getContent())) {
            return ResultModelFactory.FAIL400((String)"\u663e\u793a\u7701\u5e02\u7684\u65f6\u5019\u7d20\u6750\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BeanValidator.validateGroup((Object)adAssets, (Class[])new Class[]{AdAssets.Add.class}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adAssets, (Class[])new Class[]{AdAssets.Add.class}).getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsListByParams"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response, AdAssetsDto adAssetsDto) {
        ResultModel rs = new ResultModel();
        if (adAssetsDto.getTicketId() == null) {
            return ResultModelFactory.FAIL400((String)"\u793c\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Pagination list = this.adTicketAssetsService.findAllAssetsListByParams(adAssetsDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/getAssetsPopupList"}, method={RequestMethod.GET})
    public ResultModel getAssetsPopupList(@RequestParam(value="popupName", required=false) String popupKeyWord) {
        ResultModel resultModel = new ResultModel();
        try {
            List list = this.adTicketAssetsService.getAssetsPopupList(popupKeyWord);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue((Object)list);
            return resultModel;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7d20\u6750\u5f39\u7a97\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u7d20\u6750\u5f39\u7a97\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adAssets/updateFlowRate", keyName="\u7d20\u6750\u6d41\u91cf\u5360\u6bd4")
    @RequestMapping(value={"/updateFlowRate"}, method={RequestMethod.POST})
    public ResultModel updateFlowRate(@RequestParam(value="assetsId") Long assetsId, @RequestParam(value="rate") Double rate) {
        if (rate < 0.0) {
            return ResultModelFactory.FAIL400((String)"\u6d41\u91cf\u5360\u6bd4\u8f93\u5165\u9519\u8bef");
        }
        try {
            this.adTicketAssetsService.updateFlowRate(assetsId, rate);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u7d20\u6750\u6d41\u91cf\u5360\u6bd4\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u7d20\u6750\u6d41\u91cf\u5360\u6bd4\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adAssets/updateAssetsSelectType", keyName="\u7d20\u6750\u4eba\u5de5\u63a7\u5236\u6216\u7b97\u6cd5")
    @RequestMapping(value={"/updateAssetsSelectType"}, method={RequestMethod.POST})
    public ResultModel updateAssetsSelectType(@RequestParam(value="ticketId") Long ticketId, @RequestParam(value="assetsSelectType") Short assetsSelectType) {
        if (assetsSelectType != 1 && assetsSelectType != 0) {
            return ResultModelFactory.FAIL400((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        try {
            this.adTicketAssetsService.updateAssetsSelectType(ticketId, assetsSelectType);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u7d20\u6750\u9009\u62e9\u7c7b\u578b\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u7d20\u6750\u9009\u62e9\u7c7b\u578b\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/getAssetsSelectType"}, method={RequestMethod.GET})
    public ResultModel getAssetsSelectType(@RequestParam(value="ticketId") Long ticketId) {
        try {
            Short assetsSelectType = this.adTicketAssetsService.getAssetsSelectType(ticketId);
            return ResultModelFactory.SUCCESS((Serializable)assetsSelectType);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/getTicketAssetsCopyList"}, method={RequestMethod.GET})
    public ResultModel getTicketAssetsCopyList(@RequestParam(value="ticketKeyword") String ticketKeyword, @RequestParam(value="ticketType") Short ticketType, HttpServletRequest request, HttpServletResponse response) {
        try {
            ResultModel resultModel = new ResultModel();
            User user = this.getUser(request, response);
            List vos = this.adTicketAssetsService.getTicketAssetsCopyList(ticketKeyword, ticketType, user.getUsername());
            resultModel.setSuccessed(true);
            resultModel.setReturnValue((Object)vos);
            return resultModel;
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/copyTicketAssets"}, method={RequestMethod.GET})
    public ResultModel copyTicketAssets(@RequestParam(value="copyTicketId") Long copyTicketId, @RequestParam(value="targetTicketId") Long targetTicketId, HttpServletRequest request, HttpServletResponse response) {
        AdTicket copyTicket = this.adTicketMapper.selectByPrimaryKey(copyTicketId);
        AdTicket targetTicket = this.adTicketMapper.selectByPrimaryKey(targetTicketId);
        if (copyTicket == null || targetTicket == null) {
            return ResultModelFactory.FAIL500((String)"\u590d\u5236\u7684\u5238\u4e0d\u5b58\u5728");
        }
        if (!ObjectUtils.equals((Object)copyTicket.getType(), (Object)targetTicket.getType())) {
            return ResultModelFactory.FAIL500((String)"\u590d\u5236\u7684\u5238\u4e0d\u662f\u540c\u7c7b\u578b");
        }
        List allAssetsById = this.adTicketAssetsService.findAllAssetsById(copyTicketId);
        if (CollectionUtils.isEmpty((Collection)allAssetsById)) {
            return ResultModelFactory.FAIL500((String)"\u590d\u5236\u7684\u5238\u4e0b\u6ca1\u6709\u7d20\u6750");
        }
        int pass = 0;
        int resuse = 0;
        for (AdAssets assets : allAssetsById) {
            if (assets.getStatus() != null && assets.getStatus() == 2) continue;
            if (assets.getAuditStatus() != null && assets.getAuditStatus() == 3) {
                ++resuse;
                continue;
            }
            ++pass;
            assets.setId(null);
            assets.setStatus(Short.valueOf((short)0));
            assets.setAuditStatus(Integer.valueOf(1));
            assets.setRefuseReason(null);
            ResultModel<Boolean> resultModel = this.addNew(request, response, assets, targetTicketId);
            if (resultModel == null || resultModel.getReturnValue() != null) continue;
            LOGGER.warn("\u590d\u5236\u5238\u7d20\u6750\u65f6\u51fa\u9519\uff0ccopyTicketId:{}, targetTicketId:{}, assetsId:{}", new Object[]{copyTicketId, targetTicketId, assets.getId()});
        }
        String message = "\u6210\u529f\u590d\u5236\u7d20\u6750" + pass + "\u6761\uff0c" + resuse + "\u6761\u5904\u4e8e\u5ba1\u6838\u62d2\u7edd\u72b6\u6001\u590d\u5236\u5931\u8d25";
        return ResultModelFactory.SUCCESS((Serializable)((Object)message));
    }
}

