/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsInspireVideoDto;
import com.bxm.adsmanager.model.dto.AdAssetsInspireVideoSearchDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsInspireVideoService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@RestController
@RequestMapping(value={"/adAssetsInspireVideo"})
public class AdAssetsInspireVideoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsInspireVideoController.class);
    @Autowired
    private AdTicketAssetsInspireVideoService adTicketAssetsInspireVideoService;
    private String bucketName = "bxm-guide";
    private String fileHost = "https://buyimg.bianxianmao.com/";
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@Validated AdAssetsInspireVideoDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        dto.setCreateUser(user.getUsername());
        this.adTicketAssetsInspireVideoService.add(dto);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel update(@Validated AdAssetsInspireVideoDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        dto.setModifyUser(user.getUsername());
        this.adTicketAssetsInspireVideoService.update(dto);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public ResultModel updateStatus(Long id, Integer status, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adTicketAssetsInspireVideoService.updateStatus(id, status, user.getUsername());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adTicketAssetsInspireVideoService.delete(id, user.getUsername());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adTicketAssetsInspireVideoService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsById"}, method={RequestMethod.GET})
    public ResultModel findAllAssetsById(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List list = this.adTicketAssetsInspireVideoService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsListByParams"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response, AdAssetsInspireVideoSearchDto adAssetsInspireVideoSearchDto) {
        ResultModel rs = new ResultModel();
        if (adAssetsInspireVideoSearchDto.getTicketId() == null) {
            return ResultModelFactory.FAIL400((String)"\u793c\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            Pagination list = this.adTicketAssetsInspireVideoService.findAllAssetsListByParams(adAssetsInspireVideoSearchDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResultModel<List<String>> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultModel resultModel = new ResultModel();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> files = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String fileName;
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null || (fileName = file.getOriginalFilename()).trim() == "") continue;
                File newFile = new File(fileName);
                FileOutputStream outStream = new FileOutputStream(newFile);
                outStream.write(file.getBytes());
                outStream.close();
                file.transferTo(newFile);
                files.add(AliOSSUtil.upload((String)this.accessKeyId, (String)this.secret, (File)newFile, (String)this.bucketName, (String)this.fileHost, null));
                newFile.delete();
            }
        }
        if (files.isEmpty()) {
            resultModel.setErrorDesc("\u7cfb\u7edf\u5f02\u5e38,\u4e0a\u4f20\u56fe\u7247\u5931\u8d25");
            resultModel.setReturnValue(null);
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(files);
        return resultModel;
    }
}

