/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsTemplateAssetsMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsDto;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsSearchDTO;
import com.bxm.adsmanager.model.dto.AdAssetsTemplateAssetsUpdateStatusDTO;
import com.bxm.adsmanager.model.dto.AdTicketCheckInfokDto;
import com.bxm.adsmanager.model.enums.PanguAdxEnum;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsTemplateAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.audit.AdAuditService;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.AliOSSUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@RestController
@RequestMapping(value={"/adAssetsTemplateAssets"})
public class AdAssetsTemplateAssetsController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdAssetsTemplateAssetsController.class);
    @Autowired
    private AdTicketAssetsTemplateAssetsService adTicketAssetsTemplateAssetsService;
    @Autowired
    private AdAssetsTemplateAssetsMapperExt adAssetsTemplateAssetsMapperExt;
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdAuditService adAuditService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private ProdService prodService;
    private String bucketName = "bxm-guide";
    private String fileHost = "https://buyimg.bianxianmao.com/";
    private String accessKeyId = "LTAIdRl4etA0hXJt";
    private String secret = "oVazl7iJufs7QfGJBuGWoIkJTjIjUa";

    @LogBefore(operType="/adAssetsTemplateAssets/add", keyName="\u7d20\u6750\u6a21\u677f\u7d20\u6750\u65b0\u589e")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@Validated AdAssetsTemplateAssetsDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        dto.setCreateUser(user.getUsername());
        Long ticketId = dto.getTicketId();
        try {
            Long assetId = this.adTicketAssetsTemplateAssetsService.add(dto);
            this.afterHandle(user, ticketId, assetId);
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    private void afterHandle(User user, Long ticketId, Long assetId) throws Exception {
        AdTicket adTicket = this.adTicketService.find(ticketId);
        if (AdTicket.AdTicketType.isNotNewAdx((Short)adTicket.getType())) {
            return;
        }
        AdvertiserDto advertiserDto = this.adShopIntegration.findAdShopMsg(adTicket.getAdvertiser().longValue());
        if (1 == advertiserDto.getAssetAuditWhiteStatus()) {
            boolean mayAuditPass;
            boolean unAuditTicket = false;
            if (-2 == adTicket.getStatus()) {
                AdTicketCheckInfokDto adTicketCheckInfokDto = this.adTicketService.getTicketInfoAndAssetsModify(ticketId);
                Integer status = 1;
                String refuseReason = null;
                String tags = adTicketCheckInfokDto.getTags();
                String domainCode = adTicketCheckInfokDto.getDomainCode();
                Boolean success = this.adTicketService.ticketCheck(ticketId, status, refuseReason, tags, domainCode, "SYSTEM_AUDIT");
                unAuditTicket = true;
            }
            boolean bl = mayAuditPass = unAuditTicket || 1 == adTicket.getStatus() || 2 == adTicket.getStatus() || 3 == adTicket.getStatus();
            if (mayAuditPass) {
                int ticketType = 3;
                short auditStatus = 2;
                this.adAuditService.asstesAudit(null, Arrays.asList(assetId), Short.valueOf(auditStatus), null, Integer.valueOf(ticketType), (short)2, user.getUsername());
            }
        }
    }

    @LogBefore(operType="/adAssetsTemplateAssets/update", keyName="\u7d20\u6750\u6a21\u677f\u7d20\u6750\u4fee\u6539")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel update(@Validated AdAssetsTemplateAssetsDto dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        dto.setModifyUser(user.getUsername());
        Long ticketId = dto.getTicketId();
        try {
            Long assetId = this.adTicketAssetsTemplateAssetsService.update(dto);
            this.afterHandle(user, ticketId, assetId);
            this.prodService.pushAdTicketToProdPre(ticketId);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5931\u8d25");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/adAssetsTemplateAssets/updateStatus", keyName="\u7d20\u6750\u6a21\u677f\u7d20\u6750\u72b6\u6001\u4fee\u6539")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public ResultModel updateStatus(@Validated @RequestBody AdAssetsTemplateAssetsUpdateStatusDTO dto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        dto.setModifyUser(user.getUsername());
        try {
            this.adTicketAssetsTemplateAssetsService.updateStatus(dto);
            this.prodService.pushAdTicketToProdPre(dto.getTicketId());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/adAssetsTemplateAssets/delete", keyName="\u7d20\u6750\u6a21\u677f\u7d20\u6750\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            this.adTicketAssetsTemplateAssetsService.delete(id, user.getUsername());
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAllAssets(String ids) {
        ResultModel rs = new ResultModel();
        try {
            List list = this.adTicketAssetsTemplateAssetsService.findByIds(ids);
            if (null == list) {
                rs.setSuccessed(false);
                rs.setErrorCode("5031");
                rs.setErrorDesc("\u83b7\u53d6\u6570\u636e\u4e3a\u7a7a");
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u7d20\u6750ids\u67e5\u627e\u6240\u6709\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsById"}, method={RequestMethod.GET})
    public ResultModel findAllAssetsByTicketId(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List list = this.adTicketAssetsTemplateAssetsService.findByTicketId(id);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllAssetsListByParams"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<Pagination> findAllAssetsListByParams(HttpServletRequest request, HttpServletResponse response, AdAssetsTemplateAssetsSearchDTO adAssetsTemplateAssetsSearchDto) {
        ResultModel rs = new ResultModel();
        if (adAssetsTemplateAssetsSearchDto.getTicketId() == null) {
            adAssetsTemplateAssetsSearchDto.setPageNum(Integer.valueOf(1));
            adAssetsTemplateAssetsSearchDto.setPageSize(Integer.valueOf(20));
        }
        try {
            Pagination list = this.adTicketAssetsTemplateAssetsService.findAllAssetsListByParams(adAssetsTemplateAssetsSearchDto);
            if (list != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u7d20\u6750\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResultModel<List<String>> upload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResultModel resultModel = new ResultModel();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        ArrayList<String> files = new ArrayList<String>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                String fileName;
                MultipartFile file = multiRequest.getFile((String)iter.next());
                if (file == null || (fileName = file.getOriginalFilename()).trim() == "") continue;
                File newFile = new File(fileName);
                FileOutputStream outStream = new FileOutputStream(newFile);
                outStream.write(file.getBytes());
                outStream.close();
                file.transferTo(newFile);
                files.add(AliOSSUtil.upload((String)this.accessKeyId, (String)this.secret, (File)newFile, (String)this.bucketName, (String)this.fileHost, null));
                newFile.delete();
            }
        }
        if (files.isEmpty()) {
            resultModel.setErrorDesc("\u7cfb\u7edf\u5f02\u5e38,\u4e0a\u4f20\u56fe\u7247\u5931\u8d25");
            resultModel.setReturnValue(null);
            resultModel.setSuccessed(false);
            return resultModel;
        }
        resultModel.setReturnValue(files);
        return resultModel;
    }

    @RequestMapping(value={"/getTicketAssetsCopyList"}, method={RequestMethod.GET})
    public ResultModel getTicketAssetsCopyList(@RequestParam(value="ticketKeyword") String ticketKeyword) {
        try {
            ResultModel resultModel = new ResultModel();
            List vos = this.adTicketAssetsTemplateAssetsService.getTicketAssetsCopyList(ticketKeyword);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue((Object)vos);
            return resultModel;
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u670d\u52a1\u5668\u9519\u8bef");
        }
    }

    @LogBefore(operType="/adAssetsTemplateAssets/copyTicketAssets", keyName="\u7d20\u6750\u6a21\u677f\u7d20\u6750\u590d\u5236")
    @RequestMapping(value={"/copyTicketAssets"}, method={RequestMethod.GET})
    public ResultModel copyTicketAssets(@RequestParam(value="copyTicketId") Long copyTicketId, @RequestParam(value="targetTicketId") Long targetTicketId, @RequestParam(value="ids", required=false) List<Long> ids, HttpServletRequest request, HttpServletResponse response) {
        boolean hasSuccess;
        User user = this.getUser(request, response);
        ArrayList tips = new ArrayList();
        try {
            List assetIds = this.adTicketAssetsTemplateAssetsService.copyTicketAssets(copyTicketId, targetTicketId, ids, user, tips, null);
            if (CollectionUtils.isNotEmpty((Collection)assetIds)) {
                for (Long assetId : assetIds) {
                    this.afterHandle(user, targetTicketId, assetId);
                }
            }
            this.prodService.pushAdTicketToProdPre(targetTicketId);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u590d\u5236\u5931\u8d25");
        }
        boolean bl = hasSuccess = tips.size() < ids.size();
        if (hasSuccess) {
            return ResultModelFactory.SUCCESS((Serializable)((Object)StringUtils.join(tips, (String)",\n")));
        }
        return ResultModelFactory.FAIL400((String)StringUtils.join(tips, (String)",\n"));
    }

    @LogBefore(operType="/adAssetsTemplateAssets/submitToOppoAudit", keyName="\u63d0\u4ea4\u7d20\u6750\u6a21\u677f\u7d20\u6750\u5230oppo\u5ba1\u6838")
    @RequestMapping(value={"/submitToOppoAudit"}, method={RequestMethod.POST})
    public ResultModel submitToOppoAudit(@RequestParam(value="ids", required=false) List<Long> ids, HttpServletRequest request, HttpServletResponse response) {
        if (ids.size() > 30) {
            return ResultModelFactory.FAIL500((String)"\u6700\u591a\u63d0\u4ea430\u4e2a\u7d20\u6750");
        }
        User user = this.getUser(request, response);
        try {
            String auditMessage = this.adTicketAssetsTemplateAssetsService.submitToAdxAudit(PanguAdxEnum.OPPO, ids, user);
            if (StringUtils.isNotBlank((CharSequence)auditMessage)) {
                return ResultModelFactory.FAIL400((String)auditMessage);
            }
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u64cd\u4f5c\u5931\u8d25");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/adAssetsTemplateAssets/submitToMeiTuanAudit", keyName="\u63d0\u4ea4\u7d20\u6750\u6a21\u677f\u7d20\u6750\u5230\u7f8e\u56e2\u5ba1\u6838")
    @RequestMapping(value={"/submitToMeiTuanAudit"}, method={RequestMethod.POST})
    public ResultModel submitToMeiTuanAudit(@RequestParam(value="ids", required=false) List<Long> ids, HttpServletRequest request, HttpServletResponse response) {
        if (ids.size() > 30) {
            return ResultModelFactory.FAIL500((String)"\u6700\u591a\u63d0\u4ea430\u4e2a\u7d20\u6750");
        }
        User user = this.getUser(request, response);
        try {
            String auditMessage = this.adTicketAssetsTemplateAssetsService.submitToAdxAudit(PanguAdxEnum.MEI_TUAN, ids, user);
            if (StringUtils.isNotBlank((CharSequence)auditMessage)) {
                return ResultModelFactory.FAIL400((String)auditMessage);
            }
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u64cd\u4f5c\u5931\u8d25");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/adAssetsTemplateAssets/syncTicketAssets", keyName="\u7d20\u6750\u6a21\u677f\u7d20\u6750\u540c\u6b65")
    @RequestMapping(value={"/syncTicketAssets"}, method={RequestMethod.GET})
    public ResultModel syncTicketAssets(@RequestParam(value="copyTicketId") Long copyTicketId, @RequestParam(value="targetTicketIds") String targetTicketIds, @RequestParam(value="ids", required=false) List<Long> ids, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        String[] targetTicketArray = targetTicketIds.split(",");
        ArrayList<String> assetsTips = new ArrayList<String>();
        HashMap<String, HashSet<String>> existDuplicateTicketMap = new HashMap<String, HashSet<String>>();
        ArrayList ticketMessage = new ArrayList();
        boolean hasSuccess = false;
        try {
            for (String targetTicketId : targetTicketArray) {
                if (!this.doCopy(copyTicketId, Long.parseLong(targetTicketId), ids, user, assetsTips, existDuplicateTicketMap)) continue;
                hasSuccess = true;
            }
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u64cd\u4f5c\u5931\u8d25");
        }
        if (MapUtils.isNotEmpty(existDuplicateTicketMap)) {
            existDuplicateTicketMap.forEach((assetsId, ticketIds) -> {
                String join = StringUtils.join((Object[])new HashSet[]{ticketIds});
                ticketMessage.add(String.format("%s\u5728\u5238%s\u4e2d\u5df2\u5b58\u5728", assetsId, join));
            });
        }
        String duplicateMessage = "";
        duplicateMessage = duplicateMessage + StringUtils.join(ticketMessage, (String)",");
        if (CollectionUtils.isNotEmpty(assetsTips)) {
            duplicateMessage = duplicateMessage + ";\n " + StringUtils.join(assetsTips, (String)",\n");
        }
        if (hasSuccess) {
            return ResultModelFactory.SUCCESS((Serializable)((Object)duplicateMessage.replace("\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", "")));
        }
        return ResultModelFactory.FAIL400((String)duplicateMessage.replace("\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0", ""));
    }

    private boolean doCopy(Long copyTicketId, Long targetTicketId, List<Long> ids, User user, List<String> tips, Map<String, HashSet<String>> ticketTips) throws Exception {
        List assetIds = this.adTicketAssetsTemplateAssetsService.copyTicketAssets(copyTicketId, targetTicketId, ids, user, tips, ticketTips);
        if (CollectionUtils.isNotEmpty((Collection)assetIds)) {
            for (Long assetId : assetIds) {
                this.afterHandle(user, targetTicketId, assetId);
            }
        }
        this.prodService.pushAdTicketToProdPre(targetTicketId);
        return CollectionUtils.isNotEmpty((Collection)assetIds);
    }

    @RequestMapping(value={"/findAssetsFillRate"}, method={RequestMethod.GET})
    public ResultModel findAssetsFillRate(@RequestParam(value="ticketId") Long ticketId, HttpServletRequest request, HttpServletResponse response) {
        try {
            return ResultModelFactory.SUCCESS((Serializable)this.adTicketAssetsTemplateAssetsService.findAssetsFillRate(ticketId));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7d20\u6750\u586b\u5145\u7387\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u83b7\u53d6\u7d20\u6750\u586b\u5145\u7387\u5931\u8d25");
        }
    }
}

