/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dao.adkeeper.AdPositionAssetSize;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdPositionAssetSizeDto;
import com.bxm.adsmanager.model.dto.AdPositionAssetSizeSearchDto;
import com.bxm.adsmanager.model.vo.AdPositionAssetSizeVo;
import com.bxm.adsmanager.service.adkeeper.AdPositionAssetSizeService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adPositionAssetSize"})
public class AdPositionAssetSizeController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPositionAssetSizeController.class);
    @Autowired
    private AdPositionAssetSizeService adPositionAssetSizeService;

    @LogBefore(operType="/adPositionAssetSize/add", keyName="\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u6dfb\u52a0")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdPositionAssetSizeDto adPositionAssetSizeDto) {
        try {
            if (BeanValidator.validateGroup((Object)adPositionAssetSizeDto, (Class[])new Class[]{AdPositionAssetSizeDto.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adPositionAssetSizeDto, (Class[])new Class[]{AdPositionAssetSizeDto.Add.class}).getMessage());
            }
            User user = this.getUser(request, response);
            Long positionAssetSizeId = this.adPositionAssetSizeService.add(adPositionAssetSizeDto, user.getUsername());
            return ResultModelFactory.SUCCESS((Serializable)positionAssetSizeId);
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519");
        }
    }

    @LogBefore(operType="/adPositionAssetSize/update", keyName="\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u66f4\u65b0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdPositionAssetSizeDto adPositionAssetSizeDto) {
        ResultModel rs = new ResultModel();
        if (adPositionAssetSizeDto == null || adPositionAssetSizeDto.getId() == null) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (BeanValidator.validateGroup((Object)adPositionAssetSizeDto, (Class[])new Class[]{AdPositionAssetSizeDto.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adPositionAssetSizeDto, (Class[])new Class[]{AdPositionAssetSizeDto.Update.class}).getMessage());
            }
            User user = this.getUser(request, response);
            Integer result = this.adPositionAssetSizeService.update(adPositionAssetSizeDto, user.getUsername());
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    public ResultModel<AdPositionAssetSizeVo> find(Long id) {
        ResultModel rs = new ResultModel();
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            AdPositionAssetSizeVo result = this.adPositionAssetSizeService.findById(id);
            rs.setReturnValue((Object)result);
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAllByActivate"}, method={RequestMethod.GET})
    public ResultModel<List<AdPositionAssetSizeVo>> findBykeywords(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adPositionAssetSizeService.findAllByActive();
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdPositionAssetSizeVo>> findAll(AdPositionAssetSizeSearchDto searchDto, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.adPositionAssetSizeService.findAll(searchDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6240\u6709\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u6240\u6709\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adPositionAssetSize/updateStatus", keyName="\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u72b6\u6001\u66f4\u65b0")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id, @RequestParam(required=true, name="status") Short status) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            AdPositionAssetSizeDto adPositionAssetSizeDto = new AdPositionAssetSizeDto();
            adPositionAssetSizeDto.setId(Integer.valueOf(id.intValue()));
            adPositionAssetSizeDto.setStatus(status);
            Object result = this.adPositionAssetSizeService.updateStatus(adPositionAssetSizeDto, user.getUsername());
            this.addLogs(user, JSON.toJSONString((Object)(AdPositionAssetSize.AdPositionAssetSizeStatus.getName((short)status) + "\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8")), String.valueOf(id));
            rs.setReturnValue(result);
        }
        catch (ValidateException v) {
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u72b6\u6001\u51fa\u9519");
        }
        return rs;
    }
}

