/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dto.AdPositionSearchDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.service.adkeeper.AdPositionService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/adProsition"})
@RestController
public class AdPrositionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdPrositionController.class);
    @Autowired
    private AdPositionService adPositionService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findAll(AdPositionSearchDto adPositionSearchDto) {
        ResultModel rs = new ResultModel();
        if (null == adPositionSearchDto) {
            adPositionSearchDto = new AdPositionSearchDto();
        }
        try {
            Pagination result = this.adPositionService.findAll(adPositionSearchDto);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4f4d\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u4f4d\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findByAdTicketId"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findByAdTicketId(HttpServletRequest request, HttpServletResponse response, AdPositionSearchDto adPositionSearchDto) {
        ResultModel rs = new ResultModel();
        try {
            if (adPositionSearchDto == null || null == adPositionSearchDto.getAdTicketId()) {
                return ResultModelFactory.FAIL400((String)"adTicketId is null");
            }
            Pagination result = this.adPositionService.findByAdTicketId(adPositionSearchDto);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u4f4d\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u5238id\u67e5\u627e\u5e7f\u544a\u4f4d\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findByIdsStr"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel<Pagination> findByIdsStr(HttpServletRequest request, HttpServletResponse response, AdPositionSearchDto adPositionSearchDto) {
        ResultModel rs = new ResultModel();
        try {
            Pagination result = this.adPositionService.findByIdsStr(adPositionSearchDto);
            if (result != null) {
                rs.setReturnValue((Object)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u5e7f\u544a\u4f4did\u67e5\u627e\u5e7f\u544a\u4f4d\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6839\u636e\u5e7f\u544a\u4f4did\u67e5\u627e\u5e7f\u544a\u4f4d\u9519\u8bef");
        }
        return rs;
    }
}

