/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.adsmedia.appentrance.NewAppEntranceFacadeIntegration;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.exception.PushProdException;
import com.bxm.adsmanager.model.constant.CommonConstant;
import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsCoupons;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsInfo;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketUrlTest;
import com.bxm.adsmanager.model.dao.adkeeper.TblAdTicketModify;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdFlowPackageNewDto;
import com.bxm.adsmanager.model.dto.AdTicketCheckDto;
import com.bxm.adsmanager.model.dto.AdTicketCheckInfokDto;
import com.bxm.adsmanager.model.dto.AdTicketDto;
import com.bxm.adsmanager.model.dto.AdTicketFlowPackageAddBatchDto;
import com.bxm.adsmanager.model.dto.AdTicketPositionAddBatchDto;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.enums.AdxPriceTypeEnum;
import com.bxm.adsmanager.model.enums.PageTypeEnum;
import com.bxm.adsmanager.model.enums.RoleEnum;
import com.bxm.adsmanager.model.vo.AdTicketAppEntranceVo;
import com.bxm.adsmanager.model.vo.AdTicketPositionTimesLimitConfigVo;
import com.bxm.adsmanager.model.vo.AdTicketVo;
import com.bxm.adsmanager.model.vo.PaginationTemp;
import com.bxm.adsmanager.service.adflowpackage.AdFlowPackageService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsCouponsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketService;
import com.bxm.adsmanager.service.adkeeper.TblAdTicketModifyService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.DateUtils;
import com.bxm.adsmanager.utils.RequestUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.TicketUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceAdRO;
import com.bxm.adsmedia.facade.model.appentrance.QueryAppEntranceParamDTO;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicket"})
public class AdTicketController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketController.class);
    private final Map<Integer, String> ticketModifyUsers = Maps.newConcurrentMap();
    @Autowired
    private AdTicketService adTicketService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private TblAdTicketModifyService tblAdTicketModifyService;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;
    @Autowired
    private NewAppEntranceFacadeIntegration newAppEntranceFacadeIntegration;
    @Autowired
    private AdTicketAssetsCouponsService adTicketAssetsCouponsService;
    @Autowired
    private AdFlowPackageService adFlowPackageService;
    @Autowired
    private JedisUpdater jedisUpdater;

    @LogBefore(operType="/adTicket/add", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, AdTicketDto adTicketDto) {
        try {
            ResultModel resultModel = this.validateTicketConfig(adTicketDto, AdTicketDto.Add.class);
            if (resultModel != null) {
                return resultModel;
            }
            if (AdTicket.AdTicketType.isNotAdx((Short)adTicketDto.getType())) {
                adTicketDto.setStatus(Short.valueOf((short)-2));
            }
            User user = this.getUser(request, response);
            if (StringUtil.isBlank((CharSequence)adTicketDto.getAe())) {
                adTicketDto.setAe(user.getUsername());
            }
            Long ticketId = this.adTicketService.add(adTicketDto, user.getUsername());
            try {
                if (ticketId != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())) {
                    this.jedisUpdater.hupdate(RedisKeys.getPddTickets(), String.valueOf(ticketId), (Object)adTicketDto.getAdvertiser());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5238\u5165Redis\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
            AdTicketVo adTicketVo = this.adTicketService.findById(ticketId);
            if (adTicketVo.getStatus() == -2) {
                AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
                adTicketUrlTest.setTicketId(ticketId);
                adTicketUrlTest.setActionType(Short.valueOf((short)0));
                adTicketUrlTest.setDealStatus(Short.valueOf((short)0));
                adTicketUrlTest.setCreateTime(new Date());
                adTicketUrlTest.setModifyTime(new Date());
                this.adTicketService.addTicketUrlTest(adTicketUrlTest);
            }
            try {
                this.tblAdTicketModifyService.addLog(adTicketDto);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5e7f\u544a\u5238\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25");
                e.printStackTrace();
            }
            this.addLogs(user, "\u65b0\u589e\uff1a" + JSON.toJSONString((Object)adTicketDto), String.valueOf(ticketId));
            this.afterHandle(ticketId);
            return ResultModelFactory.SUCCESS((Serializable)ticketId);
        }
        catch (PushProdException p) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u51fa\u9519:" + p.getMessage(), (Throwable)p);
            return ResultModelFactory.FAIL500((String)"\u63a8\u9001\u6570\u636e\u5230\u524d\u7aef\u5f02\u5e38");
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u5238\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u6dfb\u52a0\u5e7f\u544a\u5238\u51fa\u9519");
        }
    }

    private ResultModel validateTicketConfig(AdTicketDto adTicketDto, Class classz) {
        ResultModel resultModel;
        if (BeanValidator.validateGroup((Object)adTicketDto, (Class[])new Class[]{classz}) != null) {
            return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)adTicketDto, (Class[])new Class[]{classz}).getMessage());
        }
        try {
            Double budgetDailyDouble = adTicketDto.getBudgetDaily();
            Short settleType = adTicketDto.getSettleType();
            TicketUtil.checkBudgetDaily((Double)budgetDailyDouble, (Short)settleType);
        }
        catch (ValidateException e) {
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
        AdTicket.AdTicketType adTicketType = AdTicket.AdTicketType.getByType((Short)adTicketDto.getType());
        if (adTicketType == null) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5238\u7c7b\u578b\u975e\u6cd5\uff01");
        }
        if (AdTicket.AdTicketType.isNotAdx((Short)adTicketDto.getType()) && null != (resultModel = this.validateTicketAppExtendArgs(adTicketDto))) {
            return resultModel;
        }
        resultModel = null;
        switch (adTicketType) {
            case TYPE_NORMALS: 
            case TYPE_STANDBYS: 
            case TYPE_PUSH: {
                break;
            }
            case TYPE_ENCOURAGE: {
                break;
            }
            case TYPE_DSP: {
                break;
            }
            case TYPE_RTA: {
                break;
            }
            case TYPE_COUPON: {
                resultModel = this.validateCouponsArgs(adTicketDto);
                break;
            }
            case TYPE_ADX_DIRECT: 
            case TYPE_ADX_INTERACT: {
                resultModel = this.validateAdxArgs(adTicketDto);
                break;
            }
            case TYPE_INSPIRE_VIDEO: 
            case TYPE_INSPIRE_VIDEO_STANDBYS: {
                break;
            }
            case TYPE_ACTIVITY: 
            case TYPE_DIRECT: {
                resultModel = this.validateActivityAndDirectArgs(adTicketDto);
                break;
            }
            default: {
                return ResultModelFactory.FAIL400((String)"\u672a\u5904\u7406\u7684\u5e7f\u544a\u5238\u7c7b\u578b\uff01");
            }
        }
        if (resultModel != null) {
            return resultModel;
        }
        if ((AdTicket.AdTicketType.TYPE_ADX_DIRECT == adTicketType || AdTicket.AdTicketType.TYPE_ADX_INTERACT == adTicketType) && AdTicketDto.Add.class == classz && adTicketDto.getUrl().contains("xid")) {
            return ResultModelFactory.FAIL400((String)"\u843d\u5730\u9875\u4e0d\u80fd\u5b58\u5728xid\u53c2\u6570\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)adTicketDto.getPositionTimesLimitConfig())) {
            List adTicketPositionTimesLimitConfigVos = JSON.parseArray((String)adTicketDto.getPositionTimesLimitConfig(), AdTicketPositionTimesLimitConfigVo.class);
            ArrayList<String> dateString = new ArrayList<String>();
            for (AdTicketPositionTimesLimitConfigVo adTicketPositionTimesLimitConfigVo : adTicketPositionTimesLimitConfigVos) {
                if (adTicketPositionTimesLimitConfigVo.getStartHour() > adTicketPositionTimesLimitConfigVo.getEndHour()) {
                    return ResultModelFactory.FAIL400((String)"\u5f00\u59cb\u7684\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002");
                }
                dateString.add(adTicketPositionTimesLimitConfigVo.getStartHour() + "-" + adTicketPositionTimesLimitConfigVo.getEndHour());
            }
            List errorList = DateUtils.validatedDateOverlap(dateString, (String)"-", (String)"HH");
            if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                return ResultModelFactory.FAIL400((String)errorList.toString());
            }
        }
        return null;
    }

    private ResultModel validateAdxArgs(AdTicketDto adTicketDto) {
        AdTicketDto.AdxConfDto adxConfDto = adTicketDto.getAdxConfDto();
        if (adxConfDto == null) {
            return ResultModelFactory.FAIL400((String)"ADX\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (adxConfDto.getClickMaximum() == null && adxConfDto.getShowMaximum() == null) {
            return ResultModelFactory.FAIL400((String)"\u6bcf\u65e5\u6700\u591a\u66dd\u5149\u6b21\u6570,\u6bcf\u65e5\u6700\u591a\u70b9\u51fb\u6b21\u6570\u5fc5\u987b\u586b\u5199\u5176\u4e2d\u4e00\u9879\uff01");
        }
        if (adxConfDto.getSpeed() == null) {
            return ResultModelFactory.FAIL400((String)"\u6295\u653e\u901f\u5ea6\u5fc5\u987b\u586b\u5199\uff01");
        }
        if (StringUtils.isBlank((CharSequence)adTicketDto.getAdxConfDto().getAssetsAdxArray())) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u7d20\u6750\u5fc5\u987b\u586b\u5199\uff01");
        }
        return null;
    }

    private ResultModel validateInspireVideoArgs(AdTicketDto adTicketDto) {
        AdTicketDto.InspireVideoConfDto inspireVideoConfDto = adTicketDto.getInspireVideoConfDto();
        if (inspireVideoConfDto == null) {
            return ResultModelFactory.FAIL400((String)"\u6fc0\u52b1\u89c6\u9891\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (inspireVideoConfDto.getPageType() == null) {
            return ResultModelFactory.FAIL400((String)"\u843d\u5730\u9875\u7c7b\u578b\u5fc5\u987b\u586b\u5199\uff01");
        }
        if (StringUtils.isBlank((CharSequence)inspireVideoConfDto.getAssetsInspireVideoArray())) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u7d20\u6750\u5fc5\u987b\u586b\u5199\uff01");
        }
        return null;
    }

    private ResultModel validateTicketAppExtendArgs(AdTicketDto adTicketDto) {
        AdTicketDto.TicketAppExtendDto ticketAppExtendDto = adTicketDto.getTicketAppExtendDto();
        if (ticketAppExtendDto == null) {
            return ResultModelFactory.FAIL400((String)"ticketAppExtendDto\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ticketAppExtendDto.getPageType() == null) {
            return ResultModelFactory.FAIL400((String)"\u843d\u5730\u9875\u7c7b\u578b\u5fc5\u987b\u586b\u5199\uff01");
        }
        if (ticketAppExtendDto.getAppPackageRate() == null) {
            return ResultModelFactory.FAIL400((String)"appPackageRate\u5fc5\u987b\u586b\u5199\uff01");
        }
        return null;
    }

    private ResultModel validateActivityAndDirectArgs(AdTicketDto adTicketDto) {
        AdTicketDto.TicketAppExtendDto ticketAppExtendDto = adTicketDto.getTicketAppExtendDto();
        if (ticketAppExtendDto == null) {
            return ResultModelFactory.FAIL400((String)"ticketAppExtendDto\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)ticketAppExtendDto.getBdTags())) {
            return ResultModelFactory.FAIL400((String)"\u767e\u5ea6BES\u5e7f\u544a\u6807\u7b7e\u7c7b\u578b\u5fc5\u987b\u586b\u5199\uff01");
        }
        if (ticketAppExtendDto.getAdxBudgetDaily() == null) {
            return ResultModelFactory.FAIL400((String)"ADX\u6210\u672c\u65e5\u9884\u7b97\u5fc5\u987b\u586b\u5199\uff01");
        }
        if (AdTicket.AdTicketType.TYPE_ADX_DIRECT.getType() == adTicketDto.getType().shortValue() && StringUtils.isBlank((CharSequence)ticketAppExtendDto.getLandingPageEndJumpUrl())) {
            return ResultModelFactory.FAIL400((String)"\u843d\u5730\u9875\u6700\u540e\u4e00\u8df3\u5730\u5740\u5fc5\u987b\u586b\u5199\uff01");
        }
        Double adxPrice = ticketAppExtendDto.getAdxPrice();
        if (adxPrice == null) {
            return ResultModelFactory.FAIL400((String)"ADX CPM\u6210\u672c\u5fc5\u987b\u586b\u5199\uff01");
        }
        if (Objects.equals(AdxPriceTypeEnum.CPC.getType(), ticketAppExtendDto.getAdxPriceType())) {
            if (RequestUtils.isAdxPriceLimitUserName()) {
                if (adxPrice <= 0.0 || adxPrice > 0.5) {
                    return ResultModelFactory.FAIL400((String)"adx\u51fa\u4ef7\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u4e0d\u5927\u4e8e0.5\u7684\u6570\u5b57\uff0c\u6700\u591a\u652f\u6301\u4e24\u4f4d\u5c0f\u6570");
                }
            } else if (adxPrice <= 0.0 || adxPrice > 0.3) {
                return ResultModelFactory.FAIL400((String)"adx\u51fa\u4ef7\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u4e0d\u5927\u4e8e0.3\u7684\u6570\u5b57\uff0c\u6700\u591a\u652f\u6301\u4e24\u4f4d\u5c0f\u6570");
            }
        }
        return null;
    }

    private ResultModel validateCouponsArgs(AdTicketDto adTicketDto) {
        if (StringUtils.isBlank((CharSequence)adTicketDto.getAssetscouponsids())) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u7d20\u6750\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AdTicketDto.CouponsInfoDto couponsInfoDto = adTicketDto.getCouponsInfoDto();
        if (couponsInfoDto == null) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (couponsInfoDto.getUseType() == null) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u4f7f\u7528\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)couponsInfoDto.getContent())) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u793c\u5305\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)couponsInfoDto.getIntro())) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u793c\u5305\u5151\u6362\u65b9\u5f0f\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)couponsInfoDto.getPackageName())) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u4e0b\u8f7d\u5b89\u88c5\u5305\u7684AppID/\u5305\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        AdTicketCouponsInfo.AdCouponsUseType adCouponsUseType = AdTicketCouponsInfo.AdCouponsUseType.getByType((Short)couponsInfoDto.getUseType());
        if (adCouponsUseType == null) {
            return ResultModelFactory.FAIL400((String)"\u7968\u5238\u4f7f\u7528\u7c7b\u578b\u975e\u6cd5\uff01");
        }
        switch (adCouponsUseType) {
            case USETYPE_SINGLE: {
                break;
            }
            case USETYPE_MULTIPLE: {
                break;
            }
            case USETYPE_LIMITED_TIME: {
                if (StringUtils.isBlank((CharSequence)couponsInfoDto.getCode())) {
                    return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (couponsInfoDto.getCodeStartTime() == null || couponsInfoDto.getCodeEndTime() == null) {
                    return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u5f00\u59cb\u4f7f\u7528\u65f6\u95f4\u548c\u7ed3\u675f\u4f7f\u7528\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (couponsInfoDto.getCodeStartTime().getTime() < couponsInfoDto.getCodeEndTime().getTime()) break;
                return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u5f00\u59cb\u4f7f\u7528\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u4f7f\u7528\u65f6\u95f4\uff01");
            }
            case USETYPE_LIMITED_NUM: {
                if (StringUtils.isBlank((CharSequence)couponsInfoDto.getCode())) {
                    return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (couponsInfoDto.getCodeLimitNum() != null && couponsInfoDto.getCodeLimitNum() >= 1) break;
                return ResultModelFactory.FAIL400((String)"\u7968\u5238\u7801\u7968\u5238\u9650\u5236\u4f7f\u7528\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e0\uff01");
            }
            default: {
                return ResultModelFactory.FAIL400((String)"\u672a\u5904\u7406\u7684\u7968\u5238\u4f7f\u7528\u7c7b\u578b\uff01");
            }
        }
        AdTicketDto.ControlDto controlDto = adTicketDto.getControlDto();
        List appEntranceAdRos = null;
        if (StringUtil.isBlank((CharSequence)controlDto.getBanners())) {
            QueryAppEntranceParamDTO paramDTO = new QueryAppEntranceParamDTO();
            Byte couponsPutinFlag = 1;
            paramDTO.setCouponsPutinFlag(couponsPutinFlag);
            appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
        } else {
            QueryAppEntranceParamDTO paramDTO;
            String[] bannersArray = controlDto.getBanners().split(",");
            if (bannersArray.length > 0) {
                bannersArray[0] = bannersArray[0].substring(bannersArray[0].indexOf("-") + 1);
            }
            List<String> positionIds = Arrays.asList(bannersArray);
            if (controlDto.getBanners().startsWith("1")) {
                paramDTO = new QueryAppEntranceParamDTO();
                paramDTO.setPositionIds(positionIds);
                appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
            } else if (controlDto.getBanners().startsWith("2")) {
                paramDTO = new QueryAppEntranceParamDTO();
                paramDTO.setPositionIds((List)positionIds);
                List appEntranceAdRosTemp = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
                paramDTO = new QueryAppEntranceParamDTO();
                paramDTO.setNotInIds(appEntranceAdRosTemp.stream().map(AppEntranceAdRO::getId).collect(Collectors.toList()));
                appEntranceAdRos = this.newAppEntranceFacadeIntegration.getAllList(paramDTO);
            } else {
                return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4d\u5b9a\u5411\u914d\u7f6e\u975e\u6cd5\uff01");
            }
        }
        if (CollectionUtils.isEmpty((Collection)appEntranceAdRos)) {
            return ResultModelFactory.FAIL400((String)"\u6ca1\u6709\u627e\u5230\u5f00\u542f\u5238\u7801\u6295\u653e\u7684\u5e7f\u544a\u4f4d\uff01");
        }
        HashSet<Long> appEntranceCouponsSizeIds = new HashSet<Long>();
        for (AppEntranceAdRO appEntranceAdRo : appEntranceAdRos) {
            appEntranceCouponsSizeIds.add(appEntranceAdRo.getCouponsIconSize());
            appEntranceCouponsSizeIds.add(appEntranceAdRo.getCouponsCreativeSize());
        }
        List assetsCoupons = this.adTicketAssetsCouponsService.findByIds(adTicketDto.getAssetscouponsids());
        ArrayList<Long> assetsCouponsSizeIds = new ArrayList<Long>();
        for (AdAssetsCoupons assetsCoupon : assetsCoupons) {
            if (assetsCoupon.getStatus() != 1) continue;
            assetsCouponsSizeIds.add(assetsCoupon.getPositionAssetSizeId());
        }
        if (assetsCouponsSizeIds.containsAll(appEntranceCouponsSizeIds) == Boolean.FALSE.booleanValue()) {
            return ResultModelFactory.FAIL400((String)"\u5238\u7801\u6295\u653e\u7684\u5e7f\u544a\u4f4d\u7d20\u6750\u5c3a\u5bf8\u5fc5\u987b\u5168\u90e8\u6dfb\u52a0\u5bf9\u5e94\u7684\u7d20\u6750\uff01");
        }
        return null;
    }

    private void addTicketModifyLogs(User user, AdTicketDto adTicketDto) {
        try {
            String logStr;
            AdTicketDto.OcpcConfDto ocpcConf;
            String priceStr;
            String oldPriceStr;
            StringBuffer log = new StringBuffer();
            Double oldPrice = adTicketDto.getOldPrice();
            Double price = adTicketDto.getPrice();
            if (oldPrice != null && price != null && !(oldPriceStr = String.valueOf(oldPrice)).equals(priceStr = String.valueOf(price))) {
                log.append("\u51fa\u4ef7\u4ece").append(oldPriceStr).append("\u8c03\u6574\u4e3a").append(priceStr).append(";");
            }
            if (null != (ocpcConf = adTicketDto.getOcpcConf())) {
                String oldCpaPriceStr;
                String cpaExpectPriceStr;
                Double cpaExpectPrice = ocpcConf.getCpaExpectPrice();
                Double oldCpaPrice = ocpcConf.getOldCpaPrice();
                if (cpaExpectPrice != null && oldCpaPrice != null && !(cpaExpectPriceStr = String.valueOf(cpaExpectPrice)).equals(oldCpaPriceStr = String.valueOf(oldCpaPrice))) {
                    log.append("\u9884\u671fcpa\u4ece").append(oldCpaPriceStr).append("\u8c03\u6574\u4e3a").append(cpaExpectPriceStr).append(";");
                }
            }
            if (StringUtil.isNotEmpty((CharSequence)adTicketDto.getFlowPackageArray())) {
                List packages = null;
                packages = JSON.parseArray((String)adTicketDto.getFlowPackageArray(), AdFlowPackageNewDto.class);
                if (CollectionUtils.isNotEmpty((Collection)packages)) {
                    for (AdFlowPackageNewDto record : packages) {
                        String oldPackagePrice = record.getOldPrice();
                        String newPackagePrice = record.getPrice();
                        if (!StringUtils.isNotBlank((CharSequence)oldPackagePrice) || !StringUtils.isNotBlank((CharSequence)newPackagePrice) || oldPackagePrice.equals(newPackagePrice)) continue;
                        log.append("\u6d41\u91cf\u5305\uff1a").append(record.getPackageName()).append("\u51fa\u4ef7\u4ece").append(oldPackagePrice).append("\u8c03\u6574\u4e3a").append(newPackagePrice).append(";");
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(logStr = log.toString()))) {
                this.addNewLogs(user, "\u7f16\u8f91\uff1a" + logStr, String.valueOf(adTicketDto.getId()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u64cd\u4f5c\u65e5\u5fd7\u5165\u5e93\u51fa\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    private void addTicketModifyLogs(User user, AdTicketDto adTicketDto, AdTicket adTicket) throws Exception {
        String newAppIdPackage;
        String oldAppIdPackage;
        String newCrowdPackage;
        String oldCrowdPackage;
        String newPosition;
        String oldPosition;
        String newNetworkType;
        String oldNetworkType;
        String unit;
        String newTimesDesc;
        String oldTimesDesc;
        String oldTimes;
        String newTimes;
        boolean timesEqual;
        String newValidDate;
        String oldValidDate;
        boolean validDateEqual;
        String content;
        String rate;
        String noDeliveryRateDesc;
        String newFrequencys;
        String oldFrequencys;
        boolean frequencysEqual;
        String content2;
        String oldBdTagsOrientatio;
        String newBdTagsOrientatio;
        boolean bdTagsOrientatioEqual;
        String content3;
        String oldJumpUrl;
        String newJumpUrl;
        boolean jumpUrlEqual;
        List<Short> needAddLogTicketType = Arrays.asList(AdTicket.AdTicketType.TYPE_NORMALS.getType(), AdTicket.AdTicketType.TYPE_DIRECT.getType(), AdTicket.AdTicketType.TYPE_ACTIVITY.getType());
        if (!needAddLogTicketType.contains(adTicket.getType())) {
            return;
        }
        boolean isNewAdx = AdTicket.AdTicketType.isNewAdx((Short)adTicket.getType());
        AdTicketVo adTicketVo = this.adTicketService.findById(adTicket.getId());
        int compare = NumberUtils.compare((short)adTicketDto.getTicketAppExtendDto().getPageType(), (short)adTicketVo.getTicketAppExtendVo().getPageType());
        boolean urlEqual = StringUtils.equals((CharSequence)adTicketDto.getUrl(), (CharSequence)adTicket.getUrl());
        if (compare != 0 || !urlEqual) {
            PageTypeEnum newType = PageTypeEnum.getByType((short)adTicketDto.getTicketAppExtendDto().getPageType());
            PageTypeEnum oldType = PageTypeEnum.getByType((short)adTicketVo.getTicketAppExtendVo().getPageType());
            this.addLogs(user, "\u843d\u5730\u9875\u4ece" + oldType.getDesc() + adTicket.getUrl() + "\u4fee\u6539\u6210 " + newType.getDesc() + adTicketDto.getUrl(), adTicket.getId().toString());
        }
        if (!(jumpUrlEqual = StringUtils.equals((CharSequence)(newJumpUrl = adTicketDto.getTicketAppExtendDto().getJumpUrl()), (CharSequence)(oldJumpUrl = adTicketVo.getTicketAppExtendVo().getJumpUrl())))) {
            content3 = null;
            content3 = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{newJumpUrl, oldJumpUrl}) ? "Deeplink\u4ece" + oldJumpUrl + "\u4fee\u6539\u6210" + newJumpUrl : (StringUtils.isBlank((CharSequence)oldJumpUrl) ? "Deeplink\u4ece\u65e0\u4fee\u6539\u6210" + newJumpUrl : "Deeplink\u4ece" + oldJumpUrl + "\u4fee\u6539\u6210\u65e0");
            this.addLogs(user, content3, adTicket.getId().toString());
        }
        if (isNewAdx) {
            BigDecimal data2;
            Short newAdxPriceType = adTicketDto.getTicketAppExtendDto().getAdxPriceType();
            Short oldAdxPriceType = adTicketVo.getTicketAppExtendVo().getAdxPriceType();
            Double newAdxPrice = adTicketDto.getTicketAppExtendDto().getAdxPrice();
            Double oldAdxPrice = adTicketVo.getTicketAppExtendVo().getAdxPrice();
            int adxPriceTypeCompare = NumberUtils.compare((short)newAdxPriceType, (short)oldAdxPriceType);
            BigDecimal data1 = new BigDecimal(newAdxPrice.toString());
            if (data1.compareTo(data2 = new BigDecimal(oldAdxPrice.toString())) != 0 || adxPriceTypeCompare != 0) {
                AdxPriceTypeEnum newAdxPriceTypeEnum = AdxPriceTypeEnum.getByType((short)newAdxPriceType);
                AdxPriceTypeEnum oldAdxPriceTypeEnum = AdxPriceTypeEnum.getByType((short)oldAdxPriceType);
                this.addLogs(user, "ADX\u51fa\u4ef7\u4ece" + oldAdxPriceTypeEnum.getDesc() + oldAdxPrice + "\u5143\u4fee\u6539\u6210" + newAdxPriceTypeEnum.getDesc() + newAdxPrice + "\u5143", adTicket.getId().toString());
            }
        }
        if (isNewAdx && !(bdTagsOrientatioEqual = StringUtils.equals((CharSequence)(newBdTagsOrientatio = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getTicketAppExtendDto().getBdTagsOrientation(), (CharSequence)"")), (CharSequence)(oldBdTagsOrientatio = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getTicketAppExtendVo().getBdTagsOrientation(), (CharSequence)""))))) {
            String[] newBdTagsOrientatioArray = newBdTagsOrientatio.split("&");
            String[] oldBdTagsOrientatioArray = oldBdTagsOrientatio.split("&");
            String newWhitelistTag = "";
            String newBlacklistTag = "";
            String oldWhitelistTag = "";
            String oldBlacklistTag = "";
            if (newBdTagsOrientatioArray.length == 1) {
                newWhitelistTag = newBdTagsOrientatioArray[0];
            } else if (newBdTagsOrientatioArray.length == 2) {
                newWhitelistTag = newBdTagsOrientatioArray[0];
                newBlacklistTag = newBdTagsOrientatioArray[1];
            }
            if (oldBdTagsOrientatioArray.length == 1) {
                oldWhitelistTag = oldBdTagsOrientatioArray[0];
            } else if (oldBdTagsOrientatioArray.length == 2) {
                oldWhitelistTag = oldBdTagsOrientatioArray[0];
                oldBlacklistTag = oldBdTagsOrientatioArray[1];
            }
            if (!newWhitelistTag.equals(oldBlacklistTag)) {
                content2 = String.format("\u767e\u5ea6\u6807\u7b7e\u4ece\u767d\u540d\u5355\uff1a%s\u9ed1\u540d\u5355\uff1a%s\u4fee\u6539\u6210\u767d\u540d\u5355\uff1a%s\u9ed1\u540d\u5355\uff1a%s", oldWhitelistTag, oldBlacklistTag, newWhitelistTag, newBlacklistTag);
                this.addLogs(user, content2, adTicket.getId().toString());
            }
        }
        Integer oldRta = adTicketVo.getTicketAppExtendVo().getRta();
        Integer newRta = adTicketDto.getTicketAppExtendDto().getRta();
        String oldRtaParam = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getTicketAppExtendVo().getRtaParam(), (CharSequence)"");
        String newRtaParam = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getTicketAppExtendDto().getRtaParam(), (CharSequence)"");
        if (!Objects.equals(newRta, oldRta) || !oldRtaParam.equals(newRtaParam)) {
            String oldRtaStr = "";
            String newRtaStr = "";
            if (oldRta == null) {
                oldRtaStr = "\u5426";
                oldRtaParam = "";
            } else {
                oldRtaStr = String.valueOf(oldRta);
                oldRtaParam = " RTA\u5e7f\u544aID" + oldRtaParam;
            }
            if (newRta == null) {
                newRtaStr = "\u5426";
                newRtaParam = "";
            } else {
                newRtaStr = String.valueOf(newRta);
                newRtaParam = " RTA\u5e7f\u544aID" + newRtaParam;
            }
            String content4 = "RTA\u5b9a\u5411\u4ece" + oldRtaStr + oldRtaParam + "\u4fee\u6539\u6210RTA\u5b9a\u5411" + newRtaStr + newRtaParam;
            this.addLogs(user, content4, adTicket.getId().toString());
        }
        if (!(frequencysEqual = StringUtils.equals((CharSequence)(oldFrequencys = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getFrequencys(), (CharSequence)"")), (CharSequence)(newFrequencys = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getFrequencys(), (CharSequence)""))))) {
            String oldFrequencysDesc = "";
            String newFrequencysDesc = "";
            oldFrequencysDesc = StringUtils.isBlank((CharSequence)oldFrequencys) ? "\u4e0d\u9650" : this.getFrequencysDesc(oldFrequencys);
            if (!oldFrequencysDesc.equals(newFrequencysDesc = StringUtils.isBlank((CharSequence)newFrequencys) ? "\u4e0d\u9650" : this.getFrequencysDesc(newFrequencys))) {
                String content5 = String.format("\u9891\u6b21\u63a7\u5236\u4ece%s\u4fee\u6539\u6210%s", oldFrequencysDesc, newFrequencysDesc);
                this.addLogs(user, content5, adTicket.getId().toString());
            }
        }
        String oldAppPackageRule = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getTicketAppExtendVo().getAppPackageRule(), (CharSequence)"");
        String newAppPackageRule = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getAppPackageRule(), (CharSequence)"");
        Integer oldAppPackageRate = adTicketVo.getTicketAppExtendVo().getAppPackageRate();
        Integer newAppPackageRate = adTicketDto.getTicketAppExtendDto().getAppPackageRate();
        boolean appPackageRuleEqual = StringUtils.equals((CharSequence)oldAppPackageRule, (CharSequence)newAppPackageRule);
        if (!appPackageRuleEqual || !Objects.equals(oldAppPackageRate, newAppPackageRate)) {
            String oldAppPackageRuleDesc = "";
            String newAppPackageRuleDesc = "";
            noDeliveryRateDesc = "\u672a\u83b7\u53d6\u5230App\u5217\u8868\u65f6\u6295\u653e\u914d\u7387";
            if (StringUtils.isBlank((CharSequence)oldAppPackageRule)) {
                oldAppPackageRuleDesc = "\u4e0d\u9650";
            } else {
                rate = oldAppPackageRate == null ? "" : String.valueOf(oldAppPackageRate);
                oldAppPackageRuleDesc = this.getAppPackageRuleDesc(oldAppPackageRule, noDeliveryRateDesc, rate);
            }
            if (StringUtils.isBlank((CharSequence)newAppPackageRule)) {
                newAppPackageRuleDesc = "\u4e0d\u9650";
            } else {
                rate = newAppPackageRate == null ? "" : String.valueOf(newAppPackageRate);
                newAppPackageRuleDesc = this.getAppPackageRuleDesc(newAppPackageRule, noDeliveryRateDesc, rate);
            }
            if (!oldAppPackageRuleDesc.equals(newAppPackageRuleDesc)) {
                content = String.format("\u5df2\u5b89\u88c5APP\u5305\u540d\u5b9a\u5411\u4ece%s\u4fee\u6539\u6210%s", oldAppPackageRuleDesc, newAppPackageRuleDesc);
                this.addLogs(user, content, adTicket.getId().toString());
            }
        }
        if (isNewAdx) {
            String oldMediaAppPackageRule = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getTicketAppExtendVo().getMediaAppPackageRule(), (CharSequence)"");
            String newMediaAppPackageRule = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getTicketAppExtendDto().getMediaAppPackageRule(), (CharSequence)"");
            Integer oldMediaAppPackageRate = adTicketVo.getTicketAppExtendVo().getMediaAppPackageRate();
            Integer newMediaAppPackageRate = adTicketDto.getTicketAppExtendDto().getMediaAppPackageRate();
            boolean mediaAppPackageRuleEqual = StringUtils.equals((CharSequence)oldMediaAppPackageRule, (CharSequence)newMediaAppPackageRule);
            if (!mediaAppPackageRuleEqual || !Objects.equals(oldMediaAppPackageRate, newMediaAppPackageRate)) {
                String oldMediaAppPackageRuleDesc = "";
                String newMediaAppPackageRuleDesc = "";
                noDeliveryRateDesc = "\u672a\u83b7\u53d6\u5230App\u5217\u8868\u65f6\u6295\u653e\u914d\u7387";
                if (StringUtils.isBlank((CharSequence)oldMediaAppPackageRule)) {
                    oldMediaAppPackageRuleDesc = "\u4e0d\u9650";
                } else {
                    rate = oldMediaAppPackageRate == null ? "" : String.valueOf(oldMediaAppPackageRate);
                    oldMediaAppPackageRuleDesc = this.getAppPackageRuleDesc(oldMediaAppPackageRule, noDeliveryRateDesc, rate);
                }
                if (StringUtils.isBlank((CharSequence)newMediaAppPackageRule)) {
                    newMediaAppPackageRuleDesc = "\u4e0d\u9650";
                } else {
                    rate = newMediaAppPackageRate == null ? "" : String.valueOf(newMediaAppPackageRate);
                    newMediaAppPackageRuleDesc = this.getAppPackageRuleDesc(newMediaAppPackageRule, noDeliveryRateDesc, rate);
                }
                if (!oldMediaAppPackageRuleDesc.equals(newMediaAppPackageRuleDesc)) {
                    content = String.format("\u5a92\u4f53app\u5305\u540d\u5b9a\u5411\u4ece%s\u4fee\u6539\u6210%s", oldMediaAppPackageRuleDesc, newMediaAppPackageRuleDesc);
                    this.addLogs(user, content, adTicket.getId().toString());
                }
            }
        }
        if (isNewAdx) {
            String oldAdxAppIdRule = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getAdxAppIdRule(), (CharSequence)"");
            String newAdxAppIdRule = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getAdxAppIdRule(), (CharSequence)"");
            Integer oldAdxAppIdRate = adTicketVo.getTicketAppExtendVo().getAdxAppIdRate();
            Integer newAdxAppIdRate = adTicketDto.getTicketAppExtendDto().getAdxAppIdRate();
            boolean adxAppIdRuleEqual = StringUtils.equals((CharSequence)oldAdxAppIdRule, (CharSequence)newAdxAppIdRule);
            if (!adxAppIdRuleEqual || !Objects.equals(oldAdxAppIdRate, newAdxAppIdRate)) {
                String oldAdxAppIdRuleDesc = "";
                String newAdxAppIdRuleDesc = "";
                noDeliveryRateDesc = "\u65e0 App ID \u6295\u653e\u914d\u7387";
                if (StringUtils.isBlank((CharSequence)oldAdxAppIdRule)) {
                    oldAdxAppIdRuleDesc = "\u4e0d\u9650";
                } else {
                    rate = oldAdxAppIdRate == null ? "" : String.valueOf(oldAdxAppIdRate);
                    oldAdxAppIdRuleDesc = this.getAppPackageRuleDesc(oldAdxAppIdRule, noDeliveryRateDesc, rate);
                }
                if (StringUtils.isBlank((CharSequence)newAdxAppIdRule)) {
                    newAdxAppIdRuleDesc = "\u4e0d\u9650";
                } else {
                    rate = newAdxAppIdRate == null ? "" : String.valueOf(newAdxAppIdRate);
                    newAdxAppIdRuleDesc = this.getAppPackageRuleDesc(newAdxAppIdRule, noDeliveryRateDesc, String.valueOf(adTicketDto.getTicketAppExtendDto().getAdxAppIdRate()));
                }
                if (!oldAdxAppIdRuleDesc.equals(newAdxAppIdRuleDesc)) {
                    content = String.format("ADX App ID \u5b9a\u5411\u4ece%s\u4fee\u6539\u6210%s", oldAdxAppIdRuleDesc, newAdxAppIdRuleDesc);
                    this.addLogs(user, content, adTicket.getId().toString());
                }
            }
        }
        if (!(validDateEqual = StringUtils.equals((CharSequence)(oldValidDate = DateUtil.dateTo8String((Date)adTicketVo.getValidStartDate()) + "-" + DateUtil.dateTo8String((Date)adTicketVo.getValidEndDate())), (CharSequence)(newValidDate = DateUtil.dateTo8String((Date)adTicketDto.getValidStartDate()) + "-" + DateUtil.dateTo8String((Date)adTicketDto.getValidEndDate()))))) {
            content3 = String.format("\u6295\u653e\u65e5\u671f\u4ece%s\u4fee\u6539\u6210%s", oldValidDate, newValidDate);
            this.addLogs(user, content3, adTicket.getId().toString());
        }
        if (!(timesEqual = StringUtils.equals((CharSequence)(newTimes = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getTimes(), (CharSequence)"")), (CharSequence)(oldTimes = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getTimes(), (CharSequence)""))))) {
            oldTimesDesc = "";
            newTimesDesc = "";
            unit = adTicket.getSettleType().intValue() == 2 ? "\u5f20" : "\u5143";
            oldTimesDesc = StringUtils.isBlank((CharSequence)oldTimes) ? "\u5168\u90e8\u65f6\u6bb5" : AdTicketController.getTimesDesc(oldTimes, unit);
            if (!oldTimesDesc.equals(newTimesDesc = StringUtils.isBlank((CharSequence)newTimes) ? "\u5168\u90e8\u65f6\u6bb5" : AdTicketController.getTimesDesc(newTimes, unit))) {
                content2 = String.format("\u6295\u653e\u65f6\u6bb5\u9884\u7b97\u4ece%s\u4fee\u6539\u6210%s", oldTimesDesc, newTimesDesc);
                this.addLogs(user, content2, adTicket.getId().toString());
            }
        }
        Long oldGroupId = adTicketVo.getGroupId();
        Long newGroupId = adTicketDto.getGroupId();
        if (!Objects.equals(newGroupId, oldGroupId)) {
            String oldStr = oldGroupId == null ? "\u5426" : String.valueOf(oldGroupId);
            String newStr = newGroupId == null ? "\u5426" : String.valueOf(newGroupId);
            this.addLogs(user, "\u7ed1\u5b9a\u5e7f\u544a\u7ec4\u4ece" + oldStr + "\u4fee\u6539\u6210" + newStr, adTicket.getId().toString());
        }
        if (isNewAdx) {
            String oldPhoneBrand = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getPhoneBrand(), (CharSequence)"");
            String newPhoneBrand = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getPhoneBrand(), (CharSequence)"");
            String oldPhoneBrandDesc = "";
            String newPhoneBrandDesc = "";
            if (!Objects.equals(oldPhoneBrand, newPhoneBrand)) {
                String[] oldPhoneBrandArray = oldPhoneBrand.split("-");
                String[] newPhoneBrandArray = newPhoneBrand.split("-");
                Set oldBrandSet = Collections.EMPTY_SET;
                Set newBrandSet = Collections.EMPTY_SET;
                if (oldPhoneBrandArray.length == 1) {
                    oldBrandSet = Sets.newHashSet((Object[])new String[]{oldPhoneBrandArray[0]});
                    oldPhoneBrandDesc = "\u4e0d\u9650";
                } else if (oldPhoneBrandArray.length == 2) {
                    oldPhoneBrandDesc = CommonConstant.PhoneBrandType.getNamesByTypes((String)oldPhoneBrandArray[1]);
                    oldBrandSet = Sets.newHashSet((Object[])oldPhoneBrandArray[1].split(","));
                }
                if (newPhoneBrandArray.length == 1) {
                    newPhoneBrandDesc = "\u4e0d\u9650";
                    newBrandSet = Sets.newHashSet((Object[])new String[]{newPhoneBrandArray[0]});
                } else if (newPhoneBrandArray.length == 2) {
                    newPhoneBrandDesc = CommonConstant.PhoneBrandType.getNamesByTypes((String)newPhoneBrandArray[1]);
                    String newBrand = newPhoneBrandArray[1];
                    newBrandSet = Sets.newHashSet((Object[])newBrand.split(","));
                }
                if (!SetUtils.isEqualSet((Collection)oldBrandSet, (Collection)newBrandSet)) {
                    this.addLogs(user, "\u624b\u673a\u54c1\u724c\u4ece" + oldPhoneBrandDesc + "\u4fee\u6539\u6210" + newPhoneBrandDesc, adTicket.getId().toString());
                }
            }
        }
        if (!Objects.equals(oldNetworkType = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getNetworkType(), (CharSequence)""), newNetworkType = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getNetworkType(), (CharSequence)""))) {
            String[] oldNetworkArray = oldNetworkType.split("-");
            String[] newNetworkArray = newNetworkType.split("-");
            String oldNetworkDesc = "";
            String newNetworkDesc = "";
            if (oldNetworkArray.length == 1) {
                oldNetworkDesc = "\u4e0d\u9650";
            } else if (oldNetworkArray.length == 2) {
                oldNetworkDesc = CommonConstant.NetworkType.getNamesByTypes((String)oldNetworkArray[1]);
            }
            if (newNetworkArray.length == 1) {
                newNetworkDesc = "\u4e0d\u9650";
            } else if (newNetworkArray.length == 2) {
                newNetworkDesc = CommonConstant.NetworkType.getNamesByTypes((String)newNetworkArray[1]);
            }
            if (!Objects.equals(oldNetworkDesc, newNetworkDesc)) {
                this.addLogs(user, "\u7f51\u7edc\u7c7b\u578b\u4ece" + oldNetworkDesc + "\u6539\u4e3a" + newNetworkDesc, adTicket.getId().toString());
            }
        }
        if (!Objects.equals(oldPosition = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getBanners(), (CharSequence)""), newPosition = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getBanners(), (CharSequence)""))) {
            String[] oldPositionArray = oldPosition.split("-");
            String[] newPositionArray = newPosition.split("-");
            String oldPositionDesc = "";
            String newPositionDesc = "";
            if (oldPositionArray.length == 1) {
                oldPositionDesc = "\u4e0d\u9650";
            } else if (oldPositionArray.length > 1) {
                oldPositionDesc = StringUtils.replace((String)oldPosition, (String)"1-", (String)"");
            }
            if (newPositionArray.length == 1) {
                newPositionDesc = "\u4e0d\u9650";
            } else if (newPositionArray.length > 1) {
                newPositionDesc = StringUtils.replace((String)newPosition, (String)"1-", (String)"");
            }
            if (!Objects.equals(oldPositionDesc, newPositionDesc)) {
                this.addLogs(user, "\u5e7f\u544a\u4f4d\u5b9a\u5411\u4ece " + oldPositionDesc + "\r\n\u4fee\u6539\u6210\r\n" + newPositionDesc, adTicket.getId().toString());
            }
        }
        if (!Objects.equals(oldCrowdPackage = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getTicketAppExtendVo().getCrowdPackageOrientation(), (CharSequence)""), newCrowdPackage = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getTicketAppExtendDto().getCrowdPackageOrientation(), (CharSequence)""))) {
            String[] oldCrowdPackageArray = oldCrowdPackage.split("&");
            String[] newCrowdPackageArray = newCrowdPackage.split("&");
            String oldWhiteCrowdPackageDesc = "";
            String oldBlackCrowdPackageDesc = "";
            String newWhiteCrowdPackageDesc = "";
            String newBlackCrowdPackageDesc = "";
            if (oldCrowdPackageArray.length == 2) {
                oldWhiteCrowdPackageDesc = oldCrowdPackageArray[0];
                oldBlackCrowdPackageDesc = oldCrowdPackageArray[1];
            }
            if (newCrowdPackageArray.length == 2) {
                newWhiteCrowdPackageDesc = newCrowdPackageArray[0];
                newBlackCrowdPackageDesc = newCrowdPackageArray[1];
            }
            if (!Objects.equals(oldBlackCrowdPackageDesc, newBlackCrowdPackageDesc) || !Objects.equals(oldWhiteCrowdPackageDesc, newWhiteCrowdPackageDesc)) {
                this.addLogs(user, "\u4eba\u7fa4\u5305\u5b9a\u5411\u4ece\u767d\u540d\u5355\uff1a" + oldWhiteCrowdPackageDesc + " \u9ed1\u540d\u5355\uff1a" + oldBlackCrowdPackageDesc + " \u4fee\u6539\u6210\u767d\u540d\u5355\uff1a" + newWhiteCrowdPackageDesc + " \u9ed1\u540d\u5355\uff1a" + newBlackCrowdPackageDesc, adTicket.getId().toString());
            }
        }
        if (isNewAdx && !Objects.equals(oldAppIdPackage = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getAppIdPackage(), (CharSequence)""), newAppIdPackage = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getAppIdPackage(), (CharSequence)""))) {
            String[] oldAppIdPackageArray = oldAppIdPackage.split("-");
            String[] newAppIdPackageArray = newAppIdPackage.split("-");
            String oldAppIdPackageDesc = "";
            String newAppIdPackageDesc = "";
            String oldBlackOrWhiteDesc = "";
            String newBlackOrWhiteDesc = "";
            if (oldAppIdPackageArray.length == 1) {
                oldAppIdPackageDesc = "\u4e0d\u9650";
            } else if (oldAppIdPackageArray.length == 2) {
                oldBlackOrWhiteDesc = "1".equals(oldAppIdPackageArray[0]) ? "\u767d\u540d\u5355" : "\u9ed1\u540d\u5355";
                oldAppIdPackageDesc = oldAppIdPackageArray[1];
            }
            if (newAppIdPackageArray.length == 1) {
                newAppIdPackageDesc = "\u4e0d\u9650";
            } else if (newAppIdPackageArray.length == 2) {
                newBlackOrWhiteDesc = "1".equals(newAppIdPackageArray[0]) ? "\u767d\u540d\u5355" : "\u9ed1\u540d\u5355";
                newAppIdPackageDesc = newAppIdPackageArray[1];
            }
            this.addLogs(user, "ADX AppID\u5305\u5b9a\u5411\u4ece" + oldBlackOrWhiteDesc + oldAppIdPackageDesc + " \u4fee\u6539\u6210 " + newBlackOrWhiteDesc + newAppIdPackageDesc, adTicket.getId().toString());
        }
        if (!(timesEqual = StringUtils.equals((CharSequence)(newTimes = (String)StringUtils.defaultIfBlank((CharSequence)adTicketDto.getControlDto().getTimeBidding(), (CharSequence)"")), (CharSequence)(oldTimes = (String)StringUtils.defaultIfBlank((CharSequence)adTicketVo.getControlVo().getTimeBidding(), (CharSequence)""))))) {
            oldTimesDesc = "";
            newTimesDesc = "";
            unit = adTicket.getSettleType().intValue() == 2 ? "\u5f20" : "\u5143";
            oldTimesDesc = StringUtils.isBlank((CharSequence)oldTimes) ? "\u5168\u90e8\u65f6\u6bb5" : AdTicketController.getTimesBiddingDesc(oldTimes, unit);
            if (!oldTimesDesc.equals(newTimesDesc = StringUtils.isBlank((CharSequence)newTimes) ? "\u5168\u90e8\u65f6\u6bb5" : AdTicketController.getTimesBiddingDesc(newTimes, unit))) {
                content2 = String.format("ADX\u6295\u653e\u65f6\u6bb5\u4ece%s\u4fee\u6539\u6210 %s", oldTimesDesc, newTimesDesc);
                this.addLogs(user, content2, adTicket.getId().toString());
            }
        }
    }

    public static void test() {
        String newTimes = "";
        String oldTimes = "4-6-0-1.0,1-3-0-2";
        boolean timesEqual = StringUtils.equals((CharSequence)newTimes, (CharSequence)oldTimes);
        if (!timesEqual) {
            String oldTimesDesc = "";
            String newTimesDesc = "";
            String unit = "\u5143";
            oldTimesDesc = StringUtils.isBlank((CharSequence)oldTimes) ? "\u5168\u90e8\u65f6\u6bb5" : AdTicketController.getTimesBiddingDesc(oldTimes, unit);
            if (!oldTimesDesc.equals(newTimesDesc = StringUtils.isBlank((CharSequence)newTimes) ? "\u5168\u90e8\u65f6\u6bb5" : AdTicketController.getTimesBiddingDesc(newTimes, unit))) {
                String content = String.format("ADX\u6295\u653e\u65f6\u6bb5\u4ece%s\u4fee\u6539\u6210%s", oldTimesDesc, newTimesDesc);
                System.out.println(content);
            }
        }
    }

    public static void main(String[] args) {
        AdTicketController.test();
    }

    private static String getTimesDesc(String times, String unit) {
        StringBuffer desc = new StringBuffer();
        String[] timesConfigArray = times.split(",");
        for (int i = 0; i < timesConfigArray.length; ++i) {
            String[] signConfig = timesConfigArray[i].split("-");
            desc.append(signConfig[2] + unit + signConfig[0]).append(":00\uff5e").append(signConfig[1]).append(":00\uff5e").append(" ");
        }
        if (desc.length() > 0) {
            desc.deleteCharAt(desc.length() - 2);
        }
        return desc.toString();
    }

    private static String getTimesBiddingDesc(String times, String unit) {
        StringBuffer desc = new StringBuffer();
        String[] timesConfigArray = times.split(",");
        for (int i = 0; i < timesConfigArray.length; ++i) {
            String[] signConfig = timesConfigArray[i].split("-");
            desc.append("\u9884\u7b97:" + signConfig[2] + unit + " \u51fa\u4ef7:" + signConfig[3] + " " + signConfig[0]).append(":00\uff5e").append(signConfig[1]).append(":00\uff5e").append(" ");
        }
        if (desc.length() > 0) {
            desc.deleteCharAt(desc.length() - 2);
        }
        return desc.toString();
    }

    private String getAppPackageRuleDesc(String appPackageRule, String noDeliveryRateDesc, String rate) {
        StringBuffer frequencysDesc = new StringBuffer();
        String[] frequencysConfigArray = appPackageRule.split("-");
        if (appPackageRule.startsWith("1")) {
            frequencysDesc.append("\u767d\u540d\u5355");
        } else if (appPackageRule.startsWith("2")) {
            frequencysDesc.append("\u9ed1\u540d\u5355");
        }
        frequencysDesc.append(frequencysConfigArray[1]).append(noDeliveryRateDesc).append(rate).append("%");
        return frequencysDesc.toString();
    }

    private String getFrequencysDesc(String frequencys) {
        StringBuffer frequencysDesc = new StringBuffer();
        String[] frequencysConfigArray = frequencys.split(",");
        block16: for (int i = 0; i < frequencysConfigArray.length; ++i) {
            String[] frequencysSignConfig = frequencysConfigArray[i].split("-");
            switch (frequencysSignConfig[1]) {
                case "1": {
                    frequencysDesc.append("\u6bcf\u4eba\u6bcf" + frequencysSignConfig[0] + "\u5929\u66dd\u5149\u4e0d\u8d85\u8fc7" + frequencysSignConfig[2]).append("\u6b21,");
                    continue block16;
                }
                case "2": {
                    frequencysDesc.append("\u6bcf\u4eba\u6bcf" + frequencysSignConfig[0] + "\u5929\u70b9\u51fb\u4e0d\u8d85\u8fc7" + frequencysSignConfig[2]).append("\u6b21,");
                    continue block16;
                }
                case "3": {
                    frequencysDesc.append("\u6bcf\u4eba\u6bcf" + frequencysSignConfig[0] + "\u5929\u8bf7\u6c42\u4e0d\u8d85\u8fc7" + frequencysSignConfig[2]).append("\u6b21,");
                    continue block16;
                }
                case "4": {
                    frequencysDesc.append("\u6bcf\u4eba\u6bcf" + frequencysSignConfig[0] + "\u5929\u5f00\u5c4f\u8bf7\u6c42\u4e0d\u8d85\u8fc7" + frequencysSignConfig[2]).append("\u6b21,");
                    continue block16;
                }
                case "5": {
                    frequencysDesc.append("\u6bcfIP\u6bcf" + frequencysSignConfig[0] + "\u5929IP\u66dd\u5149\u4e0d\u8d85\u8fc7" + frequencysSignConfig[2]).append("\u6b21,");
                    continue block16;
                }
                case "6": {
                    frequencysDesc.append("\u6bcfIP\u6bcf" + frequencysSignConfig[0] + "\u5929IP\u70b9\u51fb\u4e0d\u8d85\u8fc7" + frequencysSignConfig[2]).append("\u6b21,");
                }
            }
        }
        if (frequencysDesc.length() > 0) {
            frequencysDesc.deleteCharAt(frequencysDesc.length() - 1);
        }
        return frequencysDesc.toString();
    }

    private void afterHandle(Long ticketId) throws Exception {
        AdvertiserDto advertiserDto;
        AdTicket adTicket = this.adTicketService.find(ticketId);
        if (AdTicket.AdTicketType.isNotNewAdx((Short)adTicket.getType())) {
            return;
        }
        if ((-2 == adTicket.getStatus() || -3 == adTicket.getStatus()) && 1 == (advertiserDto = this.adShopIntegration.findAdShopMsg(adTicket.getAdvertiser().longValue())).getAssetAuditWhiteStatus()) {
            AdTicketCheckInfokDto adTicketCheckInfokDto = this.adTicketService.getTicketInfoAndAssetsModify(ticketId);
            Integer status = 1;
            String refuseReason = null;
            String tags = adTicketCheckInfokDto.getTags();
            String domainCode = adTicketCheckInfokDto.getDomainCode();
            Boolean bl = this.adTicketService.ticketCheck(ticketId, status, refuseReason, tags, domainCode, "SYSTEM_AUDIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogBefore(operType="/adTicket/update", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, AdTicketDto adTicketDto) {
        User user;
        AdTicket adTicket;
        block33: {
            block32: {
                List adTickets;
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                if (adTicketDto != null && adTicketDto.getId() != null) break block28;
                                ResultModel resultModel = ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
                                return resultModel;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)adTicketDto.getDomainCode()) || !"-1".equals(adTicketDto.getDomainCode())) break block29;
                            ResultModel resultModel = ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5206\u7c7b\u4e0d\u80fd\u4e3a\u9ed8\u8ba4");
                            return resultModel;
                        }
                        ResultModel resultModel = this.validateTicketConfig(adTicketDto, AdTicketDto.Update.class);
                        if (resultModel == null) break block30;
                        ResultModel resultModel2 = resultModel;
                        return resultModel2;
                    }
                    adTickets = this.adTicketService.findByIds(String.valueOf(adTicketDto.getId()));
                    if (!CollectionUtils.isEmpty((Collection)adTickets)) break block31;
                    ResultModel resultModel = ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5238\u4e0d\u5b58\u5728");
                    return resultModel;
                }
                adTicket = (AdTicket)adTickets.get(0);
                if (adTicketDto.getModifyTime() == null || "\u524d\u7aef\u7cfb\u7edf\u5224\u65ad".equals(adTicket.getModifyUser()) || !DateUtil.isAfter((Date)adTicketDto.getModifyTime(), (Date)adTicket.getModifyTime())) break block32;
                String msg = String.format("\u5e7f\u544a\u5238\u5df2\u7ecf\u88ab %s \u4fee\u6539\u4e86\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", adTicket.getModifyUser());
                ResultModel resultModel = ResultModelFactory.FAIL400((String)msg);
                return resultModel;
            }
            user = this.getUser(request, response);
            if (user.getRoleCodes().contains(RoleEnum.AELEADER.getCode()) || adTicket.getAe().equals(user.getUsername()) || !user.getRoleCodes().contains(RoleEnum.AE.getCode())) break block33;
            ResultModel resultModel = ResultModelFactory.FAIL400((String)"\u4f60\u6ca1\u6709\u4fee\u6539\u8be5\u5238\u7684\u6743\u9650");
            return resultModel;
        }
        try {
            if (adTicket.getStatus() != null && adTicket.getStatus() > 0 && (adTicket.getStatus() != 3 || adTicket.getLastStatus() > 0)) {
                adTicketDto.setLastStatus(adTicket.getStatus().shortValue());
                if (adTicket.getStatus() == 2) {
                    adTicketDto.setPauseReason(adTicket.getPauseReason());
                }
            }
            if (adTicket.getStatus() != null && adTicket.getStatus() == -2) {
                adTicketDto.setStatus(Short.valueOf((short)-2));
            }
            if (StringUtils.isNotBlank((CharSequence)adTicketDto.getUrl()) && !adTicket.getUrl().equals(adTicketDto.getUrl())) {
                this.addLogs(user, "\u5238\u843d\u5730\u9875\u4ece" + adTicket.getUrl() + "\u4fee\u6539\u6210 " + adTicketDto.getUrl(), adTicket.getId().toString());
            }
            if (AdTicket.AdTicketType.isNotAdx((Short)adTicketDto.getType())) {
                if (this.adTicketService.checkTagModify(adTicketDto.getId(), adTicketDto.getTags()).booleanValue() || this.adTicketService.checkTagNeedAudit(adTicketDto.getId()).booleanValue() && this.adTicketService.checkTicketAssets(adTicketDto, adTicket, user).booleanValue()) {
                    adTicketDto.setStatus(Short.valueOf((short)-2));
                    AdTicketUrlTest result = this.adTicketService.findTicketUrlTest(Long.valueOf(adTicketDto.getId().longValue()));
                    if (null == result) {
                        AdTicketUrlTest adTicketUrlTest = new AdTicketUrlTest();
                        adTicketUrlTest.setTicketId(Long.valueOf(adTicketDto.getId().longValue()));
                        adTicketUrlTest.setActionType(Short.valueOf((short)1));
                        adTicketUrlTest.setDealStatus(Short.valueOf((short)0));
                        adTicketUrlTest.setCreateTime(new Date());
                        adTicketUrlTest.setModifyTime(new Date());
                        this.adTicketService.addTicketUrlTest(adTicketUrlTest);
                    } else {
                        result.setModifyTime(new Date());
                        result.setActionType(Short.valueOf((short)1));
                        result.setDealStatus(Short.valueOf((short)0));
                        this.adTicketService.updateTicketUrlTest(result);
                    }
                } else {
                    if (adTicket.getStatus() != null && adTicket.getStatus() == -3 && adTicketDto.getResubmitReview().booleanValue()) {
                        adTicketDto.setStatus(Short.valueOf((short)-2));
                    }
                    if (adTicket.getStatus() != null && adTicket.getStatus() == -1) {
                        adTicketDto.setStatus(Short.valueOf((short)3));
                    }
                }
            } else if (adTicket.getStatus() != null && adTicket.getStatus() == -1) {
                adTicketDto.setStatus(Short.valueOf((short)3));
            }
            try {
                this.addTicketModifyLogs(user, adTicketDto, adTicket);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
            Long ticketId = this.adTicketService.update(CommonConstant.Opera.Platform.ADSMANAGER, adTicketDto, user.getUsername());
            try {
                if (adTicketDto.getId() != null && adTicketDto.getAdvertiser() != null && RedisKeys.advertisers.contains(adTicketDto.getAdvertiser())) {
                    this.jedisUpdater.hupdate(RedisKeys.getPddTickets(), String.valueOf(adTicketDto.getId()), (Object)adTicketDto.getAdvertiser());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5238\u5165Redis\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
            this.addLogs(user, "\u7f16\u8f91\uff1a" + JSON.toJSONString((Object)adTicketDto), String.valueOf(adTicketDto.getId()));
            this.addTicketModifyLogs(user, adTicketDto);
            this.afterHandle(ticketId);
            ResultModel resultModel = ResultModelFactory.SUCCESS((Serializable)ticketId);
            return resultModel;
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519:" + e.getMessage(), (Throwable)e);
            ResultModel resultModel = ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519");
            return resultModel;
        }
    }

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    public ResultModel<AdTicketVo> find(Long id) {
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            AdTicketVo result = this.adTicketService.findById(id);
            LOGGER.info("\u67e5\u627e\u5e7f\u544a\u5238\u7ed3\u679c:" + JSON.toJSONString((Object)result));
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)result);
            return rs;
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findBykeywords"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketVo>> findBykeywords(AdTicketSearchDto condition) {
        ResultModel rs = new ResultModel();
        try {
            List result = this.adTicketService.findBykeywords(condition);
            rs.setReturnValue((Object)result);
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            rs.setErrorDesc(v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setErrorDesc(e.getMessage());
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/delete", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, Long id) {
        if (id == null) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u5238id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            User user = this.getUser(request, response);
            List adTickets = this.adTicketService.findByIds(String.valueOf(id));
            if (adTickets == null || adTickets.isEmpty()) {
                return ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u5238\u4e0d\u5b58\u5728");
            }
            AdTicket adTicket = (AdTicket)adTickets.get(0);
            if (!user.getRoleCodes().contains(RoleEnum.AELEADER.getCode()) && !adTicket.getAe().equals(user.getUsername()) && user.getRoleCodes().contains(RoleEnum.AELEADER.getCode())) {
                return ResultModelFactory.FAIL500((String)"\u4f60\u6ca1\u6709\u5220\u9664\u8be5\u5238\u7684\u6743\u9650");
            }
            Integer result = this.adTicketService.delete(id, user.getUsername());
            this.addLogs(user, JSON.toJSONString((Object)"\u5220\u9664\u5e7f\u544a\u5238"), id + "");
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)result);
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u5238\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PaginationTemp> findAll(AdTicketSearchDto searchDto, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)searchDto.getPvStartTime()) || StringUtils.isBlank((CharSequence)searchDto.getPvEndTime())) {
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            User user = this.getUser(request, response);
            PaginationTemp result = this.adTicketService.findAll(searchDto, user);
            ResultModel rs = new ResultModel();
            rs.setReturnValue((Object)result);
            return rs;
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6240\u6709\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u6240\u6709\u5e7f\u544a\u5238\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/findAdxTicketPackage"}, method={RequestMethod.GET})
    public ResultModel<PaginationTemp> findAdxTicketPackage(AdTicketSearchDto searchDto, HttpServletRequest request, HttpServletResponse response) {
        searchDto.setPvStartTime(DateUtil.dateTo8String((Date)DateUtil.increaseDate((Date)new Date(), (int)-1)));
        searchDto.setPvEndTime(DateUtil.dateTo8String((Date)DateUtil.increaseDate((Date)new Date(), (int)-1)));
        if (StringUtils.isNotBlank((CharSequence)searchDto.getTicketStrIds())) {
            String[] ticketStrIds;
            ArrayList<Long> ticketIds = new ArrayList<Long>();
            for (String ticketId : ticketStrIds = searchDto.getTicketStrIds().split(",")) {
                ticketIds.add(Long.valueOf(ticketId));
            }
            searchDto.setTicketIds(ticketIds);
            searchDto.setTagCode(null);
        }
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            PaginationTemp result = this.adTicketService.findAdxTicketPackage(searchDto, user);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6240\u6709ADX\u5238\u9700\u8981\u7684\u7968\u5238\u5305\u7684\u5238\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u6240\u6709ADX\u5238\u9700\u8981\u7684\u7968\u5238\u5305\u7684\u5238\u6570\u636e\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/updateStatus", keyName="\u5e7f\u544a")
    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id, @RequestParam(required=true, name="status") Short status) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            AdTicket adTicket = new AdTicket();
            adTicket.setId(id);
            adTicket.setStatus(status);
            adTicket.setModifyUser(this.getUser(request, response).getUsername());
            Object result = this.adTicketService.updateStatus(adTicket);
            this.addLogs(user, JSON.toJSONString((Object)(AdTicket.AdTicketStatus.getName((short)status) + "\u5e7f\u544a\u5238")), id + "");
            rs.setReturnValue(result);
        }
        catch (ValidateException v) {
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (PushProdException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u5e7f\u544a\u5238\u72b6\u6001\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"queryAdvertiser"}, method={RequestMethod.GET})
    public ResultModel<Pagination> queryAdvertiser(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            String pageSizeStr;
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            Integer pageNum = 1;
            Integer pageSize = 20;
            String pageNumStr = request.getParameter("pageNum");
            if (StringUtils.isNotBlank((CharSequence)pageNumStr)) {
                pageNum = Integer.parseInt(pageNumStr);
            }
            if (StringUtils.isNotBlank((CharSequence)(pageSizeStr = request.getParameter("pageSize")))) {
                pageSize = Integer.parseInt(pageSizeStr);
            }
            param.put("pageNum", pageNum);
            param.put("pageSize", pageSize);
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("id"))) {
                param.put("id", request.getParameter("id"));
            }
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("keywords"))) {
                param.put("keywords", request.getParameter("keywords"));
            }
            Pagination pageBean = this.adShopIntegration.getAdvertiserPage(param);
            rs.setReturnValue((Object)pageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e7f\u544a\u4e3b\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u83b7\u53d6\u5e7f\u544a\u4e3b\u5217\u8868\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/isCheck"})
    public ResultModel isCheck(@RequestParam(name="isCheck", required=true) String isCheck) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adTicketService.isCheck(isCheck));
        return resultModel;
    }

    @RequestMapping(value={"/getIsCheck"})
    public ResultModel getIsCheck() {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adTicketService.getIsCheck());
        return resultModel;
    }

    @RequestMapping(value={"/getList"}, method={RequestMethod.GET})
    public ResultModel getList(@RequestParam(name="keyWord") String keyWord, @RequestParam(name="sale") String sale, @RequestParam(name="ae") String ae, @RequestParam(name="pageNum") Integer pageNum, @RequestParam(name="pageSize") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        try {
            Map map = this.adTicketService.getList(keyWord, sale, ae, pageNum, pageSize);
            resultModel.setReturnValue((Object)map);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5ba1\u6838\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return resultModel;
    }

    @RequestMapping(value={"/getQualify"})
    public ResultModel getQualify(@RequestParam(name="advertiserId", required=true) Integer advertiserId) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adTicketService.findQualifyList(advertiserId));
        return resultModel;
    }

    @LogBefore(operType="/adTicket/updateQualify", keyName="\u6dfb\u52a0\u3001\u4fee\u6539\u5e7f\u544a\u4e3b\u8d44\u8d28")
    @RequestMapping(value={"/updateQualify"}, method={RequestMethod.POST})
    public ResultModel updateQualify(@RequestParam(name="advertiserId") Integer advertiserId, @RequestParam(name="json") String json, @RequestParam(name="deleteIds") String deleteIds) {
        ResultModel resultModel = new ResultModel();
        if (StringUtils.isBlank((CharSequence)json)) {
            resultModel.setReturnValue((Object)"\u8d44\u8d28\u4fee\u6539\u4e0d\u80fd\u4f20\u7a7a");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        try {
            List list = JSON.parseArray((String)json, TblAdQualify.class);
            resultModel.setReturnValue((Object)this.adTicketService.updateQualify(list, deleteIds, advertiserId));
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4e3b\u4fee\u6539\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            resultModel.setReturnValue((Object)"\u5e7f\u544a\u4e3b\u4fee\u6539\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        return resultModel;
    }

    @RequestMapping(value={"/getCheckList"}, method={RequestMethod.GET})
    public ResultModel getCheckList(@RequestParam(name="advertiserId", required=true) Integer advertiserId, @RequestParam(name="status", required=true) Integer status, @RequestParam(name="keyWord") String keyWord, @RequestParam(name="pageNum") Integer pageNum, @RequestParam(name="pageSize") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        try {
            Map map = this.adTicketService.getCheckList(advertiserId, status, keyWord, pageNum, pageSize);
            resultModel.setReturnValue((Object)map);
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u5f85\u5ba1\u6838\u3001\u5ba1\u6838\u62d2\u7edd\u5217\u8868\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return resultModel;
    }

    @RequestMapping(value={"/getWaitCheckList"}, method={RequestMethod.GET})
    @Deprecated
    public ResultModel<PageInfo<AdTicketCheckDto>> getWaitCheckList(@RequestParam(name="advertiser", required=false) String advertiser, @RequestParam(name="keyWord", required=false) String keyWord, @RequestParam(name="sale", required=false) String sale, @RequestParam(name="ae", required=false) String ae, @RequestParam(name="createUser", required=false) String createUser, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.adTicketService.getWaitCheckList(advertiser, keyWord, sale, ae, createUser, pageNum, pageSize));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5f85\u5ba1\u6838\u5238\u5217\u8868\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u5f85\u5ba1\u6838\u5238\u5217\u8868\u4fe1\u606f\u51fa\u9519");
        }
        return resultModel;
    }

    @LogBefore(operType="/adTicket/ticketCheck", keyName="\u5e7f\u544a\u5238\u5355\u6761\u5ba1\u6838")
    @RequestMapping(value={"/ticketCheck"})
    public ResultModel ticketCheck(@RequestParam(name="status", required=true) Integer status, @RequestParam(name="ticketId", required=true) Long ticketId, @RequestParam(name="refuseReason") String refuseReason, @RequestParam(name="tags") String tags, @RequestParam(name="domainCode") String domainCode, HttpServletRequest request, HttpServletResponse response) {
        ResultModel resultModel = new ResultModel();
        try {
            User user = this.getUser(request, response);
            Boolean success = this.adTicketService.ticketCheck(ticketId, status, refuseReason, tags, domainCode, user.getUsername());
            resultModel.setReturnValue((Object)success);
        }
        catch (Exception e) {
            LOGGER.error("\u5238\u5ba1\u6838\u5931\u8d25" + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return resultModel;
    }

    @LogBefore(operType="/adTicket/auditTicketBatch", keyName="\u5e7f\u544a\u5238\u6279\u91cf\u5ba1\u6838")
    @RequestMapping(value={"/auditTicketBatch"}, method={RequestMethod.POST})
    public ResultModel<String> auditTicketBatch(HttpServletRequest request, HttpServletResponse response, @RequestParam(name="ticketIds", required=true) String ticketIds, @RequestParam(name="status", required=true) Integer status, @RequestParam(name="refuseReason", required=false) String refuseReason) {
        ResultModel resultModel = new ResultModel();
        User user = this.getUser(request, response);
        if (status == 0 && StringUtils.isBlank((CharSequence)refuseReason)) {
            return ResultModelFactory.FAIL500((String)"\u8bf7\u586b\u5199\u5ba1\u6838\u62d2\u7edd\u539f\u56e0");
        }
        try {
            List tickeIdList = JSON.parseArray((String)ticketIds, Long.class);
            ArrayList<Long> auditFailTicketIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty((Collection)tickeIdList)) {
                for (Long ticketId : tickeIdList) {
                    AdTicketCheckInfokDto ticketInfo = this.adTicketService.getTicketInfoAndAssetsModify(ticketId);
                    if (status == 1 && ticketInfo == null) {
                        return ResultModelFactory.FAIL500((String)("\u5238ID:" + ticketId + ",\u5ba1\u6838\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5b8c\u5584"));
                    }
                    if (status == 1 && ticketInfo != null && StringUtils.isBlank((CharSequence)ticketInfo.getTags())) {
                        return ResultModelFactory.FAIL500((String)("\u5238ID:" + ticketId + ",\u5e7f\u544a\u6807\u7b7e\u4e0d\u80fd\u4e3a\u7a7a"));
                    }
                    if (status == 1 && ticketInfo != null && StringUtils.isBlank((CharSequence)ticketInfo.getDomainCode())) {
                        return ResultModelFactory.FAIL500((String)("\u5238ID:" + ticketId + ",\u5e7f\u544a\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a"));
                    }
                    Boolean success = this.adTicketService.ticketCheck(ticketId, status, refuseReason, ticketInfo.getTags(), ticketInfo.getDomainCode(), user.getUsername());
                    if (success.booleanValue()) continue;
                    auditFailTicketIds.add(ticketId);
                }
            }
            if (CollectionUtils.isNotEmpty(auditFailTicketIds)) {
                resultModel.setReturnValue((Object)((Object)auditFailTicketIds).toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u5e7f\u544a\u5238\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5ba1\u6838\u5e7f\u544a\u5238\u4fe1\u606f\u51fa\u9519");
        }
        return resultModel;
    }

    @RequestMapping(value={"/getTicketLog"}, method={RequestMethod.GET})
    public ResultModel getTicketLog(@RequestParam(name="ticketId") Long ticketId) {
        ResultModel resultModel = new ResultModel();
        TblAdTicketModify tblAdTicketModify = this.adTicketService.getTicketLog(ticketId);
        resultModel.setReturnValue((Object)tblAdTicketModify);
        return resultModel;
    }

    @RequestMapping(value={"/getTicketInfo"}, method={RequestMethod.GET})
    public ResultModel getTicketInfo(@RequestParam(name="ticketId") Long ticketId) {
        AdTicketCheckInfokDto adTicketCheckInfokDto = null;
        try {
            adTicketCheckInfokDto = this.adTicketService.getTicketInfoAndAssetsModify(ticketId);
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u5e7f\u544a\u5238\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5ba1\u6838\u5e7f\u544a\u5238\u4fe1\u606f\u51fa\u9519");
        }
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)adTicketCheckInfokDto);
        return resultModel;
    }

    @RequestMapping(value={"/getUrlTestList"}, method={RequestMethod.GET})
    public ResultModel<PaginationTemp> getUrlTestList(AdTicketSearchDto adTicketSearchDto) {
        ResultModel rs = new ResultModel();
        try {
            PaginationTemp result = this.adTicketService.findUrlTestList(adTicketSearchDto);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u94fe\u63a5\u6d4b\u8bd5\u5217\u8868\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u94fe\u63a5\u6d4b\u8bd5\u5217\u8868\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/addUrlTestResult"}, method={RequestMethod.GET})
    public ResultModel addUrlTestResult(AdTicketUrlTest adTicketUrlTest) {
        if (StringUtils.isBlank((CharSequence)adTicketUrlTest.getUrlTestResult())) {
            return ResultModelFactory.FAIL500((String)"\u94fe\u63a5\u6d4b\u8bd5\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ResultModel rs = new ResultModel();
        adTicketUrlTest.setDealStatus(Short.valueOf((short)1));
        Integer result = this.adTicketService.updateTicketUrlTest(adTicketUrlTest);
        if (result != 1) {
            rs.setSuccessed(false);
            rs.setReturnValue((Object)"\u94fe\u63a5\u6d4b\u8bd5\u7ed3\u679c\u63d0\u4ea4\u5931\u8d25");
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/updateStatusBySentinel", keyName="\u76d1\u63a7\u9879\u76ee\u4fee\u6539\u72b6\u6001")
    @RequestMapping(value={"/updateStatusBySentinel"}, method={RequestMethod.GET})
    public ResultModel<Boolean> update(@RequestParam(required=true, name="id") Long id) {
        ResultModel rs = new ResultModel();
        try {
            Boolean flag = this.adTicketService.updateStatus(id);
            rs.setReturnValue((Object)flag);
        }
        catch (ValidateException v) {
            rs.setReturnValue((Object)false);
            rs.setErrorDesc("\u67e5\u627e\u4e0d\u5230\u5e7f\u544a\u5238\u6216\u8005\u8be5\u5e7f\u544a\u5238\u5df2\u7ecf\u5220\u9664");
            return rs;
        }
        catch (PushProdException e) {
            rs.setReturnValue((Object)false);
            rs.setErrorDesc("\u5e7f\u544a\u5238" + id + "\u63a8\u9001\u5931\u8d25");
            return rs;
        }
        catch (Exception e) {
            rs.setReturnValue((Object)false);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
        return rs;
    }

    @RequestMapping(value={"/getAeCodeByTicketId"}, method={RequestMethod.GET})
    public ResultModel<String> getAeCodeByTicketId(@RequestParam(required=true, name="id") Long id) {
        ResultModel rs = new ResultModel();
        try {
            String ae = this.adTicketService.getAeCodeByTicketId(id);
            rs.setReturnValue((Object)ae);
        }
        catch (Exception e) {
            rs.setReturnValue(null);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/addBatchFlowPackage", keyName="\u6279\u91cf\u6dfb\u52a0\u6d41\u91cf\u5305ID\u5230\u591a\u4e2a\u5e7f\u544a\u5238")
    @RequestMapping(value={"/addBatchFlowPackage"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addBatchFlowPackage(@RequestParam(name="flowPackageArrayConfs") String flowPackageArrayConfs, HttpServletRequest request, HttpServletResponse response) {
        List flowPackageAddBatchDtos = JSON.parseArray((String)flowPackageArrayConfs, AdTicketFlowPackageAddBatchDto.class);
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            Boolean flag = this.adTicketService.addBatchFlowPackage(flowPackageAddBatchDtos, user.getUsername());
            rs.setReturnValue((Object)flag);
        }
        catch (Exception e) {
            rs.setReturnValue(null);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/addBatchPosition", keyName="\u6279\u91cf\u6dfb\u52a0\u5e7f\u544a\u4f4dID\u5230\u591a\u4e2a\u5e7f\u544a\u5238")
    @RequestMapping(value={"/addBatchPosition"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addBatchPosition(@RequestParam(required=true, name="positionArrayConfs") String positionArrayConfs, HttpServletRequest request, HttpServletResponse response) {
        List flowPackageAddBatchDtos = JSON.parseArray((String)positionArrayConfs, AdTicketPositionAddBatchDto.class);
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            Boolean flag = this.adTicketService.addBatchPosition(flowPackageAddBatchDtos, user.getUsername());
            rs.setReturnValue((Object)flag);
        }
        catch (Exception e) {
            rs.setReturnValue(null);
            rs.setErrorDesc(e.getMessage());
            return rs;
        }
        return rs;
    }

    @LogBefore(operType="/adTicket/addBatchFlowPackagesByTickets", keyName="\u6279\u91cf\u6dfb\u52a0\u5e7f\u544a\u4f4dID\u5230\u591a\u4e2a\u5e7f\u544a\u5238")
    @RequestMapping(value={"/addBatchFlowPackagesByTickets"}, method={RequestMethod.POST})
    public ResultModel<Boolean> addBatchPositionByTickets(@RequestParam(name="ticketIds") String ticketIds, @RequestParam(name="flowPackages") String flowPackages, @RequestParam(name="type") String type, HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            String msg = this.adTicketService.addBatchFlowPackagesByTickets(ticketIds, flowPackages, type, user.getUsername());
            rs.setReturnValue((Object)msg);
        }
        catch (Exception e) {
            LOGGER.error("\u6279\u91cf\u6dfb\u52a0\u9ed1\u767d\u540d\u5355\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @RequestMapping(value={"/findTicketByParams"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdTicketAppEntranceVo>> findTicketByParams(AdTicketSearchDto adTicketSearchDto) {
        try {
            ResultModel rs = new ResultModel();
            PageInfo pageInfo = this.adTicketService.queryTicketsByParams(adTicketSearchDto);
            rs.setReturnValue((Object)pageInfo);
            return rs;
        }
        catch (ValidateException v) {
            LOGGER.error(v.getMessage(), (Throwable)v);
            return ResultModelFactory.FAIL400((String)v.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u5e7f\u544a\u5238\u51fa\u9519");
        }
    }
}

