/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.model.dto.AdTicketSearchDto;
import com.bxm.adsmanager.model.dto.TicketCosWarnDto;
import com.bxm.adsmanager.service.adkeeper.AdTicketCostService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicket/cost"})
public class AdTicketCostController {
    private static final Logger LOG = LoggerFactory.getLogger(AdTicketCostController.class);
    @Autowired
    private AdTicketCostService adTicketCostService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel findAll(AdTicketSearchDto adTicketSearchDto) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.adTicketCostService.findAll(adTicketSearchDto, null));
        }
        catch (Exception e) {
            resultModel.setSuccessed(false);
            e.printStackTrace();
        }
        return resultModel;
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.GET})
    public ResultModel remove(@RequestParam(value="id") Long id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.adTicketCostService.remove(id));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultModel;
    }

    @RequestMapping(value={"/saveOrUpdate"})
    public ResultModel saveOrUpdate(TicketCosWarnDto ticketCosWarnDto) {
        try {
            this.adTicketCostService.saveOrUpdate(ticketCosWarnDto);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.GET})
    public ResultModel delete(@RequestParam(name="id") String id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setSuccessed(this.adTicketCostService.delete(id).booleanValue());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u5238\u63d0\u9192\u503c\u5220\u9664\u5931\u8d25");
        }
        return resultModel;
    }

    @RequestMapping(value={"/deleteMany"}, method={RequestMethod.GET})
    public ResultModel deleteMany(@RequestParam(name="ids") String ids) {
        ResultModel resultModel = new ResultModel();
        try {
            if (StringUtils.isBlank((CharSequence)ids)) {
                return ResultModelFactory.FAIL500((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List list = JSON.parseArray((String)ids, Long.class);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.adTicketCostService.deleteByIds(list);
            }
            resultModel.setSuccessed(true);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u5238\u63d0\u9192\u503c\u5220\u9664\u5931\u8d25");
        }
        return resultModel;
    }

    @RequestMapping(value={"/findTicket"}, method={RequestMethod.GET})
    public ResultModel findTicket(AdTicketSearchDto adTicketSearchDto, @RequestParam(value="mark", required=true) Integer mark, @RequestParam(value="json") String json) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adTicketCostService.findTicket(adTicketSearchDto, mark, json));
        return resultModel;
    }

    @RequestMapping(value={"/findTicketConsumeRemindList"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel findTicketConsumeRemindList(AdTicketSearchDto adTicketSearchDto) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adTicketCostService.findTicketConsumeRemindList(adTicketSearchDto));
        return resultModel;
    }

    @RequestMapping(value={"/editShow"}, method={RequestMethod.GET})
    public ResultModel editShow(@RequestParam(value="ticketIds") String ticketIds) {
        if (StringUtils.isBlank((CharSequence)ticketIds) || "[]".equals(ticketIds)) {
            return ResultModelFactory.FAIL500((String)"\u5238ID\u4e0d\u80fd\u4f20\u7a7a");
        }
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.adTicketCostService.editShow(ticketIds));
        }
        catch (Exception e) {
            LOG.error("\u7f16\u8f91\u6570\u636e\u56de\u663e\u5931\u8d25", (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u7f16\u8f91\u6570\u636e\u56de\u663e\u5931\u8d25");
        }
        return resultModel;
    }

    @RequestMapping(value={"/addCostWarnByTag"}, method={RequestMethod.GET})
    public ResultModel addCostWarnByTag(@RequestParam(value="tagCodes") String tagCodes, @RequestParam(value="cosWarn") String cosWarn, @RequestParam(value="json") String json, @RequestParam(value="url", required=false) String url) {
        return this.adTicketCostService.addCostWarnByTag(tagCodes, cosWarn, json, url);
    }

    @RequestMapping(value={"/syns"})
    public ResultModel syns() {
        try {
            this.adTicketCostService.syns();
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return ResultModelFactory.SUCCESS();
    }
}

