/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.constant.RedisKeys;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketCouponsCode;
import com.bxm.adsmanager.redis.RedisNewClient;
import com.bxm.adsmanager.service.adkeeper.AdTicketCouponsCodeService;
import com.bxm.adsmanager.utils.CouponCodeFileUploadUtil;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.UuidUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adTicketCouponsCode"})
public class AdTicketCouponsCodeController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketCouponsCodeController.class);
    @Resource
    private RedisNewClient redisNewClient;
    @Resource
    private AdTicketCouponsCodeService adTicketCouponsCodeService;

    @LogBefore(operType="/adTicketCouponsCode/uploadCode", keyName="\u4f18\u60e0\u5238code\u6587\u4ef6\u4e0a\u4f20")
    @RequestMapping(value={"/uploadCode"}, method={RequestMethod.POST})
    public ResultModel uploadCode(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        try {
            Set codeSet = CouponCodeFileUploadUtil.upload((HttpServletRequest)request);
            String codeKeyName = UuidUtil.getUuidByJdk((boolean)false);
            this.redisNewClient.sadd(RedisKeys.getKeyGeneratorByTempAssetsCouponsCode((String)codeKeyName).generateKey(), codeSet, Integer.valueOf(RedisKeys.getKeyGeneratorByTempAssetsCouponsCodeDBIndex()));
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("codeKeyName", codeKeyName);
            map.put("codeNum", codeSet.size());
            rs.setReturnValue(map);
        }
        catch (Exception e) {
            LOGGER.error("\u4f18\u60e0\u5238code\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u4f18\u60e0\u5238code\u6587\u4ef6\u4e0a\u4f20\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/exportCode"}, method={RequestMethod.GET})
    public void findAll(@RequestParam(value="ticketId") Long ticketId, HttpServletRequest request, HttpServletResponse response) {
        try {
            List exportList = this.adTicketCouponsCodeService.findByTicketId(ticketId);
            if (CollectionUtils.isEmpty((Collection)exportList)) {
                exportList = Collections.emptyList();
            }
            ExcelUtil.exportExcel(exportList, null, null, AdTicketCouponsCode.class, (String)"\u4f18\u60e0\u5238\u7801\u8bb0\u5f55\u5bfc\u51fa.xls", (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5238\u8017\u8bb0\u5f55\u51fa\u9519");
        }
    }
}

