/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.model.dto.AdAssetsStatisticsDto;
import com.bxm.adsmanager.model.vo.AdAssetsStatisticsVo;
import com.bxm.adsmanager.service.adkeeper.AdTicketAssetsService;
import com.bxm.adsmanager.service.adkeeper.AdTicketStatService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAssets/stat"})
public class AdTicketStatController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdTicketStatController.class);
    @Autowired
    private AdTicketStatService adTicketStatService;
    @Autowired
    private AdTicketAssetsService adTicketAssetsService;

    @RequestMapping(value={"/findLowClickCount"}, method={RequestMethod.GET})
    public ResultModel<Long> findAdAssetsLowClickRateCount(AdAssetsStatisticsDto param) {
        ResultModel rs = new ResultModel();
        Long count = 0L;
        try {
            count = this.adTicketStatService.queryAdAssetsLowClickRateCount(param);
            rs.setReturnValue((Object)count);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7d20\u6750\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u7d20\u6750\u6570\u636e\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAdAssetsList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdAssetsStatisticsVo>> findAdAssetsLowClickRateList(AdAssetsStatisticsDto param) {
        ResultModel rs = new ResultModel();
        if (param == null || StringUtils.isBlank((CharSequence)param.getPvStartTime()) || StringUtils.isBlank((CharSequence)param.getPvEndTime())) {
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageInfo list = null;
        try {
            list = this.adTicketAssetsService.findAdAssetsLowClickRateList(param);
            rs.setReturnValue((Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7d20\u6750\u5217\u8868\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u7d20\u6750\u5217\u8868\u6570\u636e\u51fa\u9519");
        }
        return rs;
    }
}

