/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketMapper;
import com.bxm.adsmanager.dal.mapper.adkeeper.ext.AdAssetsAdxMapperExt;
import com.bxm.adsmanager.model.dao.adkeeper.AdAssetsAdx;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicket;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.service.prod.ProdService;
import com.bxm.adsmanager.web.controller.base.BaseController;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adx/meituan"})
public class AdxMeituanController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdxMeituanController.class);
    @Autowired
    private AdAssetsAdxMapperExt adAssetsAdxMapperExt;
    @Autowired
    private AdTicketMapper adTicketMapper;
    @Autowired
    private ProdService prodService;

    @RequestMapping(value={"/callback"}, method={RequestMethod.POST})
    public String callback(@Validated @RequestBody meituanDTO dto) throws Exception {
        List<MeituanCallBackParam> params = dto.getParams();
        if (CollectionUtils.isEmpty(params)) {
            return "fail";
        }
        LOGGER.info("\u3010\u7f8e\u56e2\u5ba1\u6838\u56de\u8c03\u3011\u4f20\u5165\u53c2\u6570\uff1a{}", (Object)params.toString());
        for (MeituanCallBackParam param : params) {
            AdAssetsAdx assetsUpdate;
            AdAssetsAdx adAssetsAdx;
            Long assetsId = param.getAssetsId();
            Short reviewStatus = param.getReviewStatus();
            String refuseReason = param.getRefuseReason();
            if (AdAssetsAdx.MEITUAN_REVIEW_WAIT.equals(reviewStatus) || null == (adAssetsAdx = this.adAssetsAdxMapperExt.selectByPrimaryKey(assetsId))) continue;
            Long adTicketId = adAssetsAdx.getAdTicketId();
            if (AdAssetsAdx.MEITUAN_REVIEW_PASS.equals(reviewStatus)) {
                assetsUpdate = new AdAssetsAdx();
                assetsUpdate.setId(assetsId);
                assetsUpdate.setMeituanReviewStatus(reviewStatus);
                this.adAssetsAdxMapperExt.updateByPrimaryKeySelective(assetsUpdate);
            }
            if (AdAssetsAdx.MEITUAN_REVIEW_REFUSE.equals(reviewStatus)) {
                Short status;
                assetsUpdate = new AdAssetsAdx();
                assetsUpdate.setId(assetsId);
                assetsUpdate.setMeituanReviewStatus(reviewStatus);
                assetsUpdate.setMeituanRefuseReason(refuseReason);
                this.adAssetsAdxMapperExt.updateByPrimaryKeySelective(assetsUpdate);
                AdTicket adTicket = this.adTicketMapper.selectByPrimaryKey(adTicketId);
                if (adTicket != null && (status = adTicket.getStatus()).equals((short)1)) {
                    AdTicket ticketUpdate = new AdTicket();
                    ticketUpdate.setId(adTicketId);
                    ticketUpdate.setStatus(Short.valueOf((short)3));
                    this.adTicketMapper.updateByPrimaryKeySelective(ticketUpdate);
                    this.prodService.pushAdTicketToProdPre(adTicketId);
                    User user = new User();
                    user.setUsername("\u7cfb\u7edf");
                    this.addLogs(user, "\u505c\u6b62\u5e7f\u544a\u5238\uff0c\u7f8e\u56e2\u5ba1\u6838\u4fee\u6539\u5238\u72b6\u6001\uff1a" + JSON.toJSONString(params), String.valueOf(adTicketId));
                }
            }
            LOGGER.info("\u3010\u7f8e\u56e2\u5ba1\u6838\u56de\u8c03\u3011\u5904\u7406\u5b8c\u6210,assetsId = {}", (Object)assetsId);
        }
        return "success";
    }

    public static class meituanDTO {
        private List<MeituanCallBackParam> params;

        public List<MeituanCallBackParam> getParams() {
            return this.params;
        }

        public void setParams(List<MeituanCallBackParam> params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof meituanDTO)) {
                return false;
            }
            meituanDTO other = (meituanDTO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<MeituanCallBackParam> this$params = this.getParams();
            List<MeituanCallBackParam> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        protected boolean canEqual(Object other) {
            return other instanceof meituanDTO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MeituanCallBackParam> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        public String toString() {
            return "AdxMeituanController.meituanDTO(params=" + this.getParams() + ")";
        }
    }

    public static class MeituanCallBackParam
    implements Serializable {
        @NotNull
        private Long assetsId;
        @NotNull
        private Short reviewStatus;
        private String refuseReason;

        public Long getAssetsId() {
            return this.assetsId;
        }

        public Short getReviewStatus() {
            return this.reviewStatus;
        }

        public String getRefuseReason() {
            return this.refuseReason;
        }

        public void setAssetsId(Long assetsId) {
            this.assetsId = assetsId;
        }

        public void setReviewStatus(Short reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        public void setRefuseReason(String refuseReason) {
            this.refuseReason = refuseReason;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MeituanCallBackParam)) {
                return false;
            }
            MeituanCallBackParam other = (MeituanCallBackParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$assetsId = this.getAssetsId();
            Long other$assetsId = other.getAssetsId();
            if (this$assetsId == null ? other$assetsId != null : !((Object)this$assetsId).equals(other$assetsId)) {
                return false;
            }
            Short this$reviewStatus = this.getReviewStatus();
            Short other$reviewStatus = other.getReviewStatus();
            if (this$reviewStatus == null ? other$reviewStatus != null : !((Object)this$reviewStatus).equals(other$reviewStatus)) {
                return false;
            }
            String this$refuseReason = this.getRefuseReason();
            String other$refuseReason = other.getRefuseReason();
            return !(this$refuseReason == null ? other$refuseReason != null : !this$refuseReason.equals(other$refuseReason));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MeituanCallBackParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $assetsId = this.getAssetsId();
            result = result * 59 + ($assetsId == null ? 43 : ((Object)$assetsId).hashCode());
            Short $reviewStatus = this.getReviewStatus();
            result = result * 59 + ($reviewStatus == null ? 43 : ((Object)$reviewStatus).hashCode());
            String $refuseReason = this.getRefuseReason();
            result = result * 59 + ($refuseReason == null ? 43 : $refuseReason.hashCode());
            return result;
        }

        public String toString() {
            return "AdxMeituanController.MeituanCallBackParam(assetsId=" + this.getAssetsId() + ", reviewStatus=" + this.getReviewStatus() + ", refuseReason=" + this.getRefuseReason() + ")";
        }
    }
}

