/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.integration.datapark.service.DataparkGetuiTagIntegration;
import com.bxm.adsmanager.integration.datapark.service.DataparkSspSdkAppDailyIntegration;
import com.bxm.adsmanager.model.dao.adkeeper.AdTicketGetuiTagRef;
import com.bxm.adsmanager.model.vo.GetuiTagDictListVo;
import com.bxm.adsmanager.service.adkeeper.GetuiTagDictService;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/getuiTagDict"})
@RestController
public class GetuiTagDictController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetuiTagDictController.class);
    @Autowired
    private GetuiTagDictService getuiTagDictService;
    @Autowired
    private DataparkGetuiTagIntegration dataparkGetuiTagIntegration;
    @Autowired
    private DataparkSspSdkAppDailyIntegration dataparkSspSdkAppDailyIntegration;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<List<GetuiTagDictListVo>> findAll(HttpServletRequest request, HttpServletResponse response) {
        ResultModel rs = new ResultModel();
        rs.setReturnValue((Object)this.getuiTagDictService.findAll());
        rs.setSuccessed(true);
        return rs;
    }

    @RequestMapping(value={"/coverage"}, method={RequestMethod.GET})
    public ResultModel<String> findAll(HttpServletRequest request, HttpServletResponse response, String personsGrade) {
        String info = "\u9884\u4f30\u8986\u76d6\u7387%s\uff0c\u9884\u4f30\u8986\u76d6\u4eba\u6570%d";
        if (StringUtils.isNotBlank((CharSequence)personsGrade)) {
            String[] split;
            ArrayList<AdTicketGetuiTagRef> adTicketGetuiTagRefs = new ArrayList<AdTicketGetuiTagRef>();
            for (String tagGroupConf : split = personsGrade.split(",")) {
                String[] tagGroupConfArray;
                String tagGroupCode;
                if (!StringUtils.isNotBlank((CharSequence)tagGroupConf) || !StringUtils.isNotBlank((CharSequence)(tagGroupCode = (tagGroupConfArray = tagGroupConf.split("-"))[0]))) continue;
                AdTicketGetuiTagRef adTicketGetuiTagRef = new AdTicketGetuiTagRef();
                adTicketGetuiTagRef.setTagGroupCode(tagGroupCode);
                String tagGroupValue = tagGroupConf.replace(tagGroupCode + "-", "").replace("-", ",");
                adTicketGetuiTagRef.setTagGroupValue(tagGroupValue);
                adTicketGetuiTagRefs.add(adTicketGetuiTagRef);
            }
            List tagValues = adTicketGetuiTagRefs.stream().map(AdTicketGetuiTagRef::getTagGroupValue).collect(Collectors.toList());
            List lastTagValues = this.getuiTagDictService.buildRealTag(tagValues);
            Long coverage = this.dataparkGetuiTagIntegration.getConverage(lastTagValues);
            Double rate = 0.0;
            if (coverage != null && coverage > 0L) {
                Long dau = this.dataparkSspSdkAppDailyIntegration.getSspSdkDau(DateUtil.dateTo8String3((Date)DateUtil.getTheDayBefore((Date)new Date())));
                rate = (double)coverage.longValue() * 1.0 / (double)dau.longValue();
            }
            info = String.format(info, new DecimalFormat("#.##%").format(rate), coverage);
        } else {
            info = String.format(info, 0, 0);
        }
        ResultModel rs = new ResultModel();
        rs.setReturnValue((Object)info);
        rs.setSuccessed(true);
        return rs;
    }
}

