/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adkeeper;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.adkeeper.RiskWord;
import com.bxm.adsmanager.model.dto.RiskWordDto;
import com.bxm.adsmanager.model.dto.RiskWordQueryDto;
import com.bxm.adsmanager.model.vo.RiskWordVo;
import com.bxm.adsmanager.service.adkeeper.RiskWordService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/riskWord"})
public class RiskWordController {
    private static final Logger log = LoggerFactory.getLogger(RiskWordController.class);
    @Autowired
    private RiskWordService riskWordService;

    @GetMapping(value={"/getPage"})
    public ResultModel getPage(RiskWordQueryDto queryDto) {
        PageInfo page = this.riskWordService.getPage(queryDto);
        return ResultModelFactory.SUCCESS((Serializable)page);
    }

    @PostMapping(value={"/add"})
    public ResultModel add(RiskWordDto dto) {
        if (dto.getKeyword().contains(",")) {
            return ResultModelFactory.FAIL400((String)"\u654f\u611f\u8bcd\u6c47\u4e0d\u80fd\u5305\u542b\u9017\u53f7");
        }
        this.riskWordService.add(dto);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/update"})
    public ResultModel update(RiskWordDto dto) {
        if (dto.getKeyword().contains(",")) {
            return ResultModelFactory.FAIL400((String)"\u654f\u611f\u8bcd\u6c47\u4e0d\u80fd\u5305\u542b\u9017\u53f7");
        }
        if (null == dto.getId()) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.riskWordService.update(dto);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/updateStatus"})
    public ResultModel updateStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") Integer status) {
        if (StringUtils.isBlank((String)ids)) {
            return ResultModelFactory.FAIL400((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.riskWordService.updateStatus(ids, status);
        return ResultModelFactory.SUCCESS();
    }

    @GetMapping(value={"/export"})
    public ResultModel export(RiskWordQueryDto dto, HttpServletResponse response) {
        dto.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        PageInfo page = this.riskWordService.getPage(dto);
        List list = page.getList();
        for (RiskWordVo riskWordVo : list) {
            if (riskWordVo.getStatus() == null) continue;
            riskWordVo.setStatusExcel(riskWordVo.getStatus().equals(RiskWord.STATUS_OPEN) ? "\u5f00\u542f" : "\u5173\u95ed");
        }
        ExcelUtil.exportExcel((List)list, null, (String)"\u654f\u611f\u8bcd\u5e93", RiskWordVo.class, (String)"\u654f\u611f\u8bcd\u5e93.xls", (HttpServletResponse)response);
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/import"})
    public ResultModel importAdd(@RequestParam(value="file") MultipartFile file) {
        List orderVos;
        try {
            orderVos = ExcelUtil.importExcelV2((MultipartFile)file, RiskWordVo.class);
        }
        catch (Exception e) {
            throw new BusinessException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)orderVos)) {
            throw new BusinessException("\u4e0d\u80fd\u5bfc\u5165\u7a7a\u6587\u4ef6");
        }
        log.info(orderVos.toString());
        return ResultModelFactory.SUCCESS((Serializable)((Object)this.riskWordService.importAdd(orderVos)));
    }
}

