/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adprofit;

import com.bxm.adsmanager.model.dao.adprofit.LocalCache;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketProfitSearchDto;
import com.bxm.adsmanager.model.vo.AdTicketIncomeDetailVo;
import com.bxm.adsmanager.model.vo.AdTicketIncomeVo;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.utils.UserRoleCodeUtil;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/adTicketProfit"})
@RestController
public class AdIncomeTicketController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdIncomeTicketController.class);
    @Autowired
    private AdIncomeTicketService adIncomeTicketService;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketIncomeVo>> findAll(HttpServletRequest request, HttpServletResponse response, AdTicketProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            if (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isAe((User)user))) {
                search.setUserName(user.getUsername());
            }
            if (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isSale((User)user))) {
                search.setSale(user.getUsername());
            }
            List lists = this.adIncomeTicketService.getTicketIncomeList(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u793c\u5238\u6536\u76ca\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u793c\u5238\u6536\u76ca\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @RequestMapping(value={"/findDetail"}, method={RequestMethod.GET})
    public ResultModel<List<AdTicketIncomeDetailVo>> findDetailBydatetime(HttpServletRequest request, HttpServletResponse response, AdTicketProfitSearchDto search) {
        ResultModel rs = new ResultModel();
        try {
            User user = this.getUser(request, response);
            if (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isAe((User)user))) {
                search.setUserName(user.getUsername());
            }
            if (StringUtils.isNotEmpty((CharSequence)UserRoleCodeUtil.isSale((User)user))) {
                search.setSale(user.getUsername());
            }
            List lists = this.adIncomeTicketService.getTicketIncomeDeatil(search);
            rs.setReturnValue((Object)lists);
        }
        catch (Exception e) {
            LOGGER.error("\u793c\u5238\u6536\u76ca\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u9519\u8bef" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u793c\u5238\u6536\u76ca\u8be6\u60c5\u5217\u8868\u67e5\u8be2\u9519\u8bef");
        }
        return rs;
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/adTicketProfit/update")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResultModel update(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") int id, @RequestParam(required=true, name="number") int number) {
        try {
            User user = this.getUser(request, response);
            int result = this.adIncomeTicketService.update(Integer.valueOf(id), number, user.getUsername());
            return ResultModelFactory.SUCCESS((Serializable)Integer.valueOf(result));
        }
        catch (Exception e) {
            LOGGER.error("\u793c\u5238\u6536\u76ca\u7f16\u8f91\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LogBefore(keyName="\u5e7f\u544a", operType="/adTicketProfit/entering")
    @RequestMapping(value={"/entering"}, method={RequestMethod.POST})
    public ResultModel entering(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="ids") String ids, @RequestParam(required=true, name="datetime") String datetime) {
        try {
            AdIncomeTicketController adIncomeTicketController = this;
            synchronized (adIncomeTicketController) {
                Boolean flag = (Boolean)LocalCache.map.get(ids);
                if (flag != null && flag.booleanValue()) {
                    LOGGER.info("\u6570\u636e\u5728\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5,ids:" + ids);
                    return ResultModelFactory.FAIL400((String)"\u6570\u636e\u5728\u5f55\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5");
                }
                LocalCache.map.put(ids, true);
            }
            User user = this.getUser(request, response);
            this.adIncomeTicketService.entering(ids, datetime, user.getUsername());
            LocalCache.map.remove(ids);
            return ResultModelFactory.SUCCESS();
        }
        catch (Exception e) {
            LocalCache.map.remove(ids);
            LOGGER.error("\u793c\u5238\u6536\u76ca\u6536\u76ca\u5f55\u5165\u9519\u8bef" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
    }
}

