/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adprofit;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adsmanager.ecxeption.ProfitException;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.adprofit.DeveloperProfitDto;
import com.bxm.adsmanager.model.vo.Pagination;
import com.bxm.adsmanager.model.vo.adprofit.DeveloperProfitVo;
import com.bxm.adsmanager.service.adprofit.DeveloperProfitService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/developer"})
public class DeveloperProfitController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(DeveloperProfitController.class);
    @Autowired
    private DeveloperProfitService developerProfitService;
    private static boolean isSettled = false;

    @RequestMapping(value={"/getTotalProfit"}, method={RequestMethod.GET})
    public String getTotalProfit(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search) {
        ResultModel rs = new ResultModel();
        try {
            DeveloperProfitVo profit = this.developerProfitService.getTotalProfit(search);
            rs.setReturnValue((Object)profit);
        }
        catch (ProfitException e) {
            LOG.error("\u83b7\u53d6\u5f00\u53d1\u8005\u6536\u76ca\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return JSONObject.toJSONString((Object)ResultModelFactory.FAIL400((String)("\u83b7\u53d6\u5f00\u53d1\u8005\u6536\u76ca\u5217\u8868\u5f02\u5e38:" + e.getMessage())));
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u5f00\u53d1\u8005\u6536\u76ca\u5217\u8868\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            return JSONObject.toJSONString((Object)ResultModelFactory.FAIL500((String)("\u83b7\u53d6\u5f00\u53d1\u8005\u6536\u76ca\u5217\u8868\u9519\u8bef:" + e.getMessage())));
        }
        return JSONObject.toJSONString((Object)rs);
    }

    @RequestMapping(value={"/findProfitList"}, method={RequestMethod.GET})
    public String findProfitList(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search) {
        ResultModel rs = new ResultModel();
        try {
            Pagination resultList = this.developerProfitService.findProfitList(search);
            rs.setReturnValue((Object)resultList);
        }
        catch (ProfitException e) {
            LOG.error("\u83b7\u53d6\u5f00\u53d1\u8005\u65e5\u7ed3\u7b97\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return JSONObject.toJSONString((Object)ResultModelFactory.FAIL400((String)("\u83b7\u53d6\u5f00\u53d1\u8005\u65e5\u7ed3\u7b97\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage())));
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u5f00\u53d1\u8005\u65e5\u7ed3\u7b97\u5217\u8868\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            return JSONObject.toJSONString((Object)ResultModelFactory.FAIL500((String)("\u83b7\u53d6\u5f00\u53d1\u8005\u65e5\u7ed3\u7b97\u5217\u8868\u9519\u8bef\uff1a" + e.getMessage())));
        }
        return JSONObject.toJSONString((Object)rs);
    }

    @RequestMapping(value={"/findProfitByDate"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findProfitByDate(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search) {
        ResultModel rs = new ResultModel();
        try {
            Pagination resultList = this.developerProfitService.findProfitByDate(search);
            rs.setReturnValue((Object)resultList);
        }
        catch (ProfitException e) {
            LOG.error("\u83b7\u53d6\u5f00\u53d1\u8005\u4fe1\u606f\u548c\u7ed3\u7b97\u4fe1\u606f\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL400((String)("\u83b7\u53d6\u5f00\u53d1\u8005\u4fe1\u606f\u548c\u7ed3\u7b97\u4fe1\u606f\u5217\u8868\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u5f00\u53d1\u8005\u4fe1\u606f\u548c\u7ed3\u7b97\u4fe1\u606f\u5217\u8868\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)("\u83b7\u53d6\u5f00\u53d1\u8005\u4fe1\u606f\u548c\u7ed3\u7b97\u4fe1\u606f\u5217\u8868\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return rs;
    }

    @RequestMapping(value={"/findInfoForSettle"}, method={RequestMethod.GET})
    public ResultModel<Pagination> findInfoForSettle(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search) {
        ResultModel rs = new ResultModel();
        try {
            Pagination resultList = this.developerProfitService.findInfoForSettle(search);
            rs.setReturnValue((Object)resultList);
        }
        catch (ProfitException e) {
            LOG.error("\u6839\u636e\u65f6\u95f4\u548cappkey\u83b7\u53d6\u53ef\u4ee5\u7ed3\u7b97\u7684\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL400((String)("\u6839\u636e\u65f6\u95f4\u548cappkey\u83b7\u53d6\u53ef\u4ee5\u7ed3\u7b97\u7684\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            LOG.error("\u6839\u636e\u65f6\u95f4\u548cappkey\u83b7\u53d6\u53ef\u4ee5\u7ed3\u7b97\u7684\u4fe1\u606f\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)("\u6839\u636e\u65f6\u95f4\u548cappkey\u83b7\u53d6\u53ef\u4ee5\u7ed3\u7b97\u7684\u4fe1\u606f\u51fa\u9519\uff1a" + e.getMessage()));
        }
        return rs;
    }

    @LogBefore(keyName="\u5e7f\u544a", operType="/developer/settleAccount")
    @RequestMapping(value={"/settleAccount"}, method={RequestMethod.POST})
    public ResultModel settleAccount(HttpServletRequest request, HttpServletResponse response, DeveloperProfitDto search) {
        try {
            if (isSettled) {
                LOG.error("\u7ed3\u7b97\u4e2d\u8bf7\u7a0d\u540e\u518d\u8bd5\uff1a");
                return ResultModelFactory.FAIL500((String)"\u7ed3\u7b97\u4e2d\u8bf7\u7a0d\u540e\u518d\u8bd5\uff1a");
            }
            isSettled = true;
            String[] keys = search.getKeywords().split(",");
            search.setKeywordList(Arrays.asList(keys));
            User user = this.getUser(request, response);
            int result = this.developerProfitService.settleAccount(search, user.getUsername());
            LOG.info(user.getUsername() + "\u7ed3\u7b97\u64cd\u4f5c\u7ed3\u675f\uff0c\u5171\u7ed3\u7b97\u6210\u529f\uff1a" + result + " \u4e2a\u5f00\u53d1\u8005(\u5e94\u6210\u529f\u4e2a\u6570\u4e3a" + keys.length + ")------");
            isSettled = false;
            return ResultModelFactory.SUCCESS();
        }
        catch (ProfitException e) {
            isSettled = false;
            LOG.error("\u8fdb\u884c\u7ed3\u7b97\u65f6\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL400((String)("\u8fdb\u884c\u7ed3\u7b97\u65f6\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            isSettled = false;
            LOG.error("\u8fdb\u884c\u7ed3\u7b97\u65f6\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)("\u8fdb\u884c\u7ed3\u7b97\u65f6\u51fa\u9519\uff1a" + e.getMessage()));
        }
    }
}

