/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adsmedia;

import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.position.AppEntranceCaleRateConfigQueryDto;
import com.bxm.adsmanager.service.adsmedia.AppEntranceCalcRateConfigService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.adsmedia.facade.income.AppEntrancePvUvVO;
import com.bxm.adsmedia.facade.model.appentrance.AppEntranceCalcRateConfigDTO;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/appEntranceCalcRateConfig"})
public class AppEntranceCalcRateConfigController
extends BaseController {
    @Autowired
    private AppEntranceCalcRateConfigService appEntranceCalcRateConfigService;

    @RequestMapping(value={"/getPage"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AppEntrancePvUvVO>> getPage(AppEntranceCaleRateConfigQueryDto dto) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appEntranceCalcRateConfigService.getPage(dto));
        return resultModel;
    }

    @RequestMapping(value={"/updateRate"}, method={RequestMethod.POST})
    public ResultModel<Boolean> updateReviewRefuseConfig(@RequestBody AppEntranceCalcRateConfigDTO dto, HttpServletRequest request, HttpServletResponse response) {
        String positionId = dto.getPositionId();
        BigDecimal pvuvRate = dto.getPvuvRate();
        if (StringUtils.isBlank((CharSequence)positionId)) {
            return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BigDecimal zero = new BigDecimal("0");
        BigDecimal hundred = new BigDecimal("100");
        if (pvuvRate == null || zero.compareTo(pvuvRate) > 0 || pvuvRate.compareTo(hundred) > 0) {
            return ResultModelFactory.FAIL400((String)"\u6bd4\u7387\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u57280-100\u4e4b\u95f4\uff01");
        }
        ResultModel resultModel = new ResultModel();
        User user = this.getUser(request, response);
        dto.setCreateUser(user.getUsername());
        this.appEntranceCalcRateConfigService.updateRate(dto);
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }
}

