/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.advertiserdata.TicketDataOptimized;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.vo.AdTicketDataOptimizedVo;
import com.bxm.adsmanager.model.vo.adticketgroup.TicketVo;
import com.bxm.adsmanager.service.advertiser.AdvertiserDataOptimizedService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiserDataOptimized"})
public class AdvertiserDataOptimizedController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserDataOptimizedController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserDataOptimizedController.class);
    @Autowired
    private AdvertiserDataOptimizedService advertiserDataOptimizedService;

    @LogBefore(operType="/advertiserDataOptimized/add", keyName="\u6dfb\u52a0\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="rptDate") String rptDate, @RequestParam(value="ticketId") Long ticketId, @RequestParam(value="showNum", required=false, defaultValue="0") Long showNum, @RequestParam(value="clickNum", required=false, defaultValue="0") Long clickNum, @RequestParam(value="effectNum", required=false, defaultValue="0") Long effectNum, @RequestParam(value="consumeNum", required=false, defaultValue="0") Long consumeNum) {
        if (consumeNum < 0L) {
            return ResultModelFactory.FAIL500((String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0 ");
        }
        try {
            String userName = this.getUser(request, response).getUsername();
            TicketDataOptimized ticketDataOptimized = new TicketDataOptimized();
            ticketDataOptimized.setClickNum(clickNum);
            ticketDataOptimized.setRptDate(rptDate);
            ticketDataOptimized.setConsumeNum(consumeNum);
            ticketDataOptimized.setEffectNum(effectNum);
            ticketDataOptimized.setShowNum(showNum);
            ticketDataOptimized.setTicketId(ticketId);
            ticketDataOptimized.setDeductStatus(Integer.valueOf(0));
            ticketDataOptimized.setCreateTime(new Date());
            ticketDataOptimized.setCreateUser(userName);
            this.advertiserDataOptimizedService.add(ticketDataOptimized);
            return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970" + e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                return ResultModelFactory.FAIL500((String)e.getMessage());
            }
            return ResultModelFactory.FAIL500((String)"\u53d1\u751f\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @LogBefore(operType="/advertiserDataOptimized/delete", keyName="\u5220\u9664\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id) {
        try {
            this.advertiserDataOptimizedService.delete(id);
            return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970" + e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                return ResultModelFactory.FAIL500((String)e.getMessage());
            }
            return ResultModelFactory.FAIL500((String)"\u53d1\u751f\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @LogBefore(operType="/advertiserDataOptimized/update", keyName="\u4fee\u6539\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="id") Long id, @RequestParam(value="rptDate") String rptDate, @RequestParam(value="ticketId") Long ticketId, @RequestParam(value="showNum", required=false) Long showNum, @RequestParam(value="clickNum", required=false) Long clickNum, @RequestParam(value="effectNum", required=false) Long effectNum, @RequestParam(value="consumeNum", required=false) Long consumeNum) {
        if (consumeNum < 0L) {
            return ResultModelFactory.FAIL500((String)"\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0 ");
        }
        try {
            String userName = this.getUser(request, response).getUsername();
            TicketDataOptimized ticketDataOptimized = new TicketDataOptimized();
            ticketDataOptimized.setClickNum(clickNum);
            ticketDataOptimized.setRptDate(rptDate);
            ticketDataOptimized.setConsumeNum(consumeNum);
            ticketDataOptimized.setEffectNum(effectNum);
            ticketDataOptimized.setShowNum(showNum);
            ticketDataOptimized.setTicketId(ticketId);
            ticketDataOptimized.setId(id);
            ticketDataOptimized.setModifyUser(userName);
            ticketDataOptimized.setModifyTime(new Date());
            this.advertiserDataOptimizedService.update(ticketDataOptimized);
            return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970" + e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                return ResultModelFactory.FAIL500((String)e.getMessage());
            }
            return ResultModelFactory.FAIL500((String)"\u53d1\u751f\u7cfb\u7edf\u9519\u8bef");
        }
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultModel<PageInfo<AdTicketDataOptimizedVo>> getAdvertiserDataOptimizedList(@RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="ticketId", required=false) String ticketId, @RequestParam(value="dimension", required=false) String dimension, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        ResultModel pageInfoResultModel = new ResultModel();
        try {
            PageInfo page = this.advertiserDataOptimizedService.findAll(startTime, endTime, ticketId, dimension, pageNum, pageSize);
            pageInfoResultModel.setReturnValue((Object)page);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u4fee\u9970" + e.getMessage(), (Throwable)e);
            pageInfoResultModel.setErrorCode("500");
            pageInfoResultModel.setErrorDesc("\u67e5\u627e\u51fa\u9519");
            return pageInfoResultModel;
        }
        return pageInfoResultModel;
    }

    @LogBefore(operType="/advertiserDataOptimized/deductFinance", keyName="\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6570\u636e\u6263\u6b3e")
    @PostMapping(value={"/deductFinance"}, produces={"application/json"})
    public ResultModel addAdvertiserFinanceById(@RequestParam(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        try {
            User currentUser = this.getUser(request, response);
            this.advertiserDataOptimizedService.addAdvertiserFinanceById(id, currentUser);
        }
        catch (Exception e) {
            LOGGER.error("\u5e7f\u544a\u4e3b\u540e\u53f0\u6d88\u8017\u6263\u6b3e" + e.getMessage(), (Throwable)e);
            if (e instanceof BusinessException) {
                return ResultModelFactory.FAIL500((String)e.getMessage());
            }
            return ResultModelFactory.FAIL500((String)"\u53d1\u751f\u7cfb\u7edf\u9519\u8bef");
        }
        return ResultModelFactory.SUCCESS((Serializable)Boolean.valueOf(true));
    }

    @GetMapping(value={"/findTicket"}, produces={"application/json"})
    public ResultModel<List<TicketVo>> findTicket(@RequestParam(value="keyword") String keyword) {
        ResultModel resultModel = new ResultModel();
        try {
            List ticketVo = this.advertiserDataOptimizedService.findTicket(keyword);
            resultModel.setReturnValue((Object)ticketVo);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636eId\u83b7\u53d6\u5e7f\u544a\u5238\u4fe1\u606f" + e.getMessage(), (Throwable)e);
            resultModel.setErrorCode("500");
            resultModel.setErrorDesc("\u67e5\u627e\u51fa\u9519");
            return resultModel;
        }
        return resultModel;
    }
}

