/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.advertiser;

import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceNewDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserFinanceVo;
import com.bxm.adsmanager.integration.advertiser.model.Pagination;
import com.bxm.adsmanager.integration.advertiser.service.AdFinanceIntegration;
import com.bxm.adsmanager.model.vo.AdvertiserTicketConsumeInfoVO;
import com.bxm.adsmanager.service.adprofit.AdIncomeTicketService;
import com.bxm.adsmanager.utils.ExcelUtil;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adFinance"})
public class AdvertiserFinanceController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdvertiserFinanceController.class);
    @Autowired
    private AdFinanceIntegration adFinanceIntegration;
    @Autowired
    private AdIncomeTicketService adIncomeTicketService;

    @RequestMapping(value={"queryAdFinance"}, method={RequestMethod.GET})
    public ResultModel<Pagination> queryAdvertiserFinance(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="advertiserId", required=true) Integer advertiserId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="pageNum", required=false) Integer pageNum) {
        ResultModel rs = new ResultModel();
        AdvertiserFinanceNewDto advertiserFinanceNewDto = new AdvertiserFinanceNewDto();
        advertiserFinanceNewDto.setPageNum(pageNum);
        advertiserFinanceNewDto.setPageSize(pageSize);
        advertiserFinanceNewDto.setAdvertiserId(advertiserId);
        if (StringUtils.isEmpty((CharSequence)startTime) && StringUtils.isEmpty((CharSequence)endTime)) {
            advertiserFinanceNewDto.setStartTime(DateUtil.dateTo8String3((Date)new Date()));
            advertiserFinanceNewDto.setEndTime(DateUtil.dateTo8String3((Date)new Date()));
        } else {
            advertiserFinanceNewDto.setStartTime(startTime);
            advertiserFinanceNewDto.setEndTime(endTime);
        }
        try {
            Pagination pageBean = this.adFinanceIntegration.getAdShopFinanceOnlyList(advertiserFinanceNewDto);
            rs.setReturnValue((Object)pageBean);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return rs;
    }

    @LogBefore(operType="/adFinance/exportAdFinance", keyName="\u5e7f\u544a")
    @RequestMapping(value={"exportAdFinance"}, method={RequestMethod.GET})
    public void exportAdvertiserFinance(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="advertiserId", required=true) Integer advertiserId) {
        AdvertiserFinanceNewDto advertiserFinanceNewDto = new AdvertiserFinanceNewDto();
        advertiserFinanceNewDto.setAdvertiserId(advertiserId);
        if (StringUtils.isEmpty((CharSequence)startTime) && StringUtils.isEmpty((CharSequence)endTime)) {
            advertiserFinanceNewDto.setStartTime(DateUtil.dateTo8String3((Date)new Date()));
            advertiserFinanceNewDto.setEndTime(DateUtil.dateTo8String3((Date)new Date()));
        } else {
            advertiserFinanceNewDto.setStartTime(startTime);
            advertiserFinanceNewDto.setEndTime(endTime);
        }
        ArrayList lists = null;
        try {
            lists = this.adFinanceIntegration.exportAdvertiserFinanceOnly(advertiserFinanceNewDto);
            if (null != lists) {
                for (AdvertiserFinanceVo record : lists) {
                    record.setStrCreated(DateUtil.dateTo14String((Date)record.getCreated()));
                }
            } else {
                lists = new ArrayList();
            }
        }
        catch (Exception e) {
            lists = new ArrayList();
        }
        ExcelUtil.exportExcel(lists, null, (String)"\u8d22\u52a1\u6d41\u6c34\u6570\u636e", AdvertiserFinanceVo.class, (String)"\u8d22\u52a1\u6d41\u6c34\u6570\u636e.xls", (HttpServletResponse)response);
    }

    @RequestMapping(value={"/getTicketConsumeInfoByAdvertiserId"})
    public ResultModel<AdvertiserTicketConsumeInfoVO> getTicketConsumeInfoByAdvertiserId(@RequestParam(name="advertiserIdsStr") String advertiserIdsStr, @RequestParam(name="beginDate") @DateTimeFormat(pattern="yyyy-MM-dd") Date beginDate, @RequestParam(name="endDate") @DateTimeFormat(pattern="yyyy-MM-dd") Date endDate) {
        try {
            List advertiserIds = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)advertiserIdsStr).stream().map(Long::valueOf).collect(Collectors.toList());
            return ResultModelFactory.SUCCESS((Serializable)this.adIncomeTicketService.getTicketConsumeInfoByAdvertiserIds(advertiserIds, beginDate, endDate));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5e7f\u544a\u4e3b\u67d0\u6bb5\u65f6\u95f4\u5185\u7684\u5238\u6d88\u8017\u8be6\u60c5\u5931\u8d25\uff01\uff01\uff01", (Throwable)e);
            return ResultModelFactory.FAIL400((String)e.getMessage());
        }
    }
}

