/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.advertiser;

import com.alibaba.fastjson.JSON;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dto.TblAdQualifyDto;
import com.bxm.adsmanager.model.enums.AdvertiserQualifyEnum;
import com.bxm.adsmanager.model.vo.TblAdQualifyVo;
import com.bxm.adsmanager.model.vo.tbltag.TblAdTagVo;
import com.bxm.adsmanager.service.advertiser.AdvertiserQualifyService;
import com.bxm.adsmanager.service.tbltag.TblAdTagService;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/advertiser"})
public class AdvertiserQualifyAuditController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserQualifyAuditController.class);
    @Autowired
    private AdvertiserQualifyService advertiserQualifyService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private TblAdTagService tblAdTagService;
    public static final String ADVERTISER_FLAG = "advertiser";
    public static final String QUERYFLAG = "1";

    @RequestMapping(value={"/getAdQualifyAuditList"}, method={RequestMethod.GET})
    @Deprecated
    public ResultModel<PageInfo<TblAdQualifyVo>> getAdQualifyList(HttpServletRequest request, TblAdQualifyDto param) {
        ResultModel resultModel = new ResultModel();
        if (null == param) {
            param = new TblAdQualifyDto();
        }
        param.setQueryFlag(QUERYFLAG);
        PageInfo adQualifyPageInfo = null;
        ArrayList<TblAdQualifyVo> adQualifyVoList = new ArrayList<TblAdQualifyVo>();
        Map<String, Object> advertiserMap = null;
        Map<Integer, String> tagNameMap = null;
        try {
            advertiserMap = this.getAllAdvertiser(param);
            if (advertiserMap == null) {
                advertiserMap = new HashMap<String, Object>();
            }
            if ((tagNameMap = this.getTagName(1, 9999, null, 3)) == null) {
                tagNameMap = new HashMap<Integer, String>();
            }
            if (StringUtil.isNotBlank((CharSequence)param.getKeywords()) && !StringUtil.isNumeric((CharSequence)param.getKeywords())) {
                ArrayList advertiserList = (ArrayList)advertiserMap.get("ids");
                if (CollectionUtils.isEmpty((Collection)advertiserList)) {
                    advertiserList = new ArrayList();
                }
                param.setAdvertiserList((List)advertiserList);
            }
            if (StringUtil.isNotBlank((CharSequence)param.getKeywords()) && StringUtil.isNumeric((CharSequence)param.getKeywords())) {
                param.setAdvertiserId(Long.valueOf(param.getKeywords()));
            }
            if ((adQualifyPageInfo = this.advertiserQualifyService.getAdQualifyList(param)) != null && !CollectionUtils.isEmpty((Collection)adQualifyPageInfo.getList())) {
                List list = adQualifyPageInfo.getList();
                TblAdQualifyVo adQualifyVo = null;
                for (TblAdQualify record : list) {
                    Object object;
                    adQualifyVo = new TblAdQualifyVo();
                    BeanUtils.copyProperties((Object)record, (Object)adQualifyVo);
                    if (record.getAdvertiserId() != null && (object = advertiserMap.get(String.valueOf(record.getAdvertiserId()))) != null) {
                        adQualifyVo.setAdvertiserName(String.valueOf(object));
                    }
                    adQualifyVo.setAdvertiserTypeStr(tagNameMap.get(record.getAdvertiserType()));
                    adQualifyVo.setQualifyNameStr(tagNameMap.get(record.getQualifyName()));
                    if (StringUtils.isNotBlank((CharSequence)record.getImage())) {
                        List<String> imgList = Arrays.asList(record.getImage().split(","));
                        adQualifyVo.setImgList(imgList);
                    }
                    adQualifyVoList.add(adQualifyVo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8d44\u8d28\u5217\u8868\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u8d44\u8d28\u5217\u8868\u4fe1\u606f\u51fa\u9519");
        }
        PageInfo newPageInfo = new PageInfo();
        if (adQualifyPageInfo == null) {
            adQualifyPageInfo = new PageInfo();
        }
        BeanUtils.copyProperties((Object)adQualifyPageInfo, (Object)newPageInfo);
        newPageInfo.setList(adQualifyVoList);
        resultModel.setReturnValue((Object)newPageInfo);
        return resultModel;
    }

    @RequestMapping(value={"/adQualifyById"}, method={RequestMethod.GET})
    public ResultModel<TblAdQualify> getAdQualifyById(HttpServletRequest request, @RequestParam(name="id", required=true) Integer id) {
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.advertiserQualifyService.getAdQualifyById(id));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
        }
        return resultModel;
    }

    @LogBefore(operType="/advertiser/auditAdQualifyById", keyName="\u5e7f\u544a\u4e3b\u8d44\u8d28\u5ba1\u6838")
    @RequestMapping(value={"/auditAdQualifyById"}, method={RequestMethod.POST})
    public ResultModel<Boolean> auditAdQualifyById(HttpServletRequest request, TblAdQualify param) {
        ResultModel resultModel = new ResultModel();
        if (param == null || param.getId() == null) {
            return ResultModelFactory.FAIL500((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getAuditStatus() == null) {
            return ResultModelFactory.FAIL500((String)"\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getAuditStatus().equals(AdvertiserQualifyEnum.REFUSE.getAuditStatus()) && StringUtils.isBlank((CharSequence)param.getRefuseReason())) {
            return ResultModelFactory.FAIL500((String)"\u8bf7\u586b\u5199\u5ba1\u6838\u62d2\u7edd\u539f\u56e0");
        }
        try {
            TblAdQualify record = new TblAdQualify();
            record.setId(param.getId());
            record.setAuditStatus(param.getAuditStatus());
            record.setRefuseReason(param.getRefuseReason());
            record.setRefuseRemark(param.getRefuseRemark());
            this.advertiserQualifyService.updateAdQualifyById(record);
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5ba1\u6838\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @LogBefore(operType="/advertiser/auditAdQualifySuccess", keyName="\u5e7f\u544a\u4e3b\u8d44\u8d28\u6279\u91cf\u5ba1\u6838\u901a\u8fc7")
    @RequestMapping(value={"/auditAdQualifySuccess"}, method={RequestMethod.POST})
    public ResultModel<Boolean> auditAdQualifySuccess(HttpServletRequest request, @RequestParam(name="ids", required=true) String ids) {
        ResultModel resultModel = new ResultModel();
        try {
            List parseArray = JSON.parseArray((String)ids, Integer.class);
            if (!CollectionUtils.isEmpty((Collection)parseArray)) {
                this.advertiserQualifyService.updateAuditStatusByIds(parseArray);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5ba1\u6838\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    @LogBefore(operType="/advertiser/auditAdQualifyRefuse", keyName="\u5e7f\u544a\u4e3b\u8d44\u8d28\u6279\u91cf\u5ba1\u6838\u62d2\u7edd")
    @RequestMapping(value={"/auditAdQualifyRefuse"}, method={RequestMethod.POST})
    public ResultModel<Boolean> auditAdQualifyRefuse(HttpServletRequest request, @RequestParam(name="ids", required=true) String ids, @RequestParam(name="refuseReason", required=true) String refuseReason) {
        ResultModel resultModel = new ResultModel();
        try {
            List idList = JSON.parseArray((String)ids, Integer.class);
            ArrayList<TblAdQualify> paramList = null;
            TblAdQualify record = null;
            if (!CollectionUtils.isEmpty((Collection)idList)) {
                paramList = new ArrayList<TblAdQualify>();
                for (Integer id : idList) {
                    record = new TblAdQualify();
                    record.setId(id);
                    record.setAuditStatus(AdvertiserQualifyEnum.REFUSE.getAuditStatus());
                    record.setRefuseReason(refuseReason);
                    paramList.add(record);
                }
            }
            if (!CollectionUtils.isEmpty(paramList)) {
                this.advertiserQualifyService.updateAuditStatusBatch(paramList);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u8d44\u8d28\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u5ba1\u6838\u8d44\u8d28\u4fe1\u606f\u51fa\u9519");
        }
        resultModel.setReturnValue((Object)true);
        return resultModel;
    }

    public Map<String, Object> getAllAdvertiser(TblAdQualifyDto param) throws Exception {
        AdvertiserDto search = new AdvertiserDto();
        if (StringUtil.isNotBlank((CharSequence)param.getKeywords()) && StringUtil.isNumeric((CharSequence)param.getKeywords())) {
            try {
                search.setId(Integer.valueOf(param.getKeywords()));
            }
            catch (NumberFormatException e) {
                search.setCompany(param.getKeywords());
            }
        } else {
            search.setCompany(param.getKeywords());
        }
        List list = this.adShopIntegration.getAdShopList(search);
        ArrayList<Long> advertiserIdList = new ArrayList<Long>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (AdvertiserDto record : list) {
                if (record.getId() == null) continue;
                resultMap.put(String.valueOf(record.getId()), record.getCompany());
                advertiserIdList.add(record.getId().longValue());
            }
            resultMap.put("ids", advertiserIdList);
        }
        return resultMap;
    }

    public Map<Integer, String> getTagName(Integer pageNum, Integer pageSize, String name, Integer type) {
        PageInfo tagPageInfo = this.tblAdTagService.findNewAll(pageNum, pageSize, name, type);
        HashMap<Integer, String> tagMap = new HashMap<Integer, String>();
        if (tagPageInfo != null && !CollectionUtils.isEmpty((Collection)tagPageInfo.getList())) {
            List tagList = tagPageInfo.getList();
            for (TblAdTagVo record : tagList) {
                tagMap.put(record.getId(), record.getName());
            }
        }
        return tagMap;
    }
}

