/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.adxadvertiserinfo;

import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.integration.utils.DateUtil;
import com.bxm.adsmanager.model.dao.bes.BesAdvertiserInfo;
import com.bxm.adsmanager.model.dto.bes.AdxAdvertiserSearchDTO;
import com.bxm.adsmanager.model.dto.bes.AuthHeader;
import com.bxm.adsmanager.model.dto.bes.BesBaseResponse;
import com.bxm.adsmanager.model.dto.bes.advertiser.BesAdvertiserAddDTO;
import com.bxm.adsmanager.model.dto.bes.advertiser.BesAdvertiserDTO;
import com.bxm.adsmanager.model.dto.bes.advertiser.BesAdvertiserGetDTO;
import com.bxm.adsmanager.model.dto.bes.advertiser.BesAdvertiserResultDTO;
import com.bxm.adsmanager.model.dto.bes.qualification.BesMainQualificationUpdateDTO;
import com.bxm.adsmanager.model.dto.bes.qualification.BesQualificationResultDTO;
import com.bxm.adsmanager.model.dto.bes.qualification.BesQueryQualificationInfoDTO;
import com.bxm.adsmanager.model.dto.bes.qualification.BesUploadQualificationDTO;
import com.bxm.adsmanager.model.enums.BesStatusEnum;
import com.bxm.adsmanager.model.vo.bes.BesAdvertiserInfoDetailVO;
import com.bxm.adsmanager.service.adxadvertiserinfo.AdxAdvertiserInfoService;
import com.bxm.adsmanager.utils.BesApiUtil;
import com.bxm.adsmanager.utils.FileUtils;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/besAdvertiserInfo"})
public class BesAdvertiserInfoController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BesAdvertiserInfoController.class);
    @Autowired
    private AdxAdvertiserInfoService adxAdvertiserInfoService;
    @Autowired
    private AuthHeader authHeader;
    @Autowired
    private AdShopIntegration adShopIntegration;

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo> findAll(HttpServletRequest request, HttpServletResponse response, AdxAdvertiserSearchDTO adxAdvertiserSearchDTO) {
        ResultModel rs = new ResultModel();
        try {
            adxAdvertiserSearchDTO.setAdxAdvertiserType(Integer.valueOf(1));
            PageInfo page = this.adxAdvertiserInfoService.findPage(adxAdvertiserSearchDTO);
            if (page != null) {
                rs.setSuccessed(true);
            }
            rs.setReturnValue((Object)page);
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u767e\u5ea6\u5e7f\u544a\u4e3b\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            rs.setSuccessed(false);
            rs.setErrorDesc("\u6839\u636e\u6761\u4ef6\u67e5\u627e\u767e\u5ea6\u5e7f\u544a\u4e3b\u4fe1\u606f\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public ResultModel<BesAdvertiserInfoDetailVO> get(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Integer id) throws Exception {
        ResultModel rs = new ResultModel();
        BesAdvertiserInfoDetailVO besAdvertiserInfoDetailVO = this.adxAdvertiserInfoService.getDetail(id);
        rs.setSuccessed(true);
        rs.setReturnValue((Object)besAdvertiserInfoDetailVO);
        return rs;
    }

    @RequestMapping(value={"/getBesAuditStatus"}, method={RequestMethod.GET})
    public ResultModel<Integer> getBesAuditStatus(@NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") @RequestParam(value="id") @NotNull(message="Id\u4e0d\u80fd\u4e3a\u7a7a\uff01") Integer id) throws Exception {
        ResultModel rs = new ResultModel();
        rs.setSuccessed(true);
        rs.setReturnValue((Object)this.adxAdvertiserInfoService.getBesAuditStatus(id));
        return rs;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel add(@RequestBody BesAdvertiserInfo besAdvertiserInfo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        besAdvertiserInfo.setAdxAdvertiserType(Integer.valueOf(1));
        this.adxAdvertiserInfoService.add(besAdvertiserInfo);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/audit"}, method={RequestMethod.POST})
    public ResultModel audit(@RequestBody BesAdvertiserInfo besAdvertiserInfo, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BesAdvertiserInfo entity = this.adxAdvertiserInfoService.get(besAdvertiserInfo.getId());
        if (1 != entity.getAdxAdvertiserType()) {
            throw new ValidateException("\u8be5\u63a5\u53e3\u53ea\u80fd\u63d0\u4ea4\u5ba1\u6838\u767e\u5ea6\u5e7f\u544a\u4e3b\uff01");
        }
        List adShopMsgs = this.adShopIntegration.findAdShopMsgs(String.valueOf(besAdvertiserInfo.getAdvertiserId()));
        if (CollectionUtils.isEmpty((Collection)adShopMsgs)) {
            throw new ValidateException("\u6ca1\u6709\u627e\u5230\u5e7f\u544a\u4e3b\u6570\u636e\uff01");
        }
        AdvertiserDto advertiserDto = (AdvertiserDto)adShopMsgs.get(0);
        BesBaseResponse advertiserCommintResponse = this.commintAdvertiserToBes(besAdvertiserInfo, advertiserDto);
        if (!advertiserCommintResponse.success()) {
            throw new ValidateException(advertiserCommintResponse.getDetailMessage());
        }
        BesBaseResponse commintQualificationInfoResponse = this.commintQualificationInfoToBes(besAdvertiserInfo, advertiserDto);
        if (!commintQualificationInfoResponse.success()) {
            throw new ValidateException(advertiserCommintResponse.getDetailMessage());
        }
        besAdvertiserInfo.setAuditState(Integer.valueOf(BesStatusEnum.PENDING.getLogicStatus()));
        this.adxAdvertiserInfoService.update(besAdvertiserInfo);
        return ResultModelFactory.SUCCESS();
    }

    private BesBaseResponse commintQualificationInfoToBes(BesAdvertiserInfo besAdvertiserInfo, AdvertiserDto advertiserDto) throws Exception {
        BesQueryQualificationInfoDTO besQueryQualificationInfoDTO = new BesQueryQualificationInfoDTO();
        besQueryQualificationInfoDTO.setAuthHeader(this.authHeader);
        besQueryQualificationInfoDTO.setAdvertiserId(Long.valueOf(besAdvertiserInfo.getAdvertiserId().longValue()));
        besQueryQualificationInfoDTO.setNeedLicenceImgUrl(Boolean.FALSE);
        BesQualificationResultDTO queryQualificationInfoResult = BesApiUtil.queryQualificationInfo((BesQueryQualificationInfoDTO)besQueryQualificationInfoDTO);
        BesUploadQualificationDTO.APIAdvertiserLicence apiAdvertiserLicence = new BesUploadQualificationDTO.APIAdvertiserLicence();
        apiAdvertiserLicence.setType(besAdvertiserInfo.getLicenceType());
        apiAdvertiserLicence.setName(besAdvertiserInfo.getAdvertiserName());
        apiAdvertiserLicence.setNumber(advertiserDto.getBusinessLicenseNo());
        String validDate = "2030-12-31";
        if (besAdvertiserInfo.getValidDate() != null) {
            validDate = DateUtil.dateTo8String((Date)besAdvertiserInfo.getValidDate());
        }
        apiAdvertiserLicence.setValidDate(validDate);
        ArrayList<byte[]> imgDatas = new ArrayList<byte[]>(3);
        String imgUrl = advertiserDto.getBusinessLicenseImg();
        if (StringUtils.isNotBlank((CharSequence)imgUrl)) {
            int fileLength = FileUtils.getFileLength((String)imgUrl);
            try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
                if (fileLength / 1024 >= 2048) {
                    Thumbnails.of((URL[])new URL[]{new URL(imgUrl)}).scale(1.0).outputQuality(0.5f).toOutputStream((OutputStream)outStream);
                } else {
                    Thumbnails.of((URL[])new URL[]{new URL(imgUrl)}).scale(1.0).toOutputStream((OutputStream)outStream);
                }
                byte[] bytes = outStream.toByteArray();
                imgDatas.add(bytes);
            }
            catch (Exception e) {
                throw new ValidateException((Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)besAdvertiserInfo.getSupplementLicenseImg())) {
            String[] split;
            for (String img : split = besAdvertiserInfo.getSupplementLicenseImg().split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)img)) continue;
                byte[] bytes = IOUtils.toByteArray((URL)new URL(img));
                imgDatas.add(bytes);
            }
        }
        if (CollectionUtils.isEmpty(imgDatas)) {
            throw new ValidateException("\u5e7f\u544a\u4e3b\u8d44\u8d28\u56fe\u7247\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6838\uff01");
        }
        apiAdvertiserLicence.setImgDatas(imgDatas);
        BesQualificationResultDTO.APIAdvertiserQualificationInfo qualification = queryQualificationInfoResult.getQualification();
        if (qualification != null && qualification.getMainLicence() != null) {
            BesMainQualificationUpdateDTO request = new BesMainQualificationUpdateDTO();
            request.setAuthHeader(this.authHeader);
            BesMainQualificationUpdateDTO.APIAdvertiserMainQualificationUpdate apiAdvertiserMainQualificationUpdate = new BesMainQualificationUpdateDTO.APIAdvertiserMainQualificationUpdate();
            apiAdvertiserMainQualificationUpdate.setAdvertiserId(Long.valueOf(besAdvertiserInfo.getAdvertiserId().longValue()));
            apiAdvertiserMainQualificationUpdate.setMainLicence(apiAdvertiserLicence);
            request.setQualification(apiAdvertiserMainQualificationUpdate);
            return BesApiUtil.updateMainQualification((BesMainQualificationUpdateDTO)request);
        }
        BesUploadQualificationDTO.APIAdvertiserQualificationUpload apiAdvertiserQualificationUpload = new BesUploadQualificationDTO.APIAdvertiserQualificationUpload();
        apiAdvertiserQualificationUpload.setAdvertiserId(Long.valueOf(besAdvertiserInfo.getAdvertiserId().longValue()));
        apiAdvertiserQualificationUpload.setMainLicence(apiAdvertiserLicence);
        BesUploadQualificationDTO request = new BesUploadQualificationDTO();
        request.setAuthHeader(this.authHeader);
        request.setQualifications(Arrays.asList(apiAdvertiserQualificationUpload));
        return BesApiUtil.uploadQualification((BesUploadQualificationDTO)request);
    }

    private BesBaseResponse commintAdvertiserToBes(BesAdvertiserInfo besAdvertiserInfo, AdvertiserDto advertiserDto) {
        BesAdvertiserGetDTO besAdvertiserGetDTO = new BesAdvertiserGetDTO();
        besAdvertiserGetDTO.setAdvertiserIds(Arrays.asList(besAdvertiserInfo.getAdvertiserId().longValue()));
        besAdvertiserGetDTO.setAuthHeader(this.authHeader);
        BesAdvertiserDTO besAdvertiserDTO = new BesAdvertiserDTO();
        besAdvertiserDTO.setAdvertiserId(Long.valueOf(besAdvertiserInfo.getAdvertiserId().longValue()));
        besAdvertiserDTO.setAdvertiserLiteName(advertiserDto.getCompany());
        besAdvertiserDTO.setAdvertiserName(besAdvertiserInfo.getAdvertiserName());
        besAdvertiserDTO.setSiteName(besAdvertiserInfo.getSiteName());
        besAdvertiserDTO.setSiteUrl(besAdvertiserInfo.getSiteUrl());
        BesAdvertiserAddDTO besAdvertiserAddDTO = new BesAdvertiserAddDTO();
        besAdvertiserAddDTO.setRequest(Arrays.asList(besAdvertiserDTO));
        besAdvertiserAddDTO.setAuthHeader(this.authHeader);
        BesAdvertiserResultDTO advertiser = BesApiUtil.getAdvertiser((BesAdvertiserGetDTO)besAdvertiserGetDTO);
        if (advertiser.success() && CollectionUtils.isNotEmpty((Collection)advertiser.getResponse())) {
            return BesApiUtil.updateAdvertiser((BesAdvertiserAddDTO)besAdvertiserAddDTO);
        }
        return BesApiUtil.addAdvertiser((BesAdvertiserAddDTO)besAdvertiserAddDTO);
    }
}

