/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.agencychannel;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.model.dao.agencychannel.AgencyChannel;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AgencyChannelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelImportExcelDTO;
import com.bxm.adsmanager.model.dto.AgencyChannelSearchDTO;
import com.bxm.adsmanager.model.dto.OcpxRtbConfigDto;
import com.bxm.adsmanager.service.agencychannel.AgencyChannelService;
import com.bxm.adsmanager.utils.BeanValidator;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/agencyChannel"})
public class AgencyChannelController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyChannelController.class);
    @Autowired
    private AgencyChannelService agencyChannelService;

    @LogBefore(operType="/agencyChannel/add", keyName="\u4ee3\u7406\u6e20\u9053\u6dfb\u52a0")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel add(@RequestBody AgencyChannelDTO agencyChannelDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        try {
            if (BeanValidator.validateGroup((Object)agencyChannelDto, (Class[])new Class[]{AgencyChannelDTO.Add.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)agencyChannelDto, (Class[])new Class[]{AgencyChannelDTO.Add.class}).getMessage());
            }
            agencyChannelDto.setBelonger(user.getUsername());
            Long positionAssetSizeId = this.agencyChannelService.add(agencyChannelDto);
            return ResultModelFactory.SUCCESS((Serializable)positionAssetSizeId);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u4ee3\u7406\u6e20\u9053\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)"\u8be5\u6e20\u9053\u53f7\u6216DP\u94fe\u63a5\u5df2\u5b58\u5728");
            }
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u51fa\u9519");
        }
    }

    @LogBefore(operType="/agencyChannel/update", keyName="\u4ee3\u7406\u6e20\u9053\u66f4\u65b0")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResultModel update(@RequestBody AgencyChannelDTO agencyChannelDto, HttpServletRequest request, HttpServletResponse response) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        if (agencyChannelDto == null || agencyChannelDto.getId() == null) {
            return ResultModelFactory.FAIL400((String)"\u4ee3\u7406\u6e20\u9053id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (BeanValidator.validateGroup((Object)agencyChannelDto, (Class[])new Class[]{AgencyChannelDTO.Update.class}) != null) {
                return ResultModelFactory.FAIL400((String)BeanValidator.validateGroup((Object)agencyChannelDto, (Class[])new Class[]{AgencyChannelDTO.Update.class}).getMessage());
            }
            Integer result = this.agencyChannelService.update(agencyChannelDto, user);
            rs.setReturnValue((Object)result);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)"\u8be5\u6e20\u9053\u53f7\u6216DP\u94fe\u63a5\u5df2\u5b58\u5728");
            }
            return ResultModelFactory.FAIL500((String)"\u66f4\u65b0\u4ee3\u7406\u6e20\u9053\u51fa\u9519");
        }
        return rs;
    }

    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AgencyChannel>> findAll(HttpServletRequest request, HttpServletResponse response, AgencyChannelSearchDTO searchDto) {
        User user = this.getUser(request, response);
        ResultModel rs = new ResultModel();
        try {
            PageInfo result = this.agencyChannelService.findAll(searchDto, user);
            rs.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u4ee3\u7406\u6e20\u9053\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u627e\u4ee3\u7406\u6e20\u9053\u51fa\u9519");
        }
        return rs;
    }

    @LogBefore(operType="/agencyChannel/delete", keyName="\u4ee3\u7406\u6e20\u9053\u5220\u9664")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public ResultModel delete(HttpServletRequest request, HttpServletResponse response, @RequestParam(required=true, name="id") Long id) {
        User user = this.getUser(request, response);
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setSuccessed(this.agencyChannelService.delete(id, user));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u5220\u9664\u5931\u8d25");
        }
        return resultModel;
    }

    @LogBefore(operType="/agencyChannel/import", keyName="\u5bfc\u5165\u4ee3\u7406\u6e20\u9053")
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ResultModel<String> importData(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file") MultipartFile file) {
        User user = this.getUser(request, response);
        try {
            ImportParams importParams = new ImportParams();
            List list = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), AgencyChannelImportExcelDTO.class, (ImportParams)importParams);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            }
            this.agencyChannelService.importData(list, user);
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519" + e.getMessage(), (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException) {
                return ResultModelFactory.FAIL500((String)"\u6587\u4ef6\u4e2d\u5df2\u6709\u6e20\u9053\u6536\u5165\u6570\u636e\u5f55\u5165");
            }
            return ResultModelFactory.FAIL500((String)"\u5bfc\u5165\u4ee3\u7406\u6e20\u9053\u6570\u636e\u51fa\u9519");
        }
        return ResultModelFactory.SUCCESS();
    }

    @LogBefore(operType="/agencyChannel/ocpxConfig/update", keyName="ocpx-rtb\u914d\u7f6e\u7f16\u8f91")
    @RequestMapping(value={"/ocpxConfig/update"}, method={RequestMethod.POST})
    public ResultModel<String> updateOcpxConfig(@Validated @RequestBody OcpxRtbConfigDto ocpxRtbConfigDto) {
        this.checkUpdateOcpxConfig(ocpxRtbConfigDto);
        try {
            String url = this.agencyChannelService.updateOcpxConfig(ocpxRtbConfigDto);
            return ResultModelFactory.SUCCESS((Serializable)((Object)url));
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u7cfb\u7edf\u9519\u8bef");
        }
    }

    private void checkUpdateOcpxConfig(OcpxRtbConfigDto ocpxRtbConfigDto) {
        Double rate = ocpxRtbConfigDto.getRate();
        if (Objects.nonNull(ocpxRtbConfigDto.getStrategyType()) && ocpxRtbConfigDto.getStrategyType() == 2) {
            Preconditions.checkArgument((Objects.nonNull(rate) && rate > 0.0 && rate <= 100.0 ? 1 : 0) != 0, (Object)"rate\u6709\u8bef");
        }
        if (ocpxRtbConfigDto.getTargetType() == 2) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ocpxRtbConfigDto.getTargetTwoRtb()), (Object)"targetTwoRtb\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)ocpxRtbConfigDto.getRelateTwoRtb()), (Object)"relateTwoRtb\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

