/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsmanager.web.controller.audit;

import com.bxm.adsmanager.dal.mapper.adkeeper.AdTicketTagConfMapper;
import com.bxm.adsmanager.dal.mapper.advertiser.ext.TblAdQualifyMapperExt;
import com.bxm.adsmanager.ecxeption.BusinessException;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserAuditVo;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserDto;
import com.bxm.adsmanager.integration.advertiser.model.AdvertiserMainInfoVo;
import com.bxm.adsmanager.integration.advertiser.service.AdShopIntegration;
import com.bxm.adsmanager.model.dao.advertiser.TblAdQualify;
import com.bxm.adsmanager.model.dao.user.User;
import com.bxm.adsmanager.model.dto.AdTicketAuditSearchDTO;
import com.bxm.adsmanager.model.vo.AdTicketAuditVo;
import com.bxm.adsmanager.model.vo.AdvertiserQualifyInfoVo;
import com.bxm.adsmanager.service.audit.AdAuditService;
import com.bxm.adsmanager.service.audit.AdvertiserAuditService;
import com.bxm.adsmanager.service.audit.impl.AdAuditServiceImpl;
import com.bxm.adsmanager.utils.ResultModelFactory;
import com.bxm.adsmanager.web.controller.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.bxm.warcar.aspect.before.LogBefore;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adAudit"})
public class AdAuditController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(AdAuditController.class);
    @Autowired
    private AdAuditService adAuditService;
    @Autowired
    private AdvertiserAuditService advertiserAuditService;
    @Autowired
    private AdShopIntegration adShopIntegration;
    @Autowired
    private JedisFetcher jedisFetcher;
    @Autowired
    private JedisUpdater jedisUpdater;
    @Autowired
    private AdTicketTagConfMapper adTicketTagConfMapper;
    @Autowired
    private TblAdQualifyMapperExt adQualifyMapperExt;
    private static final ReentrantLock EXPORT_IMG_LOCK = new ReentrantLock();
    public static final String FORMAT_EXCEL = "excel";
    public static final String FORMAT_IMG = "img";

    @GetMapping(value={"/listAdvertiserAudit"})
    public ResultModel listAdvertiserAudit(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(name="accountType", required=false) Byte accountType, @RequestParam(name="areaType", required=false) Integer areaType, @RequestParam(name="advertiserIdOrName", required=false) String advertiserIdOrName, @RequestParam(name="advertiserStatus", required=false) Byte advertiserStatus, @RequestParam(name="qualifyStatus", required=false) Integer qualifyStatus, @RequestParam(name="expireStatus", required=false) Integer expireStatus) {
        PageInfo pageInfo = this.advertiserAuditService.listAdvertiserAudit(pageNum, pageSize, accountType, advertiserIdOrName, advertiserStatus, qualifyStatus, expireStatus, areaType);
        return ResultModelFactory.SUCCESS((Serializable)pageInfo);
    }

    @LogBefore(operType="/adAudit/advertiserAudit", keyName="\u5e7f\u544a\u4e3b\u4e3b\u4f53\u5ba1\u6838")
    @PostMapping(value={"/advertiserAudit"})
    public ResultModel<Boolean> advertiserAudit(@RequestParam(value="id") Integer id, @RequestParam(value="isPass") Integer isPass, @RequestParam(value="refuseReason", required=false) String refuseReason, @RequestParam(value="refuseRemark", required=false) String refuseRemark) {
        return this.adShopIntegration.advertiserAudit(id, isPass, refuseReason, refuseRemark);
    }

    @GetMapping(value={"/getAdvertiserMainInfo"})
    public ResultModel<AdvertiserMainInfoVo> getAdvertiserMainInfo(@RequestParam(value="id") Integer id) {
        AdvertiserMainInfoVo advertiserMainInfo = this.adShopIntegration.getAdvertiserMainInfo(id);
        return ResultModelFactory.SUCCESS((Serializable)advertiserMainInfo);
    }

    @GetMapping(value={"/getQualifyInfo"})
    public ResultModel<AdvertiserQualifyInfoVo> getQualifyInfo(@RequestParam(value="qualityId") Integer qualityId) {
        AdvertiserQualifyInfoVo vo = this.advertiserAuditService.getQualifyInfo(qualityId);
        return ResultModelFactory.SUCCESS((Serializable)vo);
    }

    @GetMapping(value={"/getQualifyList"})
    public ResultModel<PageInfo<AdvertiserQualifyInfoVo>> getQualifyList(@RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="20") Integer pageSize, @RequestParam(value="advertiserId") Integer advertiserId, @RequestParam(value="auditStatus", required=false) Integer auditStatus, @RequestParam(value="content", required=false) String content) {
        PageInfo pageInfo = this.advertiserAuditService.getQualifyList(pageNum, pageSize, advertiserId, auditStatus, content);
        return ResultModelFactory.SUCCESS((Serializable)pageInfo);
    }

    @PostMapping(value={"/updateQualifyRemark"})
    public ResultModel<Boolean> updateQualifyRemark(@RequestParam(value="qualifyId") Integer qualifyId, @RequestParam(value="remark", required=false) String remark) {
        this.advertiserAuditService.updateQualifyRemark(qualifyId, remark);
        return ResultModelFactory.SUCCESS();
    }

    @RequestMapping(value={"/getWaitCheckList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AdTicketAuditVo>> getTicketAuditList(AdTicketAuditSearchDTO adTicketAuditSearchDTO) {
        ResultModel resultModel = new ResultModel();
        try {
            List<Long> targetRemarkTickets = this.getTargetRemarkTickets(adTicketAuditSearchDTO.getRemark());
            if (null != adTicketAuditSearchDTO.getTagCode()) {
                List targetTagTicketIds = this.adTicketTagConfMapper.findTicketIdByTagCode(adTicketAuditSearchDTO.getTagCode());
                if (targetRemarkTickets == null) {
                    targetRemarkTickets = new ArrayList<Long>();
                    targetRemarkTickets.addAll(targetTagTicketIds);
                } else {
                    targetRemarkTickets.retainAll(targetTagTicketIds);
                }
            }
            if (StringUtils.isNotBlank((String)adTicketAuditSearchDTO.getStartTime()) && StringUtils.isNotBlank((String)adTicketAuditSearchDTO.getEndTime())) {
                adTicketAuditSearchDTO.setStartTime(adTicketAuditSearchDTO.getStartTime() + " 00:00:00");
                adTicketAuditSearchDTO.setEndTime(adTicketAuditSearchDTO.getEndTime() + " 23:59:59");
            }
            adTicketAuditSearchDTO.setTicketIdList(targetRemarkTickets);
            PageInfo page = this.adAuditService.getTicketAuditList(adTicketAuditSearchDTO);
            resultModel.setReturnValue((Object)page);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5f85\u5ba1\u6838\u5238\u5217\u8868\u4fe1\u606f\u51fa\u9519" + e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)"\u67e5\u8be2\u5f85\u5ba1\u6838\u5238\u5217\u8868\u4fe1\u606f\u51fa\u9519");
        }
        return resultModel;
    }

    @PostMapping(value={"/updateTicketRemark"})
    public ResultModel<Boolean> updateTicketRemark(@RequestParam(value="ticketId") Integer ticketId, @RequestParam(value="remark", required=false) String remark) {
        try {
            if (null == remark) {
                remark = "";
            }
            this.adAuditService.updateTicketRemark(ticketId, remark);
        }
        catch (Exception e) {
            return ResultModelFactory.FAIL500((String)"\u5907\u6ce8\u66f4\u65b0\u5931\u8d25");
        }
        return ResultModelFactory.SUCCESS();
    }

    @PostMapping(value={"/updateLoadingPageImg"})
    public ResultModel updateLoadingPageImg(@RequestParam(value="ticketId") Integer ticketId, @RequestParam(value="url") String url) {
        if (StringUtils.isNotBlank((String)url)) {
            this.jedisUpdater.hupdate(AdAuditServiceImpl.loadingPageScreenShotUrl(), ticketId.toString(), (Object)url);
        }
        return ResultModelFactory.SUCCESS();
    }

    public List<Long> getTargetRemarkTickets(String remark) {
        if (StringUtils.isBlank((String)remark)) {
            return null;
        }
        ArrayList<Long> ticketIds = new ArrayList<Long>();
        Map allRemark = this.jedisFetcher.hfetchall(AdAuditServiceImpl.ticketRemark(), String.class);
        allRemark.forEach((k, v) -> {
            if (v.contains(remark)) {
                ticketIds.add(Long.valueOf(k));
            }
        });
        return ticketIds;
    }

    @LogBefore(operType="/adAudit/assetsAudit", keyName="\u7d20\u6750\u5ba1\u6838")
    @PostMapping(value={"/assetsAudit"})
    public ResultModel<Boolean> asstesAudit(@RequestParam(value="id", required=false) Integer id, @RequestParam(value="ids", required=false) List<Long> ids, @RequestParam(value="auditStatus") Short auditStatus, @RequestParam(value="refuseReason", required=false) String refuseReason, @RequestParam(value="ticketType", required=false) Integer ticketType, HttpServletRequest request, HttpServletResponse response) {
        try {
            User user = this.getUser(request, response);
            this.adAuditService.asstesAudit(id, ids, auditStatus, refuseReason, ticketType, (short)1, user.getUsername());
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        return ResultModelFactory.SUCCESS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/exportQualityImgs"})
    public ResultModel<String> exportQuality(@RequestParam(value="advertiserIds", required=false) String advertiserIds, @RequestParam(value="format", required=false, defaultValue="excel") String format, HttpServletResponse response) {
        if (StringUtils.isBlank((String)advertiserIds)) {
            format = FORMAT_EXCEL;
        }
        boolean tryLock = false;
        try {
            tryLock = EXPORT_IMG_LOCK.tryLock();
            if (!tryLock) {
                ResultModel<String> resultModel = null;
                return resultModel;
            }
            if (Objects.equals(format, FORMAT_EXCEL)) {
                this.advertiserAuditService.exportImgsUseExcel(advertiserIds, response);
            }
            if (Objects.equals(format, FORMAT_IMG)) {
                this.advertiserAuditService.exportImgsUseZip(advertiserIds, response);
            }
            ResultModel resultModel = ResultModelFactory.SUCCESS();
            return resultModel;
        }
        catch (NumberFormatException e) {
            ResultModel resultModel = ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u4e3bid\u8f93\u5165\u9519\u8bef, \u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e");
            return resultModel;
        }
        catch (BusinessException e) {
            ResultModel resultModel = ResultModelFactory.FAIL500((String)e.getMessage());
            return resultModel;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            ResultModel resultModel = ResultModelFactory.FAIL500((String)("\u670d\u52a1\u5668\u9519\u8bef\uff1a" + e.getMessage()));
            return resultModel;
        }
        finally {
            if (tryLock) {
                EXPORT_IMG_LOCK.unlock();
            }
        }
    }

    @GetMapping(value={"/checkExport"})
    public ResultModel<String> exportImgs1(@RequestParam(value="advertiserIds", required=false) String advertiserIds) {
        try {
            List<Object> searchAdvertiserIds = Lists.newArrayList();
            if (StringUtils.isNotBlank((String)advertiserIds)) {
                if (StringUtils.contains((String)advertiserIds, (String)" ")) {
                    return ResultModelFactory.FAIL400((String)"\u5e7f\u544a\u4e3bid\u4e0d\u80fd\u6709\u7a7a\u683c\uff01");
                }
                searchAdvertiserIds = Arrays.asList(advertiserIds.split(",")).stream().map(a -> Long.valueOf(a)).collect(Collectors.toList());
            }
            List advertiserList = this.adShopIntegration.getAdShopList(new AdvertiserDto());
            Map<Object, Object> advertiserNameMap = Maps.newHashMap();
            advertiserNameMap = advertiserList.stream().collect(Collectors.toMap(AdvertiserDto::getId, a -> a.getCompany() == null ? "" : a.getCompany()));
            StringBuilder notExistAdvertiser = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)searchAdvertiserIds)) {
                for (Long l : searchAdvertiserIds) {
                    if (advertiserNameMap.containsKey(l.intValue())) continue;
                    notExistAdvertiser.append(l).append("  ");
                }
            }
            if (StringUtils.isNotBlank((String)notExistAdvertiser.toString())) {
                return ResultModelFactory.FAIL500((String)("\u4e0d\u5b58\u5728\u7684\u5e7f\u544a\u4e3bid:" + notExistAdvertiser.toString()));
            }
            return ResultModelFactory.SUCCESS();
        }
        catch (NumberFormatException e) {
            return ResultModelFactory.FAIL500((String)"\u5e7f\u544a\u4e3bid\u8f93\u5165\u9519\u8bef, \u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e");
        }
        catch (BusinessException e) {
            return ResultModelFactory.FAIL500((String)e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return ResultModelFactory.FAIL500((String)("\u670d\u52a1\u5668\u9519\u8bef\uff1a" + e.getMessage()));
        }
    }

    @GetMapping(value={"/getAdvertiserQualifyInfo"}, produces={"application/json"})
    public ResultModel getAdvertiserQualifyInfo(@RequestParam(value="advertiserId") Integer advertiserId) {
        AdvertiserAuditVo advertiserQualifyInfo = this.advertiserAuditService.getAdvertiserQualifyInfo(advertiserId);
        return ResultModelFactory.SUCCESS((Serializable)advertiserQualifyInfo);
    }

    @PostMapping(value={"/updateSpecialApproval"}, produces={"application/json"})
    public ResultModel updateSpecialApproval(@RequestParam(value="advertiserId") Integer advertiserId, @RequestParam(value="specialApproval") Byte specialApproval) {
        if (!this.checkUpdateSpecialApproval(advertiserId, specialApproval)) {
            return ResultModelFactory.FAIL400((String)"\u4e3b\u4f53\u4fe1\u606f\u548c\u8d44\u8d28\u4fe1\u606f\u5747\u6709\u4e00\u6761\u5ba1\u6838\u901a\u8fc7\u624d\u53ef\u6253\u6807");
        }
        return this.advertiserAuditService.updateSpecialApproval(advertiserId, specialApproval);
    }

    boolean checkUpdateSpecialApproval(Integer advertiserId, Byte specialApproval) {
        if (Objects.equals(specialApproval, (byte)0)) {
            return true;
        }
        AdvertiserMainInfoVo advertiserMainInfo = this.adShopIntegration.getAdvertiserMainInfo(advertiserId);
        if (Objects.equals(advertiserMainInfo.getStatus(), (byte)1)) {
            List qualifys = this.adQualifyMapperExt.getQualifyByAdvertiserIds((List)Lists.newArrayList((Object[])new Long[]{advertiserId.longValue()}));
            for (TblAdQualify qualify : qualifys) {
                Integer auditStatus = qualify.getAuditStatus();
                if (!Objects.equals(1, auditStatus)) continue;
                return true;
            }
        }
        return false;
    }
}

